/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTopicRefreshScheduleRequest extends QuickSightRequest implements
        ToCopyableBuilder<UpdateTopicRefreshScheduleRequest.Builder, UpdateTopicRefreshScheduleRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(UpdateTopicRefreshScheduleRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> TOPIC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TopicId").getter(getter(UpdateTopicRefreshScheduleRequest::topicId)).setter(setter(Builder::topicId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("TopicId").build()).build();

    private static final SdkField<String> DATASET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetId").getter(getter(UpdateTopicRefreshScheduleRequest::datasetId))
            .setter(setter(Builder::datasetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DatasetId").build()).build();

    private static final SdkField<TopicRefreshSchedule> REFRESH_SCHEDULE_FIELD = SdkField
            .<TopicRefreshSchedule> builder(MarshallingType.SDK_POJO).memberName("RefreshSchedule")
            .getter(getter(UpdateTopicRefreshScheduleRequest::refreshSchedule)).setter(setter(Builder::refreshSchedule))
            .constructor(TopicRefreshSchedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshSchedule").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            TOPIC_ID_FIELD, DATASET_ID_FIELD, REFRESH_SCHEDULE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String awsAccountId;

    private final String topicId;

    private final String datasetId;

    private final TopicRefreshSchedule refreshSchedule;

    private UpdateTopicRefreshScheduleRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.topicId = builder.topicId;
        this.datasetId = builder.datasetId;
        this.refreshSchedule = builder.refreshSchedule;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that contains the topic whose refresh schedule you want to update.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that contains the topic whose refresh schedule you want to
     *         update.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The ID of the topic that you want to modify. This ID is unique per Amazon Web Services Region for each Amazon Web
     * Services account.
     * </p>
     * 
     * @return The ID of the topic that you want to modify. This ID is unique per Amazon Web Services Region for each
     *         Amazon Web Services account.
     */
    public final String topicId() {
        return topicId;
    }

    /**
     * <p>
     * The ID of the dataset.
     * </p>
     * 
     * @return The ID of the dataset.
     */
    public final String datasetId() {
        return datasetId;
    }

    /**
     * <p>
     * The definition of a refresh schedule.
     * </p>
     * 
     * @return The definition of a refresh schedule.
     */
    public final TopicRefreshSchedule refreshSchedule() {
        return refreshSchedule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(topicId());
        hashCode = 31 * hashCode + Objects.hashCode(datasetId());
        hashCode = 31 * hashCode + Objects.hashCode(refreshSchedule());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTopicRefreshScheduleRequest)) {
            return false;
        }
        UpdateTopicRefreshScheduleRequest other = (UpdateTopicRefreshScheduleRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(topicId(), other.topicId())
                && Objects.equals(datasetId(), other.datasetId()) && Objects.equals(refreshSchedule(), other.refreshSchedule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTopicRefreshScheduleRequest").add("AwsAccountId", awsAccountId())
                .add("TopicId", topicId()).add("DatasetId", datasetId()).add("RefreshSchedule", refreshSchedule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "TopicId":
            return Optional.ofNullable(clazz.cast(topicId()));
        case "DatasetId":
            return Optional.ofNullable(clazz.cast(datasetId()));
        case "RefreshSchedule":
            return Optional.ofNullable(clazz.cast(refreshSchedule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("TopicId", TOPIC_ID_FIELD);
        map.put("DatasetId", DATASET_ID_FIELD);
        map.put("RefreshSchedule", REFRESH_SCHEDULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateTopicRefreshScheduleRequest, T> g) {
        return obj -> g.apply((UpdateTopicRefreshScheduleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QuickSightRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateTopicRefreshScheduleRequest> {
        /**
         * <p>
         * The ID of the Amazon Web Services account that contains the topic whose refresh schedule you want to update.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the Amazon Web Services account that contains the topic whose refresh schedule you want to
         *        update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The ID of the topic that you want to modify. This ID is unique per Amazon Web Services Region for each Amazon
         * Web Services account.
         * </p>
         * 
         * @param topicId
         *        The ID of the topic that you want to modify. This ID is unique per Amazon Web Services Region for each
         *        Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicId(String topicId);

        /**
         * <p>
         * The ID of the dataset.
         * </p>
         * 
         * @param datasetId
         *        The ID of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetId(String datasetId);

        /**
         * <p>
         * The definition of a refresh schedule.
         * </p>
         * 
         * @param refreshSchedule
         *        The definition of a refresh schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshSchedule(TopicRefreshSchedule refreshSchedule);

        /**
         * <p>
         * The definition of a refresh schedule.
         * </p>
         * This is a convenience method that creates an instance of the {@link TopicRefreshSchedule.Builder} avoiding
         * the need to create one manually via {@link TopicRefreshSchedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TopicRefreshSchedule.Builder#build()} is called immediately and
         * its result is passed to {@link #refreshSchedule(TopicRefreshSchedule)}.
         * 
         * @param refreshSchedule
         *        a consumer that will call methods on {@link TopicRefreshSchedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #refreshSchedule(TopicRefreshSchedule)
         */
        default Builder refreshSchedule(Consumer<TopicRefreshSchedule.Builder> refreshSchedule) {
            return refreshSchedule(TopicRefreshSchedule.builder().applyMutation(refreshSchedule).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String topicId;

        private String datasetId;

        private TopicRefreshSchedule refreshSchedule;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTopicRefreshScheduleRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            topicId(model.topicId);
            datasetId(model.datasetId);
            refreshSchedule(model.refreshSchedule);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getTopicId() {
            return topicId;
        }

        public final void setTopicId(String topicId) {
            this.topicId = topicId;
        }

        @Override
        public final Builder topicId(String topicId) {
            this.topicId = topicId;
            return this;
        }

        public final String getDatasetId() {
            return datasetId;
        }

        public final void setDatasetId(String datasetId) {
            this.datasetId = datasetId;
        }

        @Override
        public final Builder datasetId(String datasetId) {
            this.datasetId = datasetId;
            return this;
        }

        public final TopicRefreshSchedule.Builder getRefreshSchedule() {
            return refreshSchedule != null ? refreshSchedule.toBuilder() : null;
        }

        public final void setRefreshSchedule(TopicRefreshSchedule.BuilderImpl refreshSchedule) {
            this.refreshSchedule = refreshSchedule != null ? refreshSchedule.build() : null;
        }

        @Override
        public final Builder refreshSchedule(TopicRefreshSchedule refreshSchedule) {
            this.refreshSchedule = refreshSchedule;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTopicRefreshScheduleRequest build() {
            return new UpdateTopicRefreshScheduleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
