/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options that style a section.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SectionStyle implements SdkPojo, Serializable, ToCopyableBuilder<SectionStyle.Builder, SectionStyle> {
    private static final SdkField<String> HEIGHT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Height")
            .getter(getter(SectionStyle::height)).setter(setter(Builder::height))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Height").build()).build();

    private static final SdkField<Spacing> PADDING_FIELD = SdkField.<Spacing> builder(MarshallingType.SDK_POJO)
            .memberName("Padding").getter(getter(SectionStyle::padding)).setter(setter(Builder::padding))
            .constructor(Spacing::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Padding").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEIGHT_FIELD, PADDING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String height;

    private final Spacing padding;

    private SectionStyle(BuilderImpl builder) {
        this.height = builder.height;
        this.padding = builder.padding;
    }

    /**
     * <p>
     * The height of a section.
     * </p>
     * <p>
     * Heights can only be defined for header and footer sections. The default height margin is 0.5 inches.
     * </p>
     * 
     * @return The height of a section.</p>
     *         <p>
     *         Heights can only be defined for header and footer sections. The default height margin is 0.5 inches.
     */
    public final String height() {
        return height;
    }

    /**
     * <p>
     * The spacing between section content and its top, bottom, left, and right edges.
     * </p>
     * <p>
     * There is no padding by default.
     * </p>
     * 
     * @return The spacing between section content and its top, bottom, left, and right edges.</p>
     *         <p>
     *         There is no padding by default.
     */
    public final Spacing padding() {
        return padding;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(height());
        hashCode = 31 * hashCode + Objects.hashCode(padding());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SectionStyle)) {
            return false;
        }
        SectionStyle other = (SectionStyle) obj;
        return Objects.equals(height(), other.height()) && Objects.equals(padding(), other.padding());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SectionStyle").add("Height", height()).add("Padding", padding()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Height":
            return Optional.ofNullable(clazz.cast(height()));
        case "Padding":
            return Optional.ofNullable(clazz.cast(padding()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Height", HEIGHT_FIELD);
        map.put("Padding", PADDING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SectionStyle, T> g) {
        return obj -> g.apply((SectionStyle) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SectionStyle> {
        /**
         * <p>
         * The height of a section.
         * </p>
         * <p>
         * Heights can only be defined for header and footer sections. The default height margin is 0.5 inches.
         * </p>
         * 
         * @param height
         *        The height of a section.</p>
         *        <p>
         *        Heights can only be defined for header and footer sections. The default height margin is 0.5 inches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder height(String height);

        /**
         * <p>
         * The spacing between section content and its top, bottom, left, and right edges.
         * </p>
         * <p>
         * There is no padding by default.
         * </p>
         * 
         * @param padding
         *        The spacing between section content and its top, bottom, left, and right edges.</p>
         *        <p>
         *        There is no padding by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder padding(Spacing padding);

        /**
         * <p>
         * The spacing between section content and its top, bottom, left, and right edges.
         * </p>
         * <p>
         * There is no padding by default.
         * </p>
         * This is a convenience method that creates an instance of the {@link Spacing.Builder} avoiding the need to
         * create one manually via {@link Spacing#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Spacing.Builder#build()} is called immediately and its result is
         * passed to {@link #padding(Spacing)}.
         * 
         * @param padding
         *        a consumer that will call methods on {@link Spacing.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #padding(Spacing)
         */
        default Builder padding(Consumer<Spacing.Builder> padding) {
            return padding(Spacing.builder().applyMutation(padding).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String height;

        private Spacing padding;

        private BuilderImpl() {
        }

        private BuilderImpl(SectionStyle model) {
            height(model.height);
            padding(model.padding);
        }

        public final String getHeight() {
            return height;
        }

        public final void setHeight(String height) {
            this.height = height;
        }

        @Override
        public final Builder height(String height) {
            this.height = height;
            return this;
        }

        public final Spacing.Builder getPadding() {
            return padding != null ? padding.toBuilder() : null;
        }

        public final void setPadding(Spacing.BuilderImpl padding) {
            this.padding = padding != null ? padding.build() : null;
        }

        @Override
        public final Builder padding(Spacing padding) {
            this.padding = padding;
            return this;
        }

        @Override
        public SectionStyle build() {
            return new SectionStyle(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
