/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTopicsResponse extends QuickSightResponse implements
        ToCopyableBuilder<ListTopicsResponse.Builder, ListTopicsResponse> {
    private static final SdkField<List<TopicSummary>> TOPICS_SUMMARIES_FIELD = SdkField
            .<List<TopicSummary>> builder(MarshallingType.LIST)
            .memberName("TopicsSummaries")
            .getter(getter(ListTopicsResponse::topicsSummaries))
            .setter(setter(Builder::topicsSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicsSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TopicSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TopicSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListTopicsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(ListTopicsResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(ListTopicsResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPICS_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<TopicSummary> topicsSummaries;

    private final String nextToken;

    private final String requestId;

    private final Integer status;

    private ListTopicsResponse(BuilderImpl builder) {
        super(builder);
        this.topicsSummaries = builder.topicsSummaries;
        this.nextToken = builder.nextToken;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    /**
     * For responses, this returns true if the service returned a value for the TopicsSummaries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTopicsSummaries() {
        return topicsSummaries != null && !(topicsSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of topic summaries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTopicsSummaries} method.
     * </p>
     * 
     * @return A list of topic summaries.
     */
    public final List<TopicSummary> topicsSummaries() {
        return topicsSummaries;
    }

    /**
     * <p>
     * The token for the next set of results, or null if there are no more results.
     * </p>
     * 
     * @return The token for the next set of results, or null if there are no more results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public final Integer status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTopicsSummaries() ? topicsSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTopicsResponse)) {
            return false;
        }
        ListTopicsResponse other = (ListTopicsResponse) obj;
        return hasTopicsSummaries() == other.hasTopicsSummaries() && Objects.equals(topicsSummaries(), other.topicsSummaries())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(requestId(), other.requestId())
                && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTopicsResponse").add("TopicsSummaries", hasTopicsSummaries() ? topicsSummaries() : null)
                .add("NextToken", nextToken()).add("RequestId", requestId()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TopicsSummaries":
            return Optional.ofNullable(clazz.cast(topicsSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TopicsSummaries", TOPICS_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTopicsResponse, T> g) {
        return obj -> g.apply((ListTopicsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QuickSightResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTopicsResponse> {
        /**
         * <p>
         * A list of topic summaries.
         * </p>
         * 
         * @param topicsSummaries
         *        A list of topic summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicsSummaries(Collection<TopicSummary> topicsSummaries);

        /**
         * <p>
         * A list of topic summaries.
         * </p>
         * 
         * @param topicsSummaries
         *        A list of topic summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicsSummaries(TopicSummary... topicsSummaries);

        /**
         * <p>
         * A list of topic summaries.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.TopicSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.TopicSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.TopicSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #topicsSummaries(List<TopicSummary>)}.
         * 
         * @param topicsSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.TopicSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #topicsSummaries(java.util.Collection<TopicSummary>)
         */
        Builder topicsSummaries(Consumer<TopicSummary.Builder>... topicsSummaries);

        /**
         * <p>
         * The token for the next set of results, or null if there are no more results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or null if there are no more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private List<TopicSummary> topicsSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private String requestId;

        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTopicsResponse model) {
            super(model);
            topicsSummaries(model.topicsSummaries);
            nextToken(model.nextToken);
            requestId(model.requestId);
            status(model.status);
        }

        public final List<TopicSummary.Builder> getTopicsSummaries() {
            List<TopicSummary.Builder> result = TopicSummariesCopier.copyToBuilder(this.topicsSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTopicsSummaries(Collection<TopicSummary.BuilderImpl> topicsSummaries) {
            this.topicsSummaries = TopicSummariesCopier.copyFromBuilder(topicsSummaries);
        }

        @Override
        public final Builder topicsSummaries(Collection<TopicSummary> topicsSummaries) {
            this.topicsSummaries = TopicSummariesCopier.copy(topicsSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicsSummaries(TopicSummary... topicsSummaries) {
            topicsSummaries(Arrays.asList(topicsSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicsSummaries(Consumer<TopicSummary.Builder>... topicsSummaries) {
            topicsSummaries(Stream.of(topicsSummaries).map(c -> TopicSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public ListTopicsResponse build() {
            return new ListTopicsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
