/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options that determine the presentation of a KPI visual.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KPIOptions implements SdkPojo, Serializable, ToCopyableBuilder<KPIOptions.Builder, KPIOptions> {
    private static final SdkField<ProgressBarOptions> PROGRESS_BAR_FIELD = SdkField
            .<ProgressBarOptions> builder(MarshallingType.SDK_POJO).memberName("ProgressBar")
            .getter(getter(KPIOptions::progressBar)).setter(setter(Builder::progressBar))
            .constructor(ProgressBarOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressBar").build()).build();

    private static final SdkField<TrendArrowOptions> TREND_ARROWS_FIELD = SdkField
            .<TrendArrowOptions> builder(MarshallingType.SDK_POJO).memberName("TrendArrows")
            .getter(getter(KPIOptions::trendArrows)).setter(setter(Builder::trendArrows)).constructor(TrendArrowOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrendArrows").build()).build();

    private static final SdkField<SecondaryValueOptions> SECONDARY_VALUE_FIELD = SdkField
            .<SecondaryValueOptions> builder(MarshallingType.SDK_POJO).memberName("SecondaryValue")
            .getter(getter(KPIOptions::secondaryValue)).setter(setter(Builder::secondaryValue))
            .constructor(SecondaryValueOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryValue").build()).build();

    private static final SdkField<ComparisonConfiguration> COMPARISON_FIELD = SdkField
            .<ComparisonConfiguration> builder(MarshallingType.SDK_POJO).memberName("Comparison")
            .getter(getter(KPIOptions::comparison)).setter(setter(Builder::comparison))
            .constructor(ComparisonConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comparison").build()).build();

    private static final SdkField<String> PRIMARY_VALUE_DISPLAY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimaryValueDisplayType").getter(getter(KPIOptions::primaryValueDisplayTypeAsString))
            .setter(setter(Builder::primaryValueDisplayType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryValueDisplayType").build())
            .build();

    private static final SdkField<FontConfiguration> PRIMARY_VALUE_FONT_CONFIGURATION_FIELD = SdkField
            .<FontConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("PrimaryValueFontConfiguration")
            .getter(getter(KPIOptions::primaryValueFontConfiguration))
            .setter(setter(Builder::primaryValueFontConfiguration))
            .constructor(FontConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryValueFontConfiguration")
                    .build()).build();

    private static final SdkField<FontConfiguration> SECONDARY_VALUE_FONT_CONFIGURATION_FIELD = SdkField
            .<FontConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("SecondaryValueFontConfiguration")
            .getter(getter(KPIOptions::secondaryValueFontConfiguration))
            .setter(setter(Builder::secondaryValueFontConfiguration))
            .constructor(FontConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryValueFontConfiguration")
                    .build()).build();

    private static final SdkField<KPISparklineOptions> SPARKLINE_FIELD = SdkField
            .<KPISparklineOptions> builder(MarshallingType.SDK_POJO).memberName("Sparkline")
            .getter(getter(KPIOptions::sparkline)).setter(setter(Builder::sparkline)).constructor(KPISparklineOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sparkline").build()).build();

    private static final SdkField<KPIVisualLayoutOptions> VISUAL_LAYOUT_OPTIONS_FIELD = SdkField
            .<KPIVisualLayoutOptions> builder(MarshallingType.SDK_POJO).memberName("VisualLayoutOptions")
            .getter(getter(KPIOptions::visualLayoutOptions)).setter(setter(Builder::visualLayoutOptions))
            .constructor(KPIVisualLayoutOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualLayoutOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROGRESS_BAR_FIELD,
            TREND_ARROWS_FIELD, SECONDARY_VALUE_FIELD, COMPARISON_FIELD, PRIMARY_VALUE_DISPLAY_TYPE_FIELD,
            PRIMARY_VALUE_FONT_CONFIGURATION_FIELD, SECONDARY_VALUE_FONT_CONFIGURATION_FIELD, SPARKLINE_FIELD,
            VISUAL_LAYOUT_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ProgressBarOptions progressBar;

    private final TrendArrowOptions trendArrows;

    private final SecondaryValueOptions secondaryValue;

    private final ComparisonConfiguration comparison;

    private final String primaryValueDisplayType;

    private final FontConfiguration primaryValueFontConfiguration;

    private final FontConfiguration secondaryValueFontConfiguration;

    private final KPISparklineOptions sparkline;

    private final KPIVisualLayoutOptions visualLayoutOptions;

    private KPIOptions(BuilderImpl builder) {
        this.progressBar = builder.progressBar;
        this.trendArrows = builder.trendArrows;
        this.secondaryValue = builder.secondaryValue;
        this.comparison = builder.comparison;
        this.primaryValueDisplayType = builder.primaryValueDisplayType;
        this.primaryValueFontConfiguration = builder.primaryValueFontConfiguration;
        this.secondaryValueFontConfiguration = builder.secondaryValueFontConfiguration;
        this.sparkline = builder.sparkline;
        this.visualLayoutOptions = builder.visualLayoutOptions;
    }

    /**
     * <p>
     * The options that determine the presentation of the progress bar of a KPI visual.
     * </p>
     * 
     * @return The options that determine the presentation of the progress bar of a KPI visual.
     */
    public final ProgressBarOptions progressBar() {
        return progressBar;
    }

    /**
     * <p>
     * The options that determine the presentation of trend arrows in a KPI visual.
     * </p>
     * 
     * @return The options that determine the presentation of trend arrows in a KPI visual.
     */
    public final TrendArrowOptions trendArrows() {
        return trendArrows;
    }

    /**
     * <p>
     * The options that determine the presentation of the secondary value of a KPI visual.
     * </p>
     * 
     * @return The options that determine the presentation of the secondary value of a KPI visual.
     */
    public final SecondaryValueOptions secondaryValue() {
        return secondaryValue;
    }

    /**
     * <p>
     * The comparison configuration of a KPI visual.
     * </p>
     * 
     * @return The comparison configuration of a KPI visual.
     */
    public final ComparisonConfiguration comparison() {
        return comparison;
    }

    /**
     * <p>
     * The options that determine the primary value display type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #primaryValueDisplayType} will return {@link PrimaryValueDisplayType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #primaryValueDisplayTypeAsString}.
     * </p>
     * 
     * @return The options that determine the primary value display type.
     * @see PrimaryValueDisplayType
     */
    public final PrimaryValueDisplayType primaryValueDisplayType() {
        return PrimaryValueDisplayType.fromValue(primaryValueDisplayType);
    }

    /**
     * <p>
     * The options that determine the primary value display type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #primaryValueDisplayType} will return {@link PrimaryValueDisplayType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #primaryValueDisplayTypeAsString}.
     * </p>
     * 
     * @return The options that determine the primary value display type.
     * @see PrimaryValueDisplayType
     */
    public final String primaryValueDisplayTypeAsString() {
        return primaryValueDisplayType;
    }

    /**
     * <p>
     * The options that determine the primary value font configuration.
     * </p>
     * 
     * @return The options that determine the primary value font configuration.
     */
    public final FontConfiguration primaryValueFontConfiguration() {
        return primaryValueFontConfiguration;
    }

    /**
     * <p>
     * The options that determine the secondary value font configuration.
     * </p>
     * 
     * @return The options that determine the secondary value font configuration.
     */
    public final FontConfiguration secondaryValueFontConfiguration() {
        return secondaryValueFontConfiguration;
    }

    /**
     * <p>
     * The options that determine the visibility, color, type, and tooltip visibility of the sparkline of a KPI visual.
     * </p>
     * 
     * @return The options that determine the visibility, color, type, and tooltip visibility of the sparkline of a KPI
     *         visual.
     */
    public final KPISparklineOptions sparkline() {
        return sparkline;
    }

    /**
     * <p>
     * The options that determine the layout a KPI visual.
     * </p>
     * 
     * @return The options that determine the layout a KPI visual.
     */
    public final KPIVisualLayoutOptions visualLayoutOptions() {
        return visualLayoutOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(progressBar());
        hashCode = 31 * hashCode + Objects.hashCode(trendArrows());
        hashCode = 31 * hashCode + Objects.hashCode(secondaryValue());
        hashCode = 31 * hashCode + Objects.hashCode(comparison());
        hashCode = 31 * hashCode + Objects.hashCode(primaryValueDisplayTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(primaryValueFontConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(secondaryValueFontConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(sparkline());
        hashCode = 31 * hashCode + Objects.hashCode(visualLayoutOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KPIOptions)) {
            return false;
        }
        KPIOptions other = (KPIOptions) obj;
        return Objects.equals(progressBar(), other.progressBar()) && Objects.equals(trendArrows(), other.trendArrows())
                && Objects.equals(secondaryValue(), other.secondaryValue()) && Objects.equals(comparison(), other.comparison())
                && Objects.equals(primaryValueDisplayTypeAsString(), other.primaryValueDisplayTypeAsString())
                && Objects.equals(primaryValueFontConfiguration(), other.primaryValueFontConfiguration())
                && Objects.equals(secondaryValueFontConfiguration(), other.secondaryValueFontConfiguration())
                && Objects.equals(sparkline(), other.sparkline())
                && Objects.equals(visualLayoutOptions(), other.visualLayoutOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KPIOptions").add("ProgressBar", progressBar()).add("TrendArrows", trendArrows())
                .add("SecondaryValue", secondaryValue()).add("Comparison", comparison())
                .add("PrimaryValueDisplayType", primaryValueDisplayTypeAsString())
                .add("PrimaryValueFontConfiguration", primaryValueFontConfiguration())
                .add("SecondaryValueFontConfiguration", secondaryValueFontConfiguration()).add("Sparkline", sparkline())
                .add("VisualLayoutOptions", visualLayoutOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProgressBar":
            return Optional.ofNullable(clazz.cast(progressBar()));
        case "TrendArrows":
            return Optional.ofNullable(clazz.cast(trendArrows()));
        case "SecondaryValue":
            return Optional.ofNullable(clazz.cast(secondaryValue()));
        case "Comparison":
            return Optional.ofNullable(clazz.cast(comparison()));
        case "PrimaryValueDisplayType":
            return Optional.ofNullable(clazz.cast(primaryValueDisplayTypeAsString()));
        case "PrimaryValueFontConfiguration":
            return Optional.ofNullable(clazz.cast(primaryValueFontConfiguration()));
        case "SecondaryValueFontConfiguration":
            return Optional.ofNullable(clazz.cast(secondaryValueFontConfiguration()));
        case "Sparkline":
            return Optional.ofNullable(clazz.cast(sparkline()));
        case "VisualLayoutOptions":
            return Optional.ofNullable(clazz.cast(visualLayoutOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProgressBar", PROGRESS_BAR_FIELD);
        map.put("TrendArrows", TREND_ARROWS_FIELD);
        map.put("SecondaryValue", SECONDARY_VALUE_FIELD);
        map.put("Comparison", COMPARISON_FIELD);
        map.put("PrimaryValueDisplayType", PRIMARY_VALUE_DISPLAY_TYPE_FIELD);
        map.put("PrimaryValueFontConfiguration", PRIMARY_VALUE_FONT_CONFIGURATION_FIELD);
        map.put("SecondaryValueFontConfiguration", SECONDARY_VALUE_FONT_CONFIGURATION_FIELD);
        map.put("Sparkline", SPARKLINE_FIELD);
        map.put("VisualLayoutOptions", VISUAL_LAYOUT_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KPIOptions, T> g) {
        return obj -> g.apply((KPIOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KPIOptions> {
        /**
         * <p>
         * The options that determine the presentation of the progress bar of a KPI visual.
         * </p>
         * 
         * @param progressBar
         *        The options that determine the presentation of the progress bar of a KPI visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressBar(ProgressBarOptions progressBar);

        /**
         * <p>
         * The options that determine the presentation of the progress bar of a KPI visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProgressBarOptions.Builder} avoiding the
         * need to create one manually via {@link ProgressBarOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProgressBarOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #progressBar(ProgressBarOptions)}.
         * 
         * @param progressBar
         *        a consumer that will call methods on {@link ProgressBarOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #progressBar(ProgressBarOptions)
         */
        default Builder progressBar(Consumer<ProgressBarOptions.Builder> progressBar) {
            return progressBar(ProgressBarOptions.builder().applyMutation(progressBar).build());
        }

        /**
         * <p>
         * The options that determine the presentation of trend arrows in a KPI visual.
         * </p>
         * 
         * @param trendArrows
         *        The options that determine the presentation of trend arrows in a KPI visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trendArrows(TrendArrowOptions trendArrows);

        /**
         * <p>
         * The options that determine the presentation of trend arrows in a KPI visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrendArrowOptions.Builder} avoiding the
         * need to create one manually via {@link TrendArrowOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrendArrowOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #trendArrows(TrendArrowOptions)}.
         * 
         * @param trendArrows
         *        a consumer that will call methods on {@link TrendArrowOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trendArrows(TrendArrowOptions)
         */
        default Builder trendArrows(Consumer<TrendArrowOptions.Builder> trendArrows) {
            return trendArrows(TrendArrowOptions.builder().applyMutation(trendArrows).build());
        }

        /**
         * <p>
         * The options that determine the presentation of the secondary value of a KPI visual.
         * </p>
         * 
         * @param secondaryValue
         *        The options that determine the presentation of the secondary value of a KPI visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryValue(SecondaryValueOptions secondaryValue);

        /**
         * <p>
         * The options that determine the presentation of the secondary value of a KPI visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link SecondaryValueOptions.Builder} avoiding
         * the need to create one manually via {@link SecondaryValueOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SecondaryValueOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #secondaryValue(SecondaryValueOptions)}.
         * 
         * @param secondaryValue
         *        a consumer that will call methods on {@link SecondaryValueOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secondaryValue(SecondaryValueOptions)
         */
        default Builder secondaryValue(Consumer<SecondaryValueOptions.Builder> secondaryValue) {
            return secondaryValue(SecondaryValueOptions.builder().applyMutation(secondaryValue).build());
        }

        /**
         * <p>
         * The comparison configuration of a KPI visual.
         * </p>
         * 
         * @param comparison
         *        The comparison configuration of a KPI visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comparison(ComparisonConfiguration comparison);

        /**
         * <p>
         * The comparison configuration of a KPI visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComparisonConfiguration.Builder} avoiding
         * the need to create one manually via {@link ComparisonConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComparisonConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #comparison(ComparisonConfiguration)}.
         * 
         * @param comparison
         *        a consumer that will call methods on {@link ComparisonConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #comparison(ComparisonConfiguration)
         */
        default Builder comparison(Consumer<ComparisonConfiguration.Builder> comparison) {
            return comparison(ComparisonConfiguration.builder().applyMutation(comparison).build());
        }

        /**
         * <p>
         * The options that determine the primary value display type.
         * </p>
         * 
         * @param primaryValueDisplayType
         *        The options that determine the primary value display type.
         * @see PrimaryValueDisplayType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrimaryValueDisplayType
         */
        Builder primaryValueDisplayType(String primaryValueDisplayType);

        /**
         * <p>
         * The options that determine the primary value display type.
         * </p>
         * 
         * @param primaryValueDisplayType
         *        The options that determine the primary value display type.
         * @see PrimaryValueDisplayType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrimaryValueDisplayType
         */
        Builder primaryValueDisplayType(PrimaryValueDisplayType primaryValueDisplayType);

        /**
         * <p>
         * The options that determine the primary value font configuration.
         * </p>
         * 
         * @param primaryValueFontConfiguration
         *        The options that determine the primary value font configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryValueFontConfiguration(FontConfiguration primaryValueFontConfiguration);

        /**
         * <p>
         * The options that determine the primary value font configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link FontConfiguration.Builder} avoiding the
         * need to create one manually via {@link FontConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FontConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #primaryValueFontConfiguration(FontConfiguration)}.
         * 
         * @param primaryValueFontConfiguration
         *        a consumer that will call methods on {@link FontConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #primaryValueFontConfiguration(FontConfiguration)
         */
        default Builder primaryValueFontConfiguration(Consumer<FontConfiguration.Builder> primaryValueFontConfiguration) {
            return primaryValueFontConfiguration(FontConfiguration.builder().applyMutation(primaryValueFontConfiguration).build());
        }

        /**
         * <p>
         * The options that determine the secondary value font configuration.
         * </p>
         * 
         * @param secondaryValueFontConfiguration
         *        The options that determine the secondary value font configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryValueFontConfiguration(FontConfiguration secondaryValueFontConfiguration);

        /**
         * <p>
         * The options that determine the secondary value font configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link FontConfiguration.Builder} avoiding the
         * need to create one manually via {@link FontConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FontConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #secondaryValueFontConfiguration(FontConfiguration)}.
         * 
         * @param secondaryValueFontConfiguration
         *        a consumer that will call methods on {@link FontConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secondaryValueFontConfiguration(FontConfiguration)
         */
        default Builder secondaryValueFontConfiguration(Consumer<FontConfiguration.Builder> secondaryValueFontConfiguration) {
            return secondaryValueFontConfiguration(FontConfiguration.builder().applyMutation(secondaryValueFontConfiguration)
                    .build());
        }

        /**
         * <p>
         * The options that determine the visibility, color, type, and tooltip visibility of the sparkline of a KPI
         * visual.
         * </p>
         * 
         * @param sparkline
         *        The options that determine the visibility, color, type, and tooltip visibility of the sparkline of a
         *        KPI visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sparkline(KPISparklineOptions sparkline);

        /**
         * <p>
         * The options that determine the visibility, color, type, and tooltip visibility of the sparkline of a KPI
         * visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link KPISparklineOptions.Builder} avoiding the
         * need to create one manually via {@link KPISparklineOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KPISparklineOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #sparkline(KPISparklineOptions)}.
         * 
         * @param sparkline
         *        a consumer that will call methods on {@link KPISparklineOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sparkline(KPISparklineOptions)
         */
        default Builder sparkline(Consumer<KPISparklineOptions.Builder> sparkline) {
            return sparkline(KPISparklineOptions.builder().applyMutation(sparkline).build());
        }

        /**
         * <p>
         * The options that determine the layout a KPI visual.
         * </p>
         * 
         * @param visualLayoutOptions
         *        The options that determine the layout a KPI visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visualLayoutOptions(KPIVisualLayoutOptions visualLayoutOptions);

        /**
         * <p>
         * The options that determine the layout a KPI visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link KPIVisualLayoutOptions.Builder} avoiding
         * the need to create one manually via {@link KPIVisualLayoutOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KPIVisualLayoutOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #visualLayoutOptions(KPIVisualLayoutOptions)}.
         * 
         * @param visualLayoutOptions
         *        a consumer that will call methods on {@link KPIVisualLayoutOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #visualLayoutOptions(KPIVisualLayoutOptions)
         */
        default Builder visualLayoutOptions(Consumer<KPIVisualLayoutOptions.Builder> visualLayoutOptions) {
            return visualLayoutOptions(KPIVisualLayoutOptions.builder().applyMutation(visualLayoutOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ProgressBarOptions progressBar;

        private TrendArrowOptions trendArrows;

        private SecondaryValueOptions secondaryValue;

        private ComparisonConfiguration comparison;

        private String primaryValueDisplayType;

        private FontConfiguration primaryValueFontConfiguration;

        private FontConfiguration secondaryValueFontConfiguration;

        private KPISparklineOptions sparkline;

        private KPIVisualLayoutOptions visualLayoutOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(KPIOptions model) {
            progressBar(model.progressBar);
            trendArrows(model.trendArrows);
            secondaryValue(model.secondaryValue);
            comparison(model.comparison);
            primaryValueDisplayType(model.primaryValueDisplayType);
            primaryValueFontConfiguration(model.primaryValueFontConfiguration);
            secondaryValueFontConfiguration(model.secondaryValueFontConfiguration);
            sparkline(model.sparkline);
            visualLayoutOptions(model.visualLayoutOptions);
        }

        public final ProgressBarOptions.Builder getProgressBar() {
            return progressBar != null ? progressBar.toBuilder() : null;
        }

        public final void setProgressBar(ProgressBarOptions.BuilderImpl progressBar) {
            this.progressBar = progressBar != null ? progressBar.build() : null;
        }

        @Override
        public final Builder progressBar(ProgressBarOptions progressBar) {
            this.progressBar = progressBar;
            return this;
        }

        public final TrendArrowOptions.Builder getTrendArrows() {
            return trendArrows != null ? trendArrows.toBuilder() : null;
        }

        public final void setTrendArrows(TrendArrowOptions.BuilderImpl trendArrows) {
            this.trendArrows = trendArrows != null ? trendArrows.build() : null;
        }

        @Override
        public final Builder trendArrows(TrendArrowOptions trendArrows) {
            this.trendArrows = trendArrows;
            return this;
        }

        public final SecondaryValueOptions.Builder getSecondaryValue() {
            return secondaryValue != null ? secondaryValue.toBuilder() : null;
        }

        public final void setSecondaryValue(SecondaryValueOptions.BuilderImpl secondaryValue) {
            this.secondaryValue = secondaryValue != null ? secondaryValue.build() : null;
        }

        @Override
        public final Builder secondaryValue(SecondaryValueOptions secondaryValue) {
            this.secondaryValue = secondaryValue;
            return this;
        }

        public final ComparisonConfiguration.Builder getComparison() {
            return comparison != null ? comparison.toBuilder() : null;
        }

        public final void setComparison(ComparisonConfiguration.BuilderImpl comparison) {
            this.comparison = comparison != null ? comparison.build() : null;
        }

        @Override
        public final Builder comparison(ComparisonConfiguration comparison) {
            this.comparison = comparison;
            return this;
        }

        public final String getPrimaryValueDisplayType() {
            return primaryValueDisplayType;
        }

        public final void setPrimaryValueDisplayType(String primaryValueDisplayType) {
            this.primaryValueDisplayType = primaryValueDisplayType;
        }

        @Override
        public final Builder primaryValueDisplayType(String primaryValueDisplayType) {
            this.primaryValueDisplayType = primaryValueDisplayType;
            return this;
        }

        @Override
        public final Builder primaryValueDisplayType(PrimaryValueDisplayType primaryValueDisplayType) {
            this.primaryValueDisplayType(primaryValueDisplayType == null ? null : primaryValueDisplayType.toString());
            return this;
        }

        public final FontConfiguration.Builder getPrimaryValueFontConfiguration() {
            return primaryValueFontConfiguration != null ? primaryValueFontConfiguration.toBuilder() : null;
        }

        public final void setPrimaryValueFontConfiguration(FontConfiguration.BuilderImpl primaryValueFontConfiguration) {
            this.primaryValueFontConfiguration = primaryValueFontConfiguration != null ? primaryValueFontConfiguration.build()
                    : null;
        }

        @Override
        public final Builder primaryValueFontConfiguration(FontConfiguration primaryValueFontConfiguration) {
            this.primaryValueFontConfiguration = primaryValueFontConfiguration;
            return this;
        }

        public final FontConfiguration.Builder getSecondaryValueFontConfiguration() {
            return secondaryValueFontConfiguration != null ? secondaryValueFontConfiguration.toBuilder() : null;
        }

        public final void setSecondaryValueFontConfiguration(FontConfiguration.BuilderImpl secondaryValueFontConfiguration) {
            this.secondaryValueFontConfiguration = secondaryValueFontConfiguration != null ? secondaryValueFontConfiguration
                    .build() : null;
        }

        @Override
        public final Builder secondaryValueFontConfiguration(FontConfiguration secondaryValueFontConfiguration) {
            this.secondaryValueFontConfiguration = secondaryValueFontConfiguration;
            return this;
        }

        public final KPISparklineOptions.Builder getSparkline() {
            return sparkline != null ? sparkline.toBuilder() : null;
        }

        public final void setSparkline(KPISparklineOptions.BuilderImpl sparkline) {
            this.sparkline = sparkline != null ? sparkline.build() : null;
        }

        @Override
        public final Builder sparkline(KPISparklineOptions sparkline) {
            this.sparkline = sparkline;
            return this;
        }

        public final KPIVisualLayoutOptions.Builder getVisualLayoutOptions() {
            return visualLayoutOptions != null ? visualLayoutOptions.toBuilder() : null;
        }

        public final void setVisualLayoutOptions(KPIVisualLayoutOptions.BuilderImpl visualLayoutOptions) {
            this.visualLayoutOptions = visualLayoutOptions != null ? visualLayoutOptions.build() : null;
        }

        @Override
        public final Builder visualLayoutOptions(KPIVisualLayoutOptions visualLayoutOptions) {
            this.visualLayoutOptions = visualLayoutOptions;
            return this;
        }

        @Override
        public KPIOptions build() {
            return new KPIOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
