/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The general image interactions setup for image publish options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageInteractionOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<ImageInteractionOptions.Builder, ImageInteractionOptions> {
    private static final SdkField<ImageMenuOption> IMAGE_MENU_OPTION_FIELD = SdkField
            .<ImageMenuOption> builder(MarshallingType.SDK_POJO).memberName("ImageMenuOption")
            .getter(getter(ImageInteractionOptions::imageMenuOption)).setter(setter(Builder::imageMenuOption))
            .constructor(ImageMenuOption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageMenuOption").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_MENU_OPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ImageMenuOption imageMenuOption;

    private ImageInteractionOptions(BuilderImpl builder) {
        this.imageMenuOption = builder.imageMenuOption;
    }

    /**
     * <p>
     * The menu options for the image.
     * </p>
     * 
     * @return The menu options for the image.
     */
    public final ImageMenuOption imageMenuOption() {
        return imageMenuOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(imageMenuOption());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageInteractionOptions)) {
            return false;
        }
        ImageInteractionOptions other = (ImageInteractionOptions) obj;
        return Objects.equals(imageMenuOption(), other.imageMenuOption());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImageInteractionOptions").add("ImageMenuOption", imageMenuOption()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImageMenuOption":
            return Optional.ofNullable(clazz.cast(imageMenuOption()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ImageMenuOption", IMAGE_MENU_OPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageInteractionOptions, T> g) {
        return obj -> g.apply((ImageInteractionOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageInteractionOptions> {
        /**
         * <p>
         * The menu options for the image.
         * </p>
         * 
         * @param imageMenuOption
         *        The menu options for the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageMenuOption(ImageMenuOption imageMenuOption);

        /**
         * <p>
         * The menu options for the image.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageMenuOption.Builder} avoiding the
         * need to create one manually via {@link ImageMenuOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageMenuOption.Builder#build()} is called immediately and its
         * result is passed to {@link #imageMenuOption(ImageMenuOption)}.
         * 
         * @param imageMenuOption
         *        a consumer that will call methods on {@link ImageMenuOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageMenuOption(ImageMenuOption)
         */
        default Builder imageMenuOption(Consumer<ImageMenuOption.Builder> imageMenuOption) {
            return imageMenuOption(ImageMenuOption.builder().applyMutation(imageMenuOption).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ImageMenuOption imageMenuOption;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageInteractionOptions model) {
            imageMenuOption(model.imageMenuOption);
        }

        public final ImageMenuOption.Builder getImageMenuOption() {
            return imageMenuOption != null ? imageMenuOption.toBuilder() : null;
        }

        public final void setImageMenuOption(ImageMenuOption.BuilderImpl imageMenuOption) {
            this.imageMenuOption = imageMenuOption != null ? imageMenuOption.build() : null;
        }

        @Override
        public final Builder imageMenuOption(ImageMenuOption imageMenuOption) {
            this.imageMenuOption = imageMenuOption;
            return this;
        }

        @Override
        public ImageInteractionOptions build() {
            return new ImageInteractionOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
