/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The exclude period of <code>TimeRangeFilter</code> or <code>RelativeDatesFilter</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExcludePeriodConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ExcludePeriodConfiguration.Builder, ExcludePeriodConfiguration> {
    private static final SdkField<Integer> AMOUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Amount").getter(getter(ExcludePeriodConfiguration::amount)).setter(setter(Builder::amount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Amount").build()).build();

    private static final SdkField<String> GRANULARITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Granularity").getter(getter(ExcludePeriodConfiguration::granularityAsString))
            .setter(setter(Builder::granularity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Granularity").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ExcludePeriodConfiguration::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMOUNT_FIELD,
            GRANULARITY_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer amount;

    private final String granularity;

    private final String status;

    private ExcludePeriodConfiguration(BuilderImpl builder) {
        this.amount = builder.amount;
        this.granularity = builder.granularity;
        this.status = builder.status;
    }

    /**
     * <p>
     * The amount or number of the exclude period.
     * </p>
     * 
     * @return The amount or number of the exclude period.
     */
    public final Integer amount() {
        return amount;
    }

    /**
     * <p>
     * The granularity or unit (day, month, year) of the exclude period.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #granularity} will
     * return {@link TimeGranularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #granularityAsString}.
     * </p>
     * 
     * @return The granularity or unit (day, month, year) of the exclude period.
     * @see TimeGranularity
     */
    public final TimeGranularity granularity() {
        return TimeGranularity.fromValue(granularity);
    }

    /**
     * <p>
     * The granularity or unit (day, month, year) of the exclude period.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #granularity} will
     * return {@link TimeGranularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #granularityAsString}.
     * </p>
     * 
     * @return The granularity or unit (day, month, year) of the exclude period.
     * @see TimeGranularity
     */
    public final String granularityAsString() {
        return granularity;
    }

    /**
     * <p>
     * The status of the exclude period. Choose from the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WidgetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the exclude period. Choose from the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code>
     *         </p>
     *         </li>
     * @see WidgetStatus
     */
    public final WidgetStatus status() {
        return WidgetStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the exclude period. Choose from the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WidgetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the exclude period. Choose from the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code>
     *         </p>
     *         </li>
     * @see WidgetStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amount());
        hashCode = 31 * hashCode + Objects.hashCode(granularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExcludePeriodConfiguration)) {
            return false;
        }
        ExcludePeriodConfiguration other = (ExcludePeriodConfiguration) obj;
        return Objects.equals(amount(), other.amount()) && Objects.equals(granularityAsString(), other.granularityAsString())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExcludePeriodConfiguration").add("Amount", amount()).add("Granularity", granularityAsString())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Amount":
            return Optional.ofNullable(clazz.cast(amount()));
        case "Granularity":
            return Optional.ofNullable(clazz.cast(granularityAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Amount", AMOUNT_FIELD);
        map.put("Granularity", GRANULARITY_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExcludePeriodConfiguration, T> g) {
        return obj -> g.apply((ExcludePeriodConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExcludePeriodConfiguration> {
        /**
         * <p>
         * The amount or number of the exclude period.
         * </p>
         * 
         * @param amount
         *        The amount or number of the exclude period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amount(Integer amount);

        /**
         * <p>
         * The granularity or unit (day, month, year) of the exclude period.
         * </p>
         * 
         * @param granularity
         *        The granularity or unit (day, month, year) of the exclude period.
         * @see TimeGranularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeGranularity
         */
        Builder granularity(String granularity);

        /**
         * <p>
         * The granularity or unit (day, month, year) of the exclude period.
         * </p>
         * 
         * @param granularity
         *        The granularity or unit (day, month, year) of the exclude period.
         * @see TimeGranularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeGranularity
         */
        Builder granularity(TimeGranularity granularity);

        /**
         * <p>
         * The status of the exclude period. Choose from the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the exclude period. Choose from the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code>
         *        </p>
         *        </li>
         * @see WidgetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WidgetStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the exclude period. Choose from the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the exclude period. Choose from the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code>
         *        </p>
         *        </li>
         * @see WidgetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WidgetStatus
         */
        Builder status(WidgetStatus status);
    }

    static final class BuilderImpl implements Builder {
        private Integer amount;

        private String granularity;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ExcludePeriodConfiguration model) {
            amount(model.amount);
            granularity(model.granularity);
            status(model.status);
        }

        public final Integer getAmount() {
            return amount;
        }

        public final void setAmount(Integer amount) {
            this.amount = amount;
        }

        @Override
        public final Builder amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        public final String getGranularity() {
            return granularity;
        }

        public final void setGranularity(String granularity) {
            this.granularity = granularity;
        }

        @Override
        public final Builder granularity(String granularity) {
            this.granularity = granularity;
            return this;
        }

        @Override
        public final Builder granularity(TimeGranularity granularity) {
            this.granularity(granularity == null ? null : granularity.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WidgetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public ExcludePeriodConfiguration build() {
            return new ExcludePeriodConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
