/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of custom values for the destination parameter in
 * <code>DestinationParameterValueConfiguration</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomValuesConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomValuesConfiguration.Builder, CustomValuesConfiguration> {
    private static final SdkField<Boolean> INCLUDE_NULL_VALUE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeNullValue").getter(getter(CustomValuesConfiguration::includeNullValue))
            .setter(setter(Builder::includeNullValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeNullValue").build()).build();

    private static final SdkField<CustomParameterValues> CUSTOM_VALUES_FIELD = SdkField
            .<CustomParameterValues> builder(MarshallingType.SDK_POJO).memberName("CustomValues")
            .getter(getter(CustomValuesConfiguration::customValues)).setter(setter(Builder::customValues))
            .constructor(CustomParameterValues::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomValues").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCLUDE_NULL_VALUE_FIELD,
            CUSTOM_VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean includeNullValue;

    private final CustomParameterValues customValues;

    private CustomValuesConfiguration(BuilderImpl builder) {
        this.includeNullValue = builder.includeNullValue;
        this.customValues = builder.customValues;
    }

    /**
     * <p>
     * Includes the null value in custom action parameter values.
     * </p>
     * 
     * @return Includes the null value in custom action parameter values.
     */
    public final Boolean includeNullValue() {
        return includeNullValue;
    }

    /**
     * Returns the value of the CustomValues property for this object.
     * 
     * @return The value of the CustomValues property for this object.
     */
    public final CustomParameterValues customValues() {
        return customValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(includeNullValue());
        hashCode = 31 * hashCode + Objects.hashCode(customValues());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomValuesConfiguration)) {
            return false;
        }
        CustomValuesConfiguration other = (CustomValuesConfiguration) obj;
        return Objects.equals(includeNullValue(), other.includeNullValue())
                && Objects.equals(customValues(), other.customValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomValuesConfiguration").add("IncludeNullValue", includeNullValue())
                .add("CustomValues", customValues()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IncludeNullValue":
            return Optional.ofNullable(clazz.cast(includeNullValue()));
        case "CustomValues":
            return Optional.ofNullable(clazz.cast(customValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IncludeNullValue", INCLUDE_NULL_VALUE_FIELD);
        map.put("CustomValues", CUSTOM_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomValuesConfiguration, T> g) {
        return obj -> g.apply((CustomValuesConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomValuesConfiguration> {
        /**
         * <p>
         * Includes the null value in custom action parameter values.
         * </p>
         * 
         * @param includeNullValue
         *        Includes the null value in custom action parameter values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeNullValue(Boolean includeNullValue);

        /**
         * Sets the value of the CustomValues property for this object.
         *
         * @param customValues
         *        The new value for the CustomValues property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customValues(CustomParameterValues customValues);

        /**
         * Sets the value of the CustomValues property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CustomParameterValues.Builder} avoiding
         * the need to create one manually via {@link CustomParameterValues#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomParameterValues.Builder#build()} is called immediately and
         * its result is passed to {@link #customValues(CustomParameterValues)}.
         * 
         * @param customValues
         *        a consumer that will call methods on {@link CustomParameterValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customValues(CustomParameterValues)
         */
        default Builder customValues(Consumer<CustomParameterValues.Builder> customValues) {
            return customValues(CustomParameterValues.builder().applyMutation(customValues).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean includeNullValue;

        private CustomParameterValues customValues;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomValuesConfiguration model) {
            includeNullValue(model.includeNullValue);
            customValues(model.customValues);
        }

        public final Boolean getIncludeNullValue() {
            return includeNullValue;
        }

        public final void setIncludeNullValue(Boolean includeNullValue) {
            this.includeNullValue = includeNullValue;
        }

        @Override
        public final Builder includeNullValue(Boolean includeNullValue) {
            this.includeNullValue = includeNullValue;
            return this;
        }

        public final CustomParameterValues.Builder getCustomValues() {
            return customValues != null ? customValues.toBuilder() : null;
        }

        public final void setCustomValues(CustomParameterValues.BuilderImpl customValues) {
            this.customValues = customValues != null ? customValues.build() : null;
        }

        @Override
        public final Builder customValues(CustomParameterValues customValues) {
            this.customValues = customValues;
            return this;
        }

        @Override
        public CustomValuesConfiguration build() {
            return new CustomValuesConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
