/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.BrandDefinition;
import software.amazon.awssdk.services.quicksight.model.BrandDetail;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateBrandResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, CreateBrandResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(CreateBrandResponse.getter(CreateBrandResponse::requestId)).setter(CreateBrandResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<BrandDetail> BRAND_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BrandDetail").getter(CreateBrandResponse.getter(CreateBrandResponse::brandDetail)).setter(CreateBrandResponse.setter(Builder::brandDetail)).constructor(BrandDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BrandDetail").build()}).build();
    private static final SdkField<BrandDefinition> BRAND_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BrandDefinition").getter(CreateBrandResponse.getter(CreateBrandResponse::brandDefinition)).setter(CreateBrandResponse.setter(Builder::brandDefinition)).constructor(BrandDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BrandDefinition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD, BRAND_DETAIL_FIELD, BRAND_DEFINITION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateBrandResponse.memberNameToFieldInitializer();
    private final String requestId;
    private final BrandDetail brandDetail;
    private final BrandDefinition brandDefinition;

    private CreateBrandResponse(BuilderImpl builder) {
        super(builder);
        this.requestId = builder.requestId;
        this.brandDetail = builder.brandDetail;
        this.brandDefinition = builder.brandDefinition;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final BrandDetail brandDetail() {
        return this.brandDetail;
    }

    public final BrandDefinition brandDefinition() {
        return this.brandDefinition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.brandDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.brandDefinition());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBrandResponse)) {
            return false;
        }
        CreateBrandResponse other = (CreateBrandResponse)((Object)obj);
        return Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.brandDetail(), other.brandDetail()) && Objects.equals(this.brandDefinition(), other.brandDefinition());
    }

    public final String toString() {
        return ToString.builder((String)"CreateBrandResponse").add("RequestId", (Object)this.requestId()).add("BrandDetail", (Object)this.brandDetail()).add("BrandDefinition", (Object)this.brandDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "BrandDetail": {
                return Optional.ofNullable(clazz.cast(this.brandDetail()));
            }
            case "BrandDefinition": {
                return Optional.ofNullable(clazz.cast(this.brandDefinition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("BrandDetail", BRAND_DETAIL_FIELD);
        map.put("BrandDefinition", BRAND_DEFINITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateBrandResponse, T> g) {
        return obj -> g.apply((CreateBrandResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private String requestId;
        private BrandDetail brandDetail;
        private BrandDefinition brandDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBrandResponse model) {
            super(model);
            this.requestId(model.requestId);
            this.brandDetail(model.brandDetail);
            this.brandDefinition(model.brandDefinition);
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final BrandDetail.Builder getBrandDetail() {
            return this.brandDetail != null ? this.brandDetail.toBuilder() : null;
        }

        public final void setBrandDetail(BrandDetail.BuilderImpl brandDetail) {
            this.brandDetail = brandDetail != null ? brandDetail.build() : null;
        }

        @Override
        public final Builder brandDetail(BrandDetail brandDetail) {
            this.brandDetail = brandDetail;
            return this;
        }

        public final BrandDefinition.Builder getBrandDefinition() {
            return this.brandDefinition != null ? this.brandDefinition.toBuilder() : null;
        }

        public final void setBrandDefinition(BrandDefinition.BuilderImpl brandDefinition) {
            this.brandDefinition = brandDefinition != null ? brandDefinition.build() : null;
        }

        @Override
        public final Builder brandDefinition(BrandDefinition brandDefinition) {
            this.brandDefinition = brandDefinition;
            return this;
        }

        @Override
        public CreateBrandResponse build() {
            return new CreateBrandResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateBrandResponse> {
        public Builder requestId(String var1);

        public Builder brandDetail(BrandDetail var1);

        default public Builder brandDetail(Consumer<BrandDetail.Builder> brandDetail) {
            return this.brandDetail((BrandDetail)((BrandDetail.Builder)BrandDetail.builder().applyMutation(brandDetail)).build());
        }

        public Builder brandDefinition(BrandDefinition var1);

        default public Builder brandDefinition(Consumer<BrandDefinition.Builder> brandDefinition) {
            return this.brandDefinition((BrandDefinition)((BrandDefinition.Builder)BrandDefinition.builder().applyMutation(brandDefinition)).build());
        }
    }
}

