/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.MemberType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FolderMember
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FolderMember> {
    private static final SdkField<String> MEMBER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MemberId").getter(FolderMember.getter(FolderMember::memberId)).setter(FolderMember.setter(Builder::memberId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberId").build()}).build();
    private static final SdkField<String> MEMBER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MemberType").getter(FolderMember.getter(FolderMember::memberTypeAsString)).setter(FolderMember.setter(Builder::memberType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBER_ID_FIELD, MEMBER_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FolderMember.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String memberId;
    private final String memberType;

    private FolderMember(BuilderImpl builder) {
        this.memberId = builder.memberId;
        this.memberType = builder.memberType;
    }

    public final String memberId() {
        return this.memberId;
    }

    public final MemberType memberType() {
        return MemberType.fromValue(this.memberType);
    }

    public final String memberTypeAsString() {
        return this.memberType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.memberId());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FolderMember)) {
            return false;
        }
        FolderMember other = (FolderMember)obj;
        return Objects.equals(this.memberId(), other.memberId()) && Objects.equals(this.memberTypeAsString(), other.memberTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"FolderMember").add("MemberId", (Object)this.memberId()).add("MemberType", (Object)this.memberTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MemberId": {
                return Optional.ofNullable(clazz.cast(this.memberId()));
            }
            case "MemberType": {
                return Optional.ofNullable(clazz.cast(this.memberTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("MemberId", MEMBER_ID_FIELD);
        map.put("MemberType", MEMBER_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FolderMember, T> g) {
        return obj -> g.apply((FolderMember)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String memberId;
        private String memberType;

        private BuilderImpl() {
        }

        private BuilderImpl(FolderMember model) {
            this.memberId(model.memberId);
            this.memberType(model.memberType);
        }

        public final String getMemberId() {
            return this.memberId;
        }

        public final void setMemberId(String memberId) {
            this.memberId = memberId;
        }

        @Override
        public final Builder memberId(String memberId) {
            this.memberId = memberId;
            return this;
        }

        public final String getMemberType() {
            return this.memberType;
        }

        public final void setMemberType(String memberType) {
            this.memberType = memberType;
        }

        @Override
        public final Builder memberType(String memberType) {
            this.memberType = memberType;
            return this;
        }

        @Override
        public final Builder memberType(MemberType memberType) {
            this.memberType(memberType == null ? null : memberType.toString());
            return this;
        }

        public FolderMember build() {
            return new FolderMember(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FolderMember> {
        public Builder memberId(String var1);

        public Builder memberType(String var1);

        public Builder memberType(MemberType var1);
    }
}

