/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.services.quicksight.model.VPCConnectionSummary;
import software.amazon.awssdk.services.quicksight.model.VPCConnectionSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListVpcConnectionsResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, ListVpcConnectionsResponse> {
    private static final SdkField<List<VPCConnectionSummary>> VPC_CONNECTION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VPCConnectionSummaries").getter(ListVpcConnectionsResponse.getter(ListVpcConnectionsResponse::vpcConnectionSummaries)).setter(ListVpcConnectionsResponse.setter(Builder::vpcConnectionSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCConnectionSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VPCConnectionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListVpcConnectionsResponse.getter(ListVpcConnectionsResponse::nextToken)).setter(ListVpcConnectionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(ListVpcConnectionsResponse.getter(ListVpcConnectionsResponse::requestId)).setter(ListVpcConnectionsResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(ListVpcConnectionsResponse.getter(ListVpcConnectionsResponse::status)).setter(ListVpcConnectionsResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_CONNECTION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListVpcConnectionsResponse.memberNameToFieldInitializer();
    private final List<VPCConnectionSummary> vpcConnectionSummaries;
    private final String nextToken;
    private final String requestId;
    private final Integer status;

    private ListVpcConnectionsResponse(BuilderImpl builder) {
        super(builder);
        this.vpcConnectionSummaries = builder.vpcConnectionSummaries;
        this.nextToken = builder.nextToken;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    public final boolean hasVpcConnectionSummaries() {
        return this.vpcConnectionSummaries != null && !(this.vpcConnectionSummaries instanceof SdkAutoConstructList);
    }

    public final List<VPCConnectionSummary> vpcConnectionSummaries() {
        return this.vpcConnectionSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final Integer status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcConnectionSummaries() ? this.vpcConnectionSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVpcConnectionsResponse)) {
            return false;
        }
        ListVpcConnectionsResponse other = (ListVpcConnectionsResponse)((Object)obj);
        return this.hasVpcConnectionSummaries() == other.hasVpcConnectionSummaries() && Objects.equals(this.vpcConnectionSummaries(), other.vpcConnectionSummaries()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"ListVpcConnectionsResponse").add("VPCConnectionSummaries", this.hasVpcConnectionSummaries() ? this.vpcConnectionSummaries() : null).add("NextToken", (Object)this.nextToken()).add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VPCConnectionSummaries": {
                return Optional.ofNullable(clazz.cast(this.vpcConnectionSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VPCConnectionSummaries", VPC_CONNECTION_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListVpcConnectionsResponse, T> g) {
        return obj -> g.apply((ListVpcConnectionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private List<VPCConnectionSummary> vpcConnectionSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private String requestId;
        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVpcConnectionsResponse model) {
            super(model);
            this.vpcConnectionSummaries(model.vpcConnectionSummaries);
            this.nextToken(model.nextToken);
            this.requestId(model.requestId);
            this.status(model.status);
        }

        public final List<VPCConnectionSummary.Builder> getVpcConnectionSummaries() {
            List<VPCConnectionSummary.Builder> result = VPCConnectionSummaryListCopier.copyToBuilder(this.vpcConnectionSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcConnectionSummaries(Collection<VPCConnectionSummary.BuilderImpl> vpcConnectionSummaries) {
            this.vpcConnectionSummaries = VPCConnectionSummaryListCopier.copyFromBuilder(vpcConnectionSummaries);
        }

        @Override
        public final Builder vpcConnectionSummaries(Collection<VPCConnectionSummary> vpcConnectionSummaries) {
            this.vpcConnectionSummaries = VPCConnectionSummaryListCopier.copy(vpcConnectionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcConnectionSummaries(VPCConnectionSummary ... vpcConnectionSummaries) {
            this.vpcConnectionSummaries(Arrays.asList(vpcConnectionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcConnectionSummaries(Consumer<VPCConnectionSummary.Builder> ... vpcConnectionSummaries) {
            this.vpcConnectionSummaries(Stream.of(vpcConnectionSummaries).map(c -> (VPCConnectionSummary)((VPCConnectionSummary.Builder)VPCConnectionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public ListVpcConnectionsResponse build() {
            return new ListVpcConnectionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListVpcConnectionsResponse> {
        public Builder vpcConnectionSummaries(Collection<VPCConnectionSummary> var1);

        public Builder vpcConnectionSummaries(VPCConnectionSummary ... var1);

        public Builder vpcConnectionSummaries(Consumer<VPCConnectionSummary.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder requestId(String var1);

        public Builder status(Integer var1);
    }
}

