/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.GeospatialHeatmapDataColor;
import software.amazon.awssdk.services.quicksight.model.GeospatialHeatmapDataColorListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GeospatialHeatmapColorScale
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GeospatialHeatmapColorScale> {
    private static final SdkField<List<GeospatialHeatmapDataColor>> COLORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Colors").getter(GeospatialHeatmapColorScale.getter(GeospatialHeatmapColorScale::colors)).setter(GeospatialHeatmapColorScale.setter(Builder::colors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Colors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GeospatialHeatmapDataColor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GeospatialHeatmapColorScale.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<GeospatialHeatmapDataColor> colors;

    private GeospatialHeatmapColorScale(BuilderImpl builder) {
        this.colors = builder.colors;
    }

    public final boolean hasColors() {
        return this.colors != null && !(this.colors instanceof SdkAutoConstructList);
    }

    public final List<GeospatialHeatmapDataColor> colors() {
        return this.colors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColors() ? this.colors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeospatialHeatmapColorScale)) {
            return false;
        }
        GeospatialHeatmapColorScale other = (GeospatialHeatmapColorScale)obj;
        return this.hasColors() == other.hasColors() && Objects.equals(this.colors(), other.colors());
    }

    public final String toString() {
        return ToString.builder((String)"GeospatialHeatmapColorScale").add("Colors", this.hasColors() ? this.colors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Colors": {
                return Optional.ofNullable(clazz.cast(this.colors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<GeospatialHeatmapDataColor>>> map = new HashMap<String, SdkField<List<GeospatialHeatmapDataColor>>>();
        map.put("Colors", COLORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeospatialHeatmapColorScale, T> g) {
        return obj -> g.apply((GeospatialHeatmapColorScale)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<GeospatialHeatmapDataColor> colors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GeospatialHeatmapColorScale model) {
            this.colors(model.colors);
        }

        public final List<GeospatialHeatmapDataColor.Builder> getColors() {
            List<GeospatialHeatmapDataColor.Builder> result = GeospatialHeatmapDataColorListCopier.copyToBuilder(this.colors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColors(Collection<GeospatialHeatmapDataColor.BuilderImpl> colors) {
            this.colors = GeospatialHeatmapDataColorListCopier.copyFromBuilder(colors);
        }

        @Override
        public final Builder colors(Collection<GeospatialHeatmapDataColor> colors) {
            this.colors = GeospatialHeatmapDataColorListCopier.copy(colors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder colors(GeospatialHeatmapDataColor ... colors) {
            this.colors(Arrays.asList(colors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder colors(Consumer<GeospatialHeatmapDataColor.Builder> ... colors) {
            this.colors(Stream.of(colors).map(c -> (GeospatialHeatmapDataColor)((GeospatialHeatmapDataColor.Builder)GeospatialHeatmapDataColor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public GeospatialHeatmapColorScale build() {
            return new GeospatialHeatmapColorScale(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GeospatialHeatmapColorScale> {
        public Builder colors(Collection<GeospatialHeatmapDataColor> var1);

        public Builder colors(GeospatialHeatmapDataColor ... var1);

        public Builder colors(Consumer<GeospatialHeatmapDataColor.Builder> ... var1);
    }
}

