/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.AssetBundleCloudFormationOverridePropertyConfiguration;
import software.amazon.awssdk.services.quicksight.model.AssetBundleExportFormat;
import software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobError;
import software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobErrorListCopier;
import software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobStatus;
import software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobValidationStrategy;
import software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobWarning;
import software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobWarningListCopier;
import software.amazon.awssdk.services.quicksight.model.AssetBundleResourceArnsCopier;
import software.amazon.awssdk.services.quicksight.model.IncludeFolderMembers;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAssetBundleExportJobResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, DescribeAssetBundleExportJobResponse> {
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobStatus").getter(DescribeAssetBundleExportJobResponse.getter(DescribeAssetBundleExportJobResponse::jobStatusAsString)).setter(DescribeAssetBundleExportJobResponse.setter(Builder::jobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()}).build();
    private static final SdkField<String> DOWNLOAD_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DownloadUrl").getter(DescribeAssetBundleExportJobResponse.getter(DescribeAssetBundleExportJobResponse::downloadUrl)).setter(DescribeAssetBundleExportJobResponse.setter(Builder::downloadUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DownloadUrl").build()}).build();
    private static final SdkField<List<AssetBundleExportJobError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(DescribeAssetBundleExportJobResponse.getter(DescribeAssetBundleExportJobResponse::errors)).setter(DescribeAssetBundleExportJobResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetBundleExportJobError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DescribeAssetBundleExportJobResponse.getter(DescribeAssetBundleExportJobResponse::arn)).setter(DescribeAssetBundleExportJobResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(DescribeAssetBundleExportJobResponse.getter(DescribeAssetBundleExportJobResponse::createdTime)).setter(DescribeAssetBundleExportJobResponse.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<String> ASSET_BUNDLE_EXPORT_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssetBundleExportJobId").getter(DescribeAssetBundleExportJobResponse.getter(DescribeAssetBundleExportJobResponse::assetBundleExportJobId)).setter(DescribeAssetBundleExportJobResponse.setter(Builder::assetBundleExportJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetBundleExportJobId").build()}).build();
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(DescribeAssetBundleExportJobResponse.getter(DescribeAssetBundleExportJobResponse::awsAccountId)).setter(DescribeAssetBundleExportJobResponse.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountId").build()}).build();
    private static final SdkField<List<String>> RESOURCE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceArns").getter(DescribeAssetBundleExportJobResponse.getter(DescribeAssetBundleExportJobResponse::resourceArns)).setter(DescribeAssetBundleExportJobResponse.setter(Builder::resourceArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> INCLUDE_ALL_DEPENDENCIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeAllDependencies").getter(DescribeAssetBundleExportJobResponse.getter(DescribeAssetBundleExportJobResponse::includeAllDependencies)).setter(DescribeAssetBundleExportJobResponse.setter(Builder::includeAllDependencies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeAllDependencies").build()}).build();
    private static final SdkField<String> EXPORT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportFormat").getter(DescribeAssetBundleExportJobResponse.getter(DescribeAssetBundleExportJobResponse::exportFormatAsString)).setter(DescribeAssetBundleExportJobResponse.setter(Builder::exportFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportFormat").build()}).build();
    private static final SdkField<AssetBundleCloudFormationOverridePropertyConfiguration> CLOUD_FORMATION_OVERRIDE_PROPERTY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudFormationOverridePropertyConfiguration").getter(DescribeAssetBundleExportJobResponse.getter(DescribeAssetBundleExportJobResponse::cloudFormationOverridePropertyConfiguration)).setter(DescribeAssetBundleExportJobResponse.setter(Builder::cloudFormationOverridePropertyConfiguration)).constructor(AssetBundleCloudFormationOverridePropertyConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudFormationOverridePropertyConfiguration").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(DescribeAssetBundleExportJobResponse.getter(DescribeAssetBundleExportJobResponse::requestId)).setter(DescribeAssetBundleExportJobResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(DescribeAssetBundleExportJobResponse.getter(DescribeAssetBundleExportJobResponse::status)).setter(DescribeAssetBundleExportJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final SdkField<Boolean> INCLUDE_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludePermissions").getter(DescribeAssetBundleExportJobResponse.getter(DescribeAssetBundleExportJobResponse::includePermissions)).setter(DescribeAssetBundleExportJobResponse.setter(Builder::includePermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludePermissions").build()}).build();
    private static final SdkField<Boolean> INCLUDE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeTags").getter(DescribeAssetBundleExportJobResponse.getter(DescribeAssetBundleExportJobResponse::includeTags)).setter(DescribeAssetBundleExportJobResponse.setter(Builder::includeTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeTags").build()}).build();
    private static final SdkField<AssetBundleExportJobValidationStrategy> VALIDATION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ValidationStrategy").getter(DescribeAssetBundleExportJobResponse.getter(DescribeAssetBundleExportJobResponse::validationStrategy)).setter(DescribeAssetBundleExportJobResponse.setter(Builder::validationStrategy)).constructor(AssetBundleExportJobValidationStrategy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationStrategy").build()}).build();
    private static final SdkField<List<AssetBundleExportJobWarning>> WARNINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Warnings").getter(DescribeAssetBundleExportJobResponse.getter(DescribeAssetBundleExportJobResponse::warnings)).setter(DescribeAssetBundleExportJobResponse.setter(Builder::warnings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Warnings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetBundleExportJobWarning::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> INCLUDE_FOLDER_MEMBERSHIPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeFolderMemberships").getter(DescribeAssetBundleExportJobResponse.getter(DescribeAssetBundleExportJobResponse::includeFolderMemberships)).setter(DescribeAssetBundleExportJobResponse.setter(Builder::includeFolderMemberships)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeFolderMemberships").build()}).build();
    private static final SdkField<String> INCLUDE_FOLDER_MEMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IncludeFolderMembers").getter(DescribeAssetBundleExportJobResponse.getter(DescribeAssetBundleExportJobResponse::includeFolderMembersAsString)).setter(DescribeAssetBundleExportJobResponse.setter(Builder::includeFolderMembers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeFolderMembers").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_STATUS_FIELD, DOWNLOAD_URL_FIELD, ERRORS_FIELD, ARN_FIELD, CREATED_TIME_FIELD, ASSET_BUNDLE_EXPORT_JOB_ID_FIELD, AWS_ACCOUNT_ID_FIELD, RESOURCE_ARNS_FIELD, INCLUDE_ALL_DEPENDENCIES_FIELD, EXPORT_FORMAT_FIELD, CLOUD_FORMATION_OVERRIDE_PROPERTY_CONFIGURATION_FIELD, REQUEST_ID_FIELD, STATUS_FIELD, INCLUDE_PERMISSIONS_FIELD, INCLUDE_TAGS_FIELD, VALIDATION_STRATEGY_FIELD, WARNINGS_FIELD, INCLUDE_FOLDER_MEMBERSHIPS_FIELD, INCLUDE_FOLDER_MEMBERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeAssetBundleExportJobResponse.memberNameToFieldInitializer();
    private final String jobStatus;
    private final String downloadUrl;
    private final List<AssetBundleExportJobError> errors;
    private final String arn;
    private final Instant createdTime;
    private final String assetBundleExportJobId;
    private final String awsAccountId;
    private final List<String> resourceArns;
    private final Boolean includeAllDependencies;
    private final String exportFormat;
    private final AssetBundleCloudFormationOverridePropertyConfiguration cloudFormationOverridePropertyConfiguration;
    private final String requestId;
    private final Integer status;
    private final Boolean includePermissions;
    private final Boolean includeTags;
    private final AssetBundleExportJobValidationStrategy validationStrategy;
    private final List<AssetBundleExportJobWarning> warnings;
    private final Boolean includeFolderMemberships;
    private final String includeFolderMembers;

    private DescribeAssetBundleExportJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobStatus = builder.jobStatus;
        this.downloadUrl = builder.downloadUrl;
        this.errors = builder.errors;
        this.arn = builder.arn;
        this.createdTime = builder.createdTime;
        this.assetBundleExportJobId = builder.assetBundleExportJobId;
        this.awsAccountId = builder.awsAccountId;
        this.resourceArns = builder.resourceArns;
        this.includeAllDependencies = builder.includeAllDependencies;
        this.exportFormat = builder.exportFormat;
        this.cloudFormationOverridePropertyConfiguration = builder.cloudFormationOverridePropertyConfiguration;
        this.requestId = builder.requestId;
        this.status = builder.status;
        this.includePermissions = builder.includePermissions;
        this.includeTags = builder.includeTags;
        this.validationStrategy = builder.validationStrategy;
        this.warnings = builder.warnings;
        this.includeFolderMemberships = builder.includeFolderMemberships;
        this.includeFolderMembers = builder.includeFolderMembers;
    }

    public final AssetBundleExportJobStatus jobStatus() {
        return AssetBundleExportJobStatus.fromValue(this.jobStatus);
    }

    public final String jobStatusAsString() {
        return this.jobStatus;
    }

    public final String downloadUrl() {
        return this.downloadUrl;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<AssetBundleExportJobError> errors() {
        return this.errors;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final String assetBundleExportJobId() {
        return this.assetBundleExportJobId;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final boolean hasResourceArns() {
        return this.resourceArns != null && !(this.resourceArns instanceof SdkAutoConstructList);
    }

    public final List<String> resourceArns() {
        return this.resourceArns;
    }

    public final Boolean includeAllDependencies() {
        return this.includeAllDependencies;
    }

    public final AssetBundleExportFormat exportFormat() {
        return AssetBundleExportFormat.fromValue(this.exportFormat);
    }

    public final String exportFormatAsString() {
        return this.exportFormat;
    }

    public final AssetBundleCloudFormationOverridePropertyConfiguration cloudFormationOverridePropertyConfiguration() {
        return this.cloudFormationOverridePropertyConfiguration;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final Integer status() {
        return this.status;
    }

    public final Boolean includePermissions() {
        return this.includePermissions;
    }

    public final Boolean includeTags() {
        return this.includeTags;
    }

    public final AssetBundleExportJobValidationStrategy validationStrategy() {
        return this.validationStrategy;
    }

    public final boolean hasWarnings() {
        return this.warnings != null && !(this.warnings instanceof SdkAutoConstructList);
    }

    public final List<AssetBundleExportJobWarning> warnings() {
        return this.warnings;
    }

    public final Boolean includeFolderMemberships() {
        return this.includeFolderMemberships;
    }

    public final IncludeFolderMembers includeFolderMembers() {
        return IncludeFolderMembers.fromValue(this.includeFolderMembers);
    }

    public final String includeFolderMembersAsString() {
        return this.includeFolderMembers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.downloadUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetBundleExportJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceArns() ? this.resourceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.includeAllDependencies());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudFormationOverridePropertyConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.includePermissions());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWarnings() ? this.warnings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.includeFolderMemberships());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeFolderMembersAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAssetBundleExportJobResponse)) {
            return false;
        }
        DescribeAssetBundleExportJobResponse other = (DescribeAssetBundleExportJobResponse)((Object)obj);
        return Objects.equals(this.jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(this.downloadUrl(), other.downloadUrl()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.assetBundleExportJobId(), other.assetBundleExportJobId()) && Objects.equals(this.awsAccountId(), other.awsAccountId()) && this.hasResourceArns() == other.hasResourceArns() && Objects.equals(this.resourceArns(), other.resourceArns()) && Objects.equals(this.includeAllDependencies(), other.includeAllDependencies()) && Objects.equals(this.exportFormatAsString(), other.exportFormatAsString()) && Objects.equals(this.cloudFormationOverridePropertyConfiguration(), other.cloudFormationOverridePropertyConfiguration()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.includePermissions(), other.includePermissions()) && Objects.equals(this.includeTags(), other.includeTags()) && Objects.equals(this.validationStrategy(), other.validationStrategy()) && this.hasWarnings() == other.hasWarnings() && Objects.equals(this.warnings(), other.warnings()) && Objects.equals(this.includeFolderMemberships(), other.includeFolderMemberships()) && Objects.equals(this.includeFolderMembersAsString(), other.includeFolderMembersAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAssetBundleExportJobResponse").add("JobStatus", (Object)this.jobStatusAsString()).add("DownloadUrl", (Object)(this.downloadUrl() == null ? null : "*** Sensitive Data Redacted ***")).add("Errors", this.hasErrors() ? this.errors() : null).add("Arn", (Object)this.arn()).add("CreatedTime", (Object)this.createdTime()).add("AssetBundleExportJobId", (Object)this.assetBundleExportJobId()).add("AwsAccountId", (Object)this.awsAccountId()).add("ResourceArns", this.hasResourceArns() ? this.resourceArns() : null).add("IncludeAllDependencies", (Object)this.includeAllDependencies()).add("ExportFormat", (Object)this.exportFormatAsString()).add("CloudFormationOverridePropertyConfiguration", (Object)this.cloudFormationOverridePropertyConfiguration()).add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).add("IncludePermissions", (Object)this.includePermissions()).add("IncludeTags", (Object)this.includeTags()).add("ValidationStrategy", (Object)this.validationStrategy()).add("Warnings", this.hasWarnings() ? this.warnings() : null).add("IncludeFolderMemberships", (Object)this.includeFolderMemberships()).add("IncludeFolderMembers", (Object)this.includeFolderMembersAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
            case "DownloadUrl": {
                return Optional.ofNullable(clazz.cast(this.downloadUrl()));
            }
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "AssetBundleExportJobId": {
                return Optional.ofNullable(clazz.cast(this.assetBundleExportJobId()));
            }
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "ResourceArns": {
                return Optional.ofNullable(clazz.cast(this.resourceArns()));
            }
            case "IncludeAllDependencies": {
                return Optional.ofNullable(clazz.cast(this.includeAllDependencies()));
            }
            case "ExportFormat": {
                return Optional.ofNullable(clazz.cast(this.exportFormatAsString()));
            }
            case "CloudFormationOverridePropertyConfiguration": {
                return Optional.ofNullable(clazz.cast(this.cloudFormationOverridePropertyConfiguration()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "IncludePermissions": {
                return Optional.ofNullable(clazz.cast(this.includePermissions()));
            }
            case "IncludeTags": {
                return Optional.ofNullable(clazz.cast(this.includeTags()));
            }
            case "ValidationStrategy": {
                return Optional.ofNullable(clazz.cast(this.validationStrategy()));
            }
            case "Warnings": {
                return Optional.ofNullable(clazz.cast(this.warnings()));
            }
            case "IncludeFolderMemberships": {
                return Optional.ofNullable(clazz.cast(this.includeFolderMemberships()));
            }
            case "IncludeFolderMembers": {
                return Optional.ofNullable(clazz.cast(this.includeFolderMembersAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("JobStatus", JOB_STATUS_FIELD);
        map.put("DownloadUrl", DOWNLOAD_URL_FIELD);
        map.put("Errors", ERRORS_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("AssetBundleExportJobId", ASSET_BUNDLE_EXPORT_JOB_ID_FIELD);
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("ResourceArns", RESOURCE_ARNS_FIELD);
        map.put("IncludeAllDependencies", INCLUDE_ALL_DEPENDENCIES_FIELD);
        map.put("ExportFormat", EXPORT_FORMAT_FIELD);
        map.put("CloudFormationOverridePropertyConfiguration", CLOUD_FORMATION_OVERRIDE_PROPERTY_CONFIGURATION_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("IncludePermissions", INCLUDE_PERMISSIONS_FIELD);
        map.put("IncludeTags", INCLUDE_TAGS_FIELD);
        map.put("ValidationStrategy", VALIDATION_STRATEGY_FIELD);
        map.put("Warnings", WARNINGS_FIELD);
        map.put("IncludeFolderMemberships", INCLUDE_FOLDER_MEMBERSHIPS_FIELD);
        map.put("IncludeFolderMembers", INCLUDE_FOLDER_MEMBERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAssetBundleExportJobResponse, T> g) {
        return obj -> g.apply((DescribeAssetBundleExportJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private String jobStatus;
        private String downloadUrl;
        private List<AssetBundleExportJobError> errors = DefaultSdkAutoConstructList.getInstance();
        private String arn;
        private Instant createdTime;
        private String assetBundleExportJobId;
        private String awsAccountId;
        private List<String> resourceArns = DefaultSdkAutoConstructList.getInstance();
        private Boolean includeAllDependencies;
        private String exportFormat;
        private AssetBundleCloudFormationOverridePropertyConfiguration cloudFormationOverridePropertyConfiguration;
        private String requestId;
        private Integer status;
        private Boolean includePermissions;
        private Boolean includeTags;
        private AssetBundleExportJobValidationStrategy validationStrategy;
        private List<AssetBundleExportJobWarning> warnings = DefaultSdkAutoConstructList.getInstance();
        private Boolean includeFolderMemberships;
        private String includeFolderMembers;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAssetBundleExportJobResponse model) {
            super(model);
            this.jobStatus(model.jobStatus);
            this.downloadUrl(model.downloadUrl);
            this.errors(model.errors);
            this.arn(model.arn);
            this.createdTime(model.createdTime);
            this.assetBundleExportJobId(model.assetBundleExportJobId);
            this.awsAccountId(model.awsAccountId);
            this.resourceArns(model.resourceArns);
            this.includeAllDependencies(model.includeAllDependencies);
            this.exportFormat(model.exportFormat);
            this.cloudFormationOverridePropertyConfiguration(model.cloudFormationOverridePropertyConfiguration);
            this.requestId(model.requestId);
            this.status(model.status);
            this.includePermissions(model.includePermissions);
            this.includeTags(model.includeTags);
            this.validationStrategy(model.validationStrategy);
            this.warnings(model.warnings);
            this.includeFolderMemberships(model.includeFolderMemberships);
            this.includeFolderMembers(model.includeFolderMembers);
        }

        public final String getJobStatus() {
            return this.jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(AssetBundleExportJobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final String getDownloadUrl() {
            return this.downloadUrl;
        }

        public final void setDownloadUrl(String downloadUrl) {
            this.downloadUrl = downloadUrl;
        }

        @Override
        public final Builder downloadUrl(String downloadUrl) {
            this.downloadUrl = downloadUrl;
            return this;
        }

        public final List<AssetBundleExportJobError.Builder> getErrors() {
            List<AssetBundleExportJobError.Builder> result = AssetBundleExportJobErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<AssetBundleExportJobError.BuilderImpl> errors) {
            this.errors = AssetBundleExportJobErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<AssetBundleExportJobError> errors) {
            this.errors = AssetBundleExportJobErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(AssetBundleExportJobError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<AssetBundleExportJobError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (AssetBundleExportJobError)((AssetBundleExportJobError.Builder)AssetBundleExportJobError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getAssetBundleExportJobId() {
            return this.assetBundleExportJobId;
        }

        public final void setAssetBundleExportJobId(String assetBundleExportJobId) {
            this.assetBundleExportJobId = assetBundleExportJobId;
        }

        @Override
        public final Builder assetBundleExportJobId(String assetBundleExportJobId) {
            this.assetBundleExportJobId = assetBundleExportJobId;
            return this;
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final Collection<String> getResourceArns() {
            if (this.resourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceArns;
        }

        public final void setResourceArns(Collection<String> resourceArns) {
            this.resourceArns = AssetBundleResourceArnsCopier.copy(resourceArns);
        }

        @Override
        public final Builder resourceArns(Collection<String> resourceArns) {
            this.resourceArns = AssetBundleResourceArnsCopier.copy(resourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceArns(String ... resourceArns) {
            this.resourceArns(Arrays.asList(resourceArns));
            return this;
        }

        public final Boolean getIncludeAllDependencies() {
            return this.includeAllDependencies;
        }

        public final void setIncludeAllDependencies(Boolean includeAllDependencies) {
            this.includeAllDependencies = includeAllDependencies;
        }

        @Override
        public final Builder includeAllDependencies(Boolean includeAllDependencies) {
            this.includeAllDependencies = includeAllDependencies;
            return this;
        }

        public final String getExportFormat() {
            return this.exportFormat;
        }

        public final void setExportFormat(String exportFormat) {
            this.exportFormat = exportFormat;
        }

        @Override
        public final Builder exportFormat(String exportFormat) {
            this.exportFormat = exportFormat;
            return this;
        }

        @Override
        public final Builder exportFormat(AssetBundleExportFormat exportFormat) {
            this.exportFormat(exportFormat == null ? null : exportFormat.toString());
            return this;
        }

        public final AssetBundleCloudFormationOverridePropertyConfiguration.Builder getCloudFormationOverridePropertyConfiguration() {
            return this.cloudFormationOverridePropertyConfiguration != null ? this.cloudFormationOverridePropertyConfiguration.toBuilder() : null;
        }

        public final void setCloudFormationOverridePropertyConfiguration(AssetBundleCloudFormationOverridePropertyConfiguration.BuilderImpl cloudFormationOverridePropertyConfiguration) {
            this.cloudFormationOverridePropertyConfiguration = cloudFormationOverridePropertyConfiguration != null ? cloudFormationOverridePropertyConfiguration.build() : null;
        }

        @Override
        public final Builder cloudFormationOverridePropertyConfiguration(AssetBundleCloudFormationOverridePropertyConfiguration cloudFormationOverridePropertyConfiguration) {
            this.cloudFormationOverridePropertyConfiguration = cloudFormationOverridePropertyConfiguration;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final Boolean getIncludePermissions() {
            return this.includePermissions;
        }

        public final void setIncludePermissions(Boolean includePermissions) {
            this.includePermissions = includePermissions;
        }

        @Override
        public final Builder includePermissions(Boolean includePermissions) {
            this.includePermissions = includePermissions;
            return this;
        }

        public final Boolean getIncludeTags() {
            return this.includeTags;
        }

        public final void setIncludeTags(Boolean includeTags) {
            this.includeTags = includeTags;
        }

        @Override
        public final Builder includeTags(Boolean includeTags) {
            this.includeTags = includeTags;
            return this;
        }

        public final AssetBundleExportJobValidationStrategy.Builder getValidationStrategy() {
            return this.validationStrategy != null ? this.validationStrategy.toBuilder() : null;
        }

        public final void setValidationStrategy(AssetBundleExportJobValidationStrategy.BuilderImpl validationStrategy) {
            this.validationStrategy = validationStrategy != null ? validationStrategy.build() : null;
        }

        @Override
        public final Builder validationStrategy(AssetBundleExportJobValidationStrategy validationStrategy) {
            this.validationStrategy = validationStrategy;
            return this;
        }

        public final List<AssetBundleExportJobWarning.Builder> getWarnings() {
            List<AssetBundleExportJobWarning.Builder> result = AssetBundleExportJobWarningListCopier.copyToBuilder(this.warnings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWarnings(Collection<AssetBundleExportJobWarning.BuilderImpl> warnings) {
            this.warnings = AssetBundleExportJobWarningListCopier.copyFromBuilder(warnings);
        }

        @Override
        public final Builder warnings(Collection<AssetBundleExportJobWarning> warnings) {
            this.warnings = AssetBundleExportJobWarningListCopier.copy(warnings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(AssetBundleExportJobWarning ... warnings) {
            this.warnings(Arrays.asList(warnings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(Consumer<AssetBundleExportJobWarning.Builder> ... warnings) {
            this.warnings(Stream.of(warnings).map(c -> (AssetBundleExportJobWarning)((AssetBundleExportJobWarning.Builder)AssetBundleExportJobWarning.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIncludeFolderMemberships() {
            return this.includeFolderMemberships;
        }

        public final void setIncludeFolderMemberships(Boolean includeFolderMemberships) {
            this.includeFolderMemberships = includeFolderMemberships;
        }

        @Override
        public final Builder includeFolderMemberships(Boolean includeFolderMemberships) {
            this.includeFolderMemberships = includeFolderMemberships;
            return this;
        }

        public final String getIncludeFolderMembers() {
            return this.includeFolderMembers;
        }

        public final void setIncludeFolderMembers(String includeFolderMembers) {
            this.includeFolderMembers = includeFolderMembers;
        }

        @Override
        public final Builder includeFolderMembers(String includeFolderMembers) {
            this.includeFolderMembers = includeFolderMembers;
            return this;
        }

        @Override
        public final Builder includeFolderMembers(IncludeFolderMembers includeFolderMembers) {
            this.includeFolderMembers(includeFolderMembers == null ? null : includeFolderMembers.toString());
            return this;
        }

        @Override
        public DescribeAssetBundleExportJobResponse build() {
            return new DescribeAssetBundleExportJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAssetBundleExportJobResponse> {
        public Builder jobStatus(String var1);

        public Builder jobStatus(AssetBundleExportJobStatus var1);

        public Builder downloadUrl(String var1);

        public Builder errors(Collection<AssetBundleExportJobError> var1);

        public Builder errors(AssetBundleExportJobError ... var1);

        public Builder errors(Consumer<AssetBundleExportJobError.Builder> ... var1);

        public Builder arn(String var1);

        public Builder createdTime(Instant var1);

        public Builder assetBundleExportJobId(String var1);

        public Builder awsAccountId(String var1);

        public Builder resourceArns(Collection<String> var1);

        public Builder resourceArns(String ... var1);

        public Builder includeAllDependencies(Boolean var1);

        public Builder exportFormat(String var1);

        public Builder exportFormat(AssetBundleExportFormat var1);

        public Builder cloudFormationOverridePropertyConfiguration(AssetBundleCloudFormationOverridePropertyConfiguration var1);

        default public Builder cloudFormationOverridePropertyConfiguration(Consumer<AssetBundleCloudFormationOverridePropertyConfiguration.Builder> cloudFormationOverridePropertyConfiguration) {
            return this.cloudFormationOverridePropertyConfiguration((AssetBundleCloudFormationOverridePropertyConfiguration)((AssetBundleCloudFormationOverridePropertyConfiguration.Builder)AssetBundleCloudFormationOverridePropertyConfiguration.builder().applyMutation(cloudFormationOverridePropertyConfiguration)).build());
        }

        public Builder requestId(String var1);

        public Builder status(Integer var1);

        public Builder includePermissions(Boolean var1);

        public Builder includeTags(Boolean var1);

        public Builder validationStrategy(AssetBundleExportJobValidationStrategy var1);

        default public Builder validationStrategy(Consumer<AssetBundleExportJobValidationStrategy.Builder> validationStrategy) {
            return this.validationStrategy((AssetBundleExportJobValidationStrategy)((AssetBundleExportJobValidationStrategy.Builder)AssetBundleExportJobValidationStrategy.builder().applyMutation(validationStrategy)).build());
        }

        public Builder warnings(Collection<AssetBundleExportJobWarning> var1);

        public Builder warnings(AssetBundleExportJobWarning ... var1);

        public Builder warnings(Consumer<AssetBundleExportJobWarning.Builder> ... var1);

        public Builder includeFolderMemberships(Boolean var1);

        public Builder includeFolderMembers(String var1);

        public Builder includeFolderMembers(IncludeFolderMembers var1);
    }
}

