/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.DataAggregation;
import software.amazon.awssdk.services.quicksight.model.TopicCalculatedField;
import software.amazon.awssdk.services.quicksight.model.TopicCalculatedFieldsCopier;
import software.amazon.awssdk.services.quicksight.model.TopicColumn;
import software.amazon.awssdk.services.quicksight.model.TopicColumnsCopier;
import software.amazon.awssdk.services.quicksight.model.TopicFilter;
import software.amazon.awssdk.services.quicksight.model.TopicFiltersCopier;
import software.amazon.awssdk.services.quicksight.model.TopicNamedEntitiesCopier;
import software.amazon.awssdk.services.quicksight.model.TopicNamedEntity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatasetMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatasetMetadata> {
    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetArn").getter(DatasetMetadata.getter(DatasetMetadata::datasetArn)).setter(DatasetMetadata.setter(Builder::datasetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArn").build()}).build();
    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetName").getter(DatasetMetadata.getter(DatasetMetadata::datasetName)).setter(DatasetMetadata.setter(Builder::datasetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetName").build()}).build();
    private static final SdkField<String> DATASET_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetDescription").getter(DatasetMetadata.getter(DatasetMetadata::datasetDescription)).setter(DatasetMetadata.setter(Builder::datasetDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetDescription").build()}).build();
    private static final SdkField<DataAggregation> DATA_AGGREGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataAggregation").getter(DatasetMetadata.getter(DatasetMetadata::dataAggregation)).setter(DatasetMetadata.setter(Builder::dataAggregation)).constructor(DataAggregation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAggregation").build()}).build();
    private static final SdkField<List<TopicFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(DatasetMetadata.getter(DatasetMetadata::filters)).setter(DatasetMetadata.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TopicFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TopicColumn>> COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Columns").getter(DatasetMetadata.getter(DatasetMetadata::columns)).setter(DatasetMetadata.setter(Builder::columns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Columns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TopicColumn::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TopicCalculatedField>> CALCULATED_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CalculatedFields").getter(DatasetMetadata.getter(DatasetMetadata::calculatedFields)).setter(DatasetMetadata.setter(Builder::calculatedFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatedFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TopicCalculatedField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TopicNamedEntity>> NAMED_ENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NamedEntities").getter(DatasetMetadata.getter(DatasetMetadata::namedEntities)).setter(DatasetMetadata.setter(Builder::namedEntities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamedEntities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TopicNamedEntity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_ARN_FIELD, DATASET_NAME_FIELD, DATASET_DESCRIPTION_FIELD, DATA_AGGREGATION_FIELD, FILTERS_FIELD, COLUMNS_FIELD, CALCULATED_FIELDS_FIELD, NAMED_ENTITIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DatasetMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String datasetArn;
    private final String datasetName;
    private final String datasetDescription;
    private final DataAggregation dataAggregation;
    private final List<TopicFilter> filters;
    private final List<TopicColumn> columns;
    private final List<TopicCalculatedField> calculatedFields;
    private final List<TopicNamedEntity> namedEntities;

    private DatasetMetadata(BuilderImpl builder) {
        this.datasetArn = builder.datasetArn;
        this.datasetName = builder.datasetName;
        this.datasetDescription = builder.datasetDescription;
        this.dataAggregation = builder.dataAggregation;
        this.filters = builder.filters;
        this.columns = builder.columns;
        this.calculatedFields = builder.calculatedFields;
        this.namedEntities = builder.namedEntities;
    }

    public final String datasetArn() {
        return this.datasetArn;
    }

    public final String datasetName() {
        return this.datasetName;
    }

    public final String datasetDescription() {
        return this.datasetDescription;
    }

    public final DataAggregation dataAggregation() {
        return this.dataAggregation;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<TopicFilter> filters() {
        return this.filters;
    }

    public final boolean hasColumns() {
        return this.columns != null && !(this.columns instanceof SdkAutoConstructList);
    }

    public final List<TopicColumn> columns() {
        return this.columns;
    }

    public final boolean hasCalculatedFields() {
        return this.calculatedFields != null && !(this.calculatedFields instanceof SdkAutoConstructList);
    }

    public final List<TopicCalculatedField> calculatedFields() {
        return this.calculatedFields;
    }

    public final boolean hasNamedEntities() {
        return this.namedEntities != null && !(this.namedEntities instanceof SdkAutoConstructList);
    }

    public final List<TopicNamedEntity> namedEntities() {
        return this.namedEntities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumns() ? this.columns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCalculatedFields() ? this.calculatedFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNamedEntities() ? this.namedEntities() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetMetadata)) {
            return false;
        }
        DatasetMetadata other = (DatasetMetadata)obj;
        return Objects.equals(this.datasetArn(), other.datasetArn()) && Objects.equals(this.datasetName(), other.datasetName()) && Objects.equals(this.datasetDescription(), other.datasetDescription()) && Objects.equals(this.dataAggregation(), other.dataAggregation()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && this.hasColumns() == other.hasColumns() && Objects.equals(this.columns(), other.columns()) && this.hasCalculatedFields() == other.hasCalculatedFields() && Objects.equals(this.calculatedFields(), other.calculatedFields()) && this.hasNamedEntities() == other.hasNamedEntities() && Objects.equals(this.namedEntities(), other.namedEntities());
    }

    public final String toString() {
        return ToString.builder((String)"DatasetMetadata").add("DatasetArn", (Object)this.datasetArn()).add("DatasetName", (Object)this.datasetName()).add("DatasetDescription", (Object)this.datasetDescription()).add("DataAggregation", (Object)this.dataAggregation()).add("Filters", this.hasFilters() ? this.filters() : null).add("Columns", this.hasColumns() ? this.columns() : null).add("CalculatedFields", this.hasCalculatedFields() ? this.calculatedFields() : null).add("NamedEntities", this.hasNamedEntities() ? this.namedEntities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatasetArn": {
                return Optional.ofNullable(clazz.cast(this.datasetArn()));
            }
            case "DatasetName": {
                return Optional.ofNullable(clazz.cast(this.datasetName()));
            }
            case "DatasetDescription": {
                return Optional.ofNullable(clazz.cast(this.datasetDescription()));
            }
            case "DataAggregation": {
                return Optional.ofNullable(clazz.cast(this.dataAggregation()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "Columns": {
                return Optional.ofNullable(clazz.cast(this.columns()));
            }
            case "CalculatedFields": {
                return Optional.ofNullable(clazz.cast(this.calculatedFields()));
            }
            case "NamedEntities": {
                return Optional.ofNullable(clazz.cast(this.namedEntities()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DatasetArn", DATASET_ARN_FIELD);
        map.put("DatasetName", DATASET_NAME_FIELD);
        map.put("DatasetDescription", DATASET_DESCRIPTION_FIELD);
        map.put("DataAggregation", DATA_AGGREGATION_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("Columns", COLUMNS_FIELD);
        map.put("CalculatedFields", CALCULATED_FIELDS_FIELD);
        map.put("NamedEntities", NAMED_ENTITIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DatasetMetadata, T> g) {
        return obj -> g.apply((DatasetMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String datasetArn;
        private String datasetName;
        private String datasetDescription;
        private DataAggregation dataAggregation;
        private List<TopicFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private List<TopicColumn> columns = DefaultSdkAutoConstructList.getInstance();
        private List<TopicCalculatedField> calculatedFields = DefaultSdkAutoConstructList.getInstance();
        private List<TopicNamedEntity> namedEntities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetMetadata model) {
            this.datasetArn(model.datasetArn);
            this.datasetName(model.datasetName);
            this.datasetDescription(model.datasetDescription);
            this.dataAggregation(model.dataAggregation);
            this.filters(model.filters);
            this.columns(model.columns);
            this.calculatedFields(model.calculatedFields);
            this.namedEntities(model.namedEntities);
        }

        public final String getDatasetArn() {
            return this.datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final String getDatasetName() {
            return this.datasetName;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final String getDatasetDescription() {
            return this.datasetDescription;
        }

        public final void setDatasetDescription(String datasetDescription) {
            this.datasetDescription = datasetDescription;
        }

        @Override
        public final Builder datasetDescription(String datasetDescription) {
            this.datasetDescription = datasetDescription;
            return this;
        }

        public final DataAggregation.Builder getDataAggregation() {
            return this.dataAggregation != null ? this.dataAggregation.toBuilder() : null;
        }

        public final void setDataAggregation(DataAggregation.BuilderImpl dataAggregation) {
            this.dataAggregation = dataAggregation != null ? dataAggregation.build() : null;
        }

        @Override
        public final Builder dataAggregation(DataAggregation dataAggregation) {
            this.dataAggregation = dataAggregation;
            return this;
        }

        public final List<TopicFilter.Builder> getFilters() {
            List<TopicFilter.Builder> result = TopicFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<TopicFilter.BuilderImpl> filters) {
            this.filters = TopicFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<TopicFilter> filters) {
            this.filters = TopicFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(TopicFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<TopicFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (TopicFilter)((TopicFilter.Builder)TopicFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TopicColumn.Builder> getColumns() {
            List<TopicColumn.Builder> result = TopicColumnsCopier.copyToBuilder(this.columns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumns(Collection<TopicColumn.BuilderImpl> columns) {
            this.columns = TopicColumnsCopier.copyFromBuilder(columns);
        }

        @Override
        public final Builder columns(Collection<TopicColumn> columns) {
            this.columns = TopicColumnsCopier.copy(columns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columns(TopicColumn ... columns) {
            this.columns(Arrays.asList(columns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columns(Consumer<TopicColumn.Builder> ... columns) {
            this.columns(Stream.of(columns).map(c -> (TopicColumn)((TopicColumn.Builder)TopicColumn.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TopicCalculatedField.Builder> getCalculatedFields() {
            List<TopicCalculatedField.Builder> result = TopicCalculatedFieldsCopier.copyToBuilder(this.calculatedFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCalculatedFields(Collection<TopicCalculatedField.BuilderImpl> calculatedFields) {
            this.calculatedFields = TopicCalculatedFieldsCopier.copyFromBuilder(calculatedFields);
        }

        @Override
        public final Builder calculatedFields(Collection<TopicCalculatedField> calculatedFields) {
            this.calculatedFields = TopicCalculatedFieldsCopier.copy(calculatedFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder calculatedFields(TopicCalculatedField ... calculatedFields) {
            this.calculatedFields(Arrays.asList(calculatedFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder calculatedFields(Consumer<TopicCalculatedField.Builder> ... calculatedFields) {
            this.calculatedFields(Stream.of(calculatedFields).map(c -> (TopicCalculatedField)((TopicCalculatedField.Builder)TopicCalculatedField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TopicNamedEntity.Builder> getNamedEntities() {
            List<TopicNamedEntity.Builder> result = TopicNamedEntitiesCopier.copyToBuilder(this.namedEntities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNamedEntities(Collection<TopicNamedEntity.BuilderImpl> namedEntities) {
            this.namedEntities = TopicNamedEntitiesCopier.copyFromBuilder(namedEntities);
        }

        @Override
        public final Builder namedEntities(Collection<TopicNamedEntity> namedEntities) {
            this.namedEntities = TopicNamedEntitiesCopier.copy(namedEntities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namedEntities(TopicNamedEntity ... namedEntities) {
            this.namedEntities(Arrays.asList(namedEntities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namedEntities(Consumer<TopicNamedEntity.Builder> ... namedEntities) {
            this.namedEntities(Stream.of(namedEntities).map(c -> (TopicNamedEntity)((TopicNamedEntity.Builder)TopicNamedEntity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DatasetMetadata build() {
            return new DatasetMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatasetMetadata> {
        public Builder datasetArn(String var1);

        public Builder datasetName(String var1);

        public Builder datasetDescription(String var1);

        public Builder dataAggregation(DataAggregation var1);

        default public Builder dataAggregation(Consumer<DataAggregation.Builder> dataAggregation) {
            return this.dataAggregation((DataAggregation)((DataAggregation.Builder)DataAggregation.builder().applyMutation(dataAggregation)).build());
        }

        public Builder filters(Collection<TopicFilter> var1);

        public Builder filters(TopicFilter ... var1);

        public Builder filters(Consumer<TopicFilter.Builder> ... var1);

        public Builder columns(Collection<TopicColumn> var1);

        public Builder columns(TopicColumn ... var1);

        public Builder columns(Consumer<TopicColumn.Builder> ... var1);

        public Builder calculatedFields(Collection<TopicCalculatedField> var1);

        public Builder calculatedFields(TopicCalculatedField ... var1);

        public Builder calculatedFields(Consumer<TopicCalculatedField.Builder> ... var1);

        public Builder namedEntities(Collection<TopicNamedEntity> var1);

        public Builder namedEntities(TopicNamedEntity ... var1);

        public Builder namedEntities(Consumer<TopicNamedEntity.Builder> ... var1);
    }
}

