/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.NullValueFormatConfiguration;
import software.amazon.awssdk.services.quicksight.model.NumericFormatConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DateTimeFormatConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DateTimeFormatConfiguration> {
    private static final SdkField<String> DATE_TIME_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DateTimeFormat").getter(DateTimeFormatConfiguration.getter(DateTimeFormatConfiguration::dateTimeFormat)).setter(DateTimeFormatConfiguration.setter(Builder::dateTimeFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateTimeFormat").build()}).build();
    private static final SdkField<NullValueFormatConfiguration> NULL_VALUE_FORMAT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NullValueFormatConfiguration").getter(DateTimeFormatConfiguration.getter(DateTimeFormatConfiguration::nullValueFormatConfiguration)).setter(DateTimeFormatConfiguration.setter(Builder::nullValueFormatConfiguration)).constructor(NullValueFormatConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NullValueFormatConfiguration").build()}).build();
    private static final SdkField<NumericFormatConfiguration> NUMERIC_FORMAT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NumericFormatConfiguration").getter(DateTimeFormatConfiguration.getter(DateTimeFormatConfiguration::numericFormatConfiguration)).setter(DateTimeFormatConfiguration.setter(Builder::numericFormatConfiguration)).constructor(NumericFormatConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumericFormatConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATE_TIME_FORMAT_FIELD, NULL_VALUE_FORMAT_CONFIGURATION_FIELD, NUMERIC_FORMAT_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DateTimeFormatConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String dateTimeFormat;
    private final NullValueFormatConfiguration nullValueFormatConfiguration;
    private final NumericFormatConfiguration numericFormatConfiguration;

    private DateTimeFormatConfiguration(BuilderImpl builder) {
        this.dateTimeFormat = builder.dateTimeFormat;
        this.nullValueFormatConfiguration = builder.nullValueFormatConfiguration;
        this.numericFormatConfiguration = builder.numericFormatConfiguration;
    }

    public final String dateTimeFormat() {
        return this.dateTimeFormat;
    }

    public final NullValueFormatConfiguration nullValueFormatConfiguration() {
        return this.nullValueFormatConfiguration;
    }

    public final NumericFormatConfiguration numericFormatConfiguration() {
        return this.numericFormatConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dateTimeFormat());
        hashCode = 31 * hashCode + Objects.hashCode(this.nullValueFormatConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.numericFormatConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateTimeFormatConfiguration)) {
            return false;
        }
        DateTimeFormatConfiguration other = (DateTimeFormatConfiguration)obj;
        return Objects.equals(this.dateTimeFormat(), other.dateTimeFormat()) && Objects.equals(this.nullValueFormatConfiguration(), other.nullValueFormatConfiguration()) && Objects.equals(this.numericFormatConfiguration(), other.numericFormatConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"DateTimeFormatConfiguration").add("DateTimeFormat", (Object)this.dateTimeFormat()).add("NullValueFormatConfiguration", (Object)this.nullValueFormatConfiguration()).add("NumericFormatConfiguration", (Object)this.numericFormatConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DateTimeFormat": {
                return Optional.ofNullable(clazz.cast(this.dateTimeFormat()));
            }
            case "NullValueFormatConfiguration": {
                return Optional.ofNullable(clazz.cast(this.nullValueFormatConfiguration()));
            }
            case "NumericFormatConfiguration": {
                return Optional.ofNullable(clazz.cast(this.numericFormatConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DateTimeFormat", DATE_TIME_FORMAT_FIELD);
        map.put("NullValueFormatConfiguration", NULL_VALUE_FORMAT_CONFIGURATION_FIELD);
        map.put("NumericFormatConfiguration", NUMERIC_FORMAT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DateTimeFormatConfiguration, T> g) {
        return obj -> g.apply((DateTimeFormatConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dateTimeFormat;
        private NullValueFormatConfiguration nullValueFormatConfiguration;
        private NumericFormatConfiguration numericFormatConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DateTimeFormatConfiguration model) {
            this.dateTimeFormat(model.dateTimeFormat);
            this.nullValueFormatConfiguration(model.nullValueFormatConfiguration);
            this.numericFormatConfiguration(model.numericFormatConfiguration);
        }

        public final String getDateTimeFormat() {
            return this.dateTimeFormat;
        }

        public final void setDateTimeFormat(String dateTimeFormat) {
            this.dateTimeFormat = dateTimeFormat;
        }

        @Override
        public final Builder dateTimeFormat(String dateTimeFormat) {
            this.dateTimeFormat = dateTimeFormat;
            return this;
        }

        public final NullValueFormatConfiguration.Builder getNullValueFormatConfiguration() {
            return this.nullValueFormatConfiguration != null ? this.nullValueFormatConfiguration.toBuilder() : null;
        }

        public final void setNullValueFormatConfiguration(NullValueFormatConfiguration.BuilderImpl nullValueFormatConfiguration) {
            this.nullValueFormatConfiguration = nullValueFormatConfiguration != null ? nullValueFormatConfiguration.build() : null;
        }

        @Override
        public final Builder nullValueFormatConfiguration(NullValueFormatConfiguration nullValueFormatConfiguration) {
            this.nullValueFormatConfiguration = nullValueFormatConfiguration;
            return this;
        }

        public final NumericFormatConfiguration.Builder getNumericFormatConfiguration() {
            return this.numericFormatConfiguration != null ? this.numericFormatConfiguration.toBuilder() : null;
        }

        public final void setNumericFormatConfiguration(NumericFormatConfiguration.BuilderImpl numericFormatConfiguration) {
            this.numericFormatConfiguration = numericFormatConfiguration != null ? numericFormatConfiguration.build() : null;
        }

        @Override
        public final Builder numericFormatConfiguration(NumericFormatConfiguration numericFormatConfiguration) {
            this.numericFormatConfiguration = numericFormatConfiguration;
            return this;
        }

        public DateTimeFormatConfiguration build() {
            return new DateTimeFormatConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DateTimeFormatConfiguration> {
        public Builder dateTimeFormat(String var1);

        public Builder nullValueFormatConfiguration(NullValueFormatConfiguration var1);

        default public Builder nullValueFormatConfiguration(Consumer<NullValueFormatConfiguration.Builder> nullValueFormatConfiguration) {
            return this.nullValueFormatConfiguration((NullValueFormatConfiguration)((NullValueFormatConfiguration.Builder)NullValueFormatConfiguration.builder().applyMutation(nullValueFormatConfiguration)).build());
        }

        public Builder numericFormatConfiguration(NumericFormatConfiguration var1);

        default public Builder numericFormatConfiguration(Consumer<NumericFormatConfiguration.Builder> numericFormatConfiguration) {
            return this.numericFormatConfiguration((NumericFormatConfiguration)((NumericFormatConfiguration.Builder)NumericFormatConfiguration.builder().applyMutation(numericFormatConfiguration)).build());
        }
    }
}

