/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.URLTargetConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomActionURLOperation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomActionURLOperation> {
    private static final SdkField<String> URL_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("URLTemplate").getter(CustomActionURLOperation.getter(CustomActionURLOperation::urlTemplate)).setter(CustomActionURLOperation.setter(Builder::urlTemplate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("URLTemplate").build()}).build();
    private static final SdkField<String> URL_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("URLTarget").getter(CustomActionURLOperation.getter(CustomActionURLOperation::urlTargetAsString)).setter(CustomActionURLOperation.setter(Builder::urlTarget)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("URLTarget").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URL_TEMPLATE_FIELD, URL_TARGET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CustomActionURLOperation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String urlTemplate;
    private final String urlTarget;

    private CustomActionURLOperation(BuilderImpl builder) {
        this.urlTemplate = builder.urlTemplate;
        this.urlTarget = builder.urlTarget;
    }

    public final String urlTemplate() {
        return this.urlTemplate;
    }

    public final URLTargetConfiguration urlTarget() {
        return URLTargetConfiguration.fromValue(this.urlTarget);
    }

    public final String urlTargetAsString() {
        return this.urlTarget;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.urlTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.urlTargetAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomActionURLOperation)) {
            return false;
        }
        CustomActionURLOperation other = (CustomActionURLOperation)obj;
        return Objects.equals(this.urlTemplate(), other.urlTemplate()) && Objects.equals(this.urlTargetAsString(), other.urlTargetAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CustomActionURLOperation").add("URLTemplate", (Object)this.urlTemplate()).add("URLTarget", (Object)this.urlTargetAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "URLTemplate": {
                return Optional.ofNullable(clazz.cast(this.urlTemplate()));
            }
            case "URLTarget": {
                return Optional.ofNullable(clazz.cast(this.urlTargetAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("URLTemplate", URL_TEMPLATE_FIELD);
        map.put("URLTarget", URL_TARGET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomActionURLOperation, T> g) {
        return obj -> g.apply((CustomActionURLOperation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String urlTemplate;
        private String urlTarget;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomActionURLOperation model) {
            this.urlTemplate(model.urlTemplate);
            this.urlTarget(model.urlTarget);
        }

        public final String getUrlTemplate() {
            return this.urlTemplate;
        }

        public final void setUrlTemplate(String urlTemplate) {
            this.urlTemplate = urlTemplate;
        }

        @Override
        public final Builder urlTemplate(String urlTemplate) {
            this.urlTemplate = urlTemplate;
            return this;
        }

        public final String getUrlTarget() {
            return this.urlTarget;
        }

        public final void setUrlTarget(String urlTarget) {
            this.urlTarget = urlTarget;
        }

        @Override
        public final Builder urlTarget(String urlTarget) {
            this.urlTarget = urlTarget;
            return this;
        }

        @Override
        public final Builder urlTarget(URLTargetConfiguration urlTarget) {
            this.urlTarget(urlTarget == null ? null : urlTarget.toString());
            return this;
        }

        public CustomActionURLOperation build() {
            return new CustomActionURLOperation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomActionURLOperation> {
        public Builder urlTemplate(String var1);

        public Builder urlTarget(String var1);

        public Builder urlTarget(URLTargetConfiguration var1);
    }
}

