/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.DatasetParameterValueType;
import software.amazon.awssdk.services.quicksight.model.StringDatasetParameterDefaultValues;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StringDatasetParameter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StringDatasetParameter> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(StringDatasetParameter.getter(StringDatasetParameter::id)).setter(StringDatasetParameter.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(StringDatasetParameter.getter(StringDatasetParameter::name)).setter(StringDatasetParameter.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> VALUE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValueType").getter(StringDatasetParameter.getter(StringDatasetParameter::valueTypeAsString)).setter(StringDatasetParameter.setter(Builder::valueType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueType").build()}).build();
    private static final SdkField<StringDatasetParameterDefaultValues> DEFAULT_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultValues").getter(StringDatasetParameter.getter(StringDatasetParameter::defaultValues)).setter(StringDatasetParameter.setter(Builder::defaultValues)).constructor(StringDatasetParameterDefaultValues::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValues").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, VALUE_TYPE_FIELD, DEFAULT_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StringDatasetParameter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final String valueType;
    private final StringDatasetParameterDefaultValues defaultValues;

    private StringDatasetParameter(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.valueType = builder.valueType;
        this.defaultValues = builder.defaultValues;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final DatasetParameterValueType valueType() {
        return DatasetParameterValueType.fromValue(this.valueType);
    }

    public final String valueTypeAsString() {
        return this.valueType;
    }

    public final StringDatasetParameterDefaultValues defaultValues() {
        return this.defaultValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValues());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StringDatasetParameter)) {
            return false;
        }
        StringDatasetParameter other = (StringDatasetParameter)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.valueTypeAsString(), other.valueTypeAsString()) && Objects.equals(this.defaultValues(), other.defaultValues());
    }

    public final String toString() {
        return ToString.builder((String)"StringDatasetParameter").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("ValueType", (Object)this.valueTypeAsString()).add("DefaultValues", (Object)this.defaultValues()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ValueType": {
                return Optional.ofNullable(clazz.cast(this.valueTypeAsString()));
            }
            case "DefaultValues": {
                return Optional.ofNullable(clazz.cast(this.defaultValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("ValueType", VALUE_TYPE_FIELD);
        map.put("DefaultValues", DEFAULT_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StringDatasetParameter, T> g) {
        return obj -> g.apply((StringDatasetParameter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String valueType;
        private StringDatasetParameterDefaultValues defaultValues;

        private BuilderImpl() {
        }

        private BuilderImpl(StringDatasetParameter model) {
            this.id(model.id);
            this.name(model.name);
            this.valueType(model.valueType);
            this.defaultValues(model.defaultValues);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getValueType() {
            return this.valueType;
        }

        public final void setValueType(String valueType) {
            this.valueType = valueType;
        }

        @Override
        public final Builder valueType(String valueType) {
            this.valueType = valueType;
            return this;
        }

        @Override
        public final Builder valueType(DatasetParameterValueType valueType) {
            this.valueType(valueType == null ? null : valueType.toString());
            return this;
        }

        public final StringDatasetParameterDefaultValues.Builder getDefaultValues() {
            return this.defaultValues != null ? this.defaultValues.toBuilder() : null;
        }

        public final void setDefaultValues(StringDatasetParameterDefaultValues.BuilderImpl defaultValues) {
            this.defaultValues = defaultValues != null ? defaultValues.build() : null;
        }

        @Override
        public final Builder defaultValues(StringDatasetParameterDefaultValues defaultValues) {
            this.defaultValues = defaultValues;
            return this;
        }

        public StringDatasetParameter build() {
            return new StringDatasetParameter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StringDatasetParameter> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder valueType(String var1);

        public Builder valueType(DatasetParameterValueType var1);

        public Builder defaultValues(StringDatasetParameterDefaultValues var1);

        default public Builder defaultValues(Consumer<StringDatasetParameterDefaultValues.Builder> defaultValues) {
            return this.defaultValues((StringDatasetParameterDefaultValues)((StringDatasetParameterDefaultValues.Builder)StringDatasetParameterDefaultValues.builder().applyMutation(defaultValues)).build());
        }
    }
}

