/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.WordCloudCloudLayout;
import software.amazon.awssdk.services.quicksight.model.WordCloudWordCasing;
import software.amazon.awssdk.services.quicksight.model.WordCloudWordOrientation;
import software.amazon.awssdk.services.quicksight.model.WordCloudWordPadding;
import software.amazon.awssdk.services.quicksight.model.WordCloudWordScaling;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WordCloudOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WordCloudOptions> {
    private static final SdkField<String> WORD_ORIENTATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WordOrientation").getter(WordCloudOptions.getter(WordCloudOptions::wordOrientationAsString)).setter(WordCloudOptions.setter(Builder::wordOrientation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WordOrientation").build()}).build();
    private static final SdkField<String> WORD_SCALING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WordScaling").getter(WordCloudOptions.getter(WordCloudOptions::wordScalingAsString)).setter(WordCloudOptions.setter(Builder::wordScaling)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WordScaling").build()}).build();
    private static final SdkField<String> CLOUD_LAYOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CloudLayout").getter(WordCloudOptions.getter(WordCloudOptions::cloudLayoutAsString)).setter(WordCloudOptions.setter(Builder::cloudLayout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudLayout").build()}).build();
    private static final SdkField<String> WORD_CASING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WordCasing").getter(WordCloudOptions.getter(WordCloudOptions::wordCasingAsString)).setter(WordCloudOptions.setter(Builder::wordCasing)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WordCasing").build()}).build();
    private static final SdkField<String> WORD_PADDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WordPadding").getter(WordCloudOptions.getter(WordCloudOptions::wordPaddingAsString)).setter(WordCloudOptions.setter(Builder::wordPadding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WordPadding").build()}).build();
    private static final SdkField<Integer> MAXIMUM_STRING_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumStringLength").getter(WordCloudOptions.getter(WordCloudOptions::maximumStringLength)).setter(WordCloudOptions.setter(Builder::maximumStringLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumStringLength").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORD_ORIENTATION_FIELD, WORD_SCALING_FIELD, CLOUD_LAYOUT_FIELD, WORD_CASING_FIELD, WORD_PADDING_FIELD, MAXIMUM_STRING_LENGTH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WordCloudOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String wordOrientation;
    private final String wordScaling;
    private final String cloudLayout;
    private final String wordCasing;
    private final String wordPadding;
    private final Integer maximumStringLength;

    private WordCloudOptions(BuilderImpl builder) {
        this.wordOrientation = builder.wordOrientation;
        this.wordScaling = builder.wordScaling;
        this.cloudLayout = builder.cloudLayout;
        this.wordCasing = builder.wordCasing;
        this.wordPadding = builder.wordPadding;
        this.maximumStringLength = builder.maximumStringLength;
    }

    public final WordCloudWordOrientation wordOrientation() {
        return WordCloudWordOrientation.fromValue(this.wordOrientation);
    }

    public final String wordOrientationAsString() {
        return this.wordOrientation;
    }

    public final WordCloudWordScaling wordScaling() {
        return WordCloudWordScaling.fromValue(this.wordScaling);
    }

    public final String wordScalingAsString() {
        return this.wordScaling;
    }

    public final WordCloudCloudLayout cloudLayout() {
        return WordCloudCloudLayout.fromValue(this.cloudLayout);
    }

    public final String cloudLayoutAsString() {
        return this.cloudLayout;
    }

    public final WordCloudWordCasing wordCasing() {
        return WordCloudWordCasing.fromValue(this.wordCasing);
    }

    public final String wordCasingAsString() {
        return this.wordCasing;
    }

    public final WordCloudWordPadding wordPadding() {
        return WordCloudWordPadding.fromValue(this.wordPadding);
    }

    public final String wordPaddingAsString() {
        return this.wordPadding;
    }

    public final Integer maximumStringLength() {
        return this.maximumStringLength;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.wordOrientationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.wordScalingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudLayoutAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.wordCasingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.wordPaddingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumStringLength());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WordCloudOptions)) {
            return false;
        }
        WordCloudOptions other = (WordCloudOptions)obj;
        return Objects.equals(this.wordOrientationAsString(), other.wordOrientationAsString()) && Objects.equals(this.wordScalingAsString(), other.wordScalingAsString()) && Objects.equals(this.cloudLayoutAsString(), other.cloudLayoutAsString()) && Objects.equals(this.wordCasingAsString(), other.wordCasingAsString()) && Objects.equals(this.wordPaddingAsString(), other.wordPaddingAsString()) && Objects.equals(this.maximumStringLength(), other.maximumStringLength());
    }

    public final String toString() {
        return ToString.builder((String)"WordCloudOptions").add("WordOrientation", (Object)this.wordOrientationAsString()).add("WordScaling", (Object)this.wordScalingAsString()).add("CloudLayout", (Object)this.cloudLayoutAsString()).add("WordCasing", (Object)this.wordCasingAsString()).add("WordPadding", (Object)this.wordPaddingAsString()).add("MaximumStringLength", (Object)this.maximumStringLength()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WordOrientation": {
                return Optional.ofNullable(clazz.cast(this.wordOrientationAsString()));
            }
            case "WordScaling": {
                return Optional.ofNullable(clazz.cast(this.wordScalingAsString()));
            }
            case "CloudLayout": {
                return Optional.ofNullable(clazz.cast(this.cloudLayoutAsString()));
            }
            case "WordCasing": {
                return Optional.ofNullable(clazz.cast(this.wordCasingAsString()));
            }
            case "WordPadding": {
                return Optional.ofNullable(clazz.cast(this.wordPaddingAsString()));
            }
            case "MaximumStringLength": {
                return Optional.ofNullable(clazz.cast(this.maximumStringLength()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("WordOrientation", WORD_ORIENTATION_FIELD);
        map.put("WordScaling", WORD_SCALING_FIELD);
        map.put("CloudLayout", CLOUD_LAYOUT_FIELD);
        map.put("WordCasing", WORD_CASING_FIELD);
        map.put("WordPadding", WORD_PADDING_FIELD);
        map.put("MaximumStringLength", MAXIMUM_STRING_LENGTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WordCloudOptions, T> g) {
        return obj -> g.apply((WordCloudOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String wordOrientation;
        private String wordScaling;
        private String cloudLayout;
        private String wordCasing;
        private String wordPadding;
        private Integer maximumStringLength;

        private BuilderImpl() {
        }

        private BuilderImpl(WordCloudOptions model) {
            this.wordOrientation(model.wordOrientation);
            this.wordScaling(model.wordScaling);
            this.cloudLayout(model.cloudLayout);
            this.wordCasing(model.wordCasing);
            this.wordPadding(model.wordPadding);
            this.maximumStringLength(model.maximumStringLength);
        }

        public final String getWordOrientation() {
            return this.wordOrientation;
        }

        public final void setWordOrientation(String wordOrientation) {
            this.wordOrientation = wordOrientation;
        }

        @Override
        public final Builder wordOrientation(String wordOrientation) {
            this.wordOrientation = wordOrientation;
            return this;
        }

        @Override
        public final Builder wordOrientation(WordCloudWordOrientation wordOrientation) {
            this.wordOrientation(wordOrientation == null ? null : wordOrientation.toString());
            return this;
        }

        public final String getWordScaling() {
            return this.wordScaling;
        }

        public final void setWordScaling(String wordScaling) {
            this.wordScaling = wordScaling;
        }

        @Override
        public final Builder wordScaling(String wordScaling) {
            this.wordScaling = wordScaling;
            return this;
        }

        @Override
        public final Builder wordScaling(WordCloudWordScaling wordScaling) {
            this.wordScaling(wordScaling == null ? null : wordScaling.toString());
            return this;
        }

        public final String getCloudLayout() {
            return this.cloudLayout;
        }

        public final void setCloudLayout(String cloudLayout) {
            this.cloudLayout = cloudLayout;
        }

        @Override
        public final Builder cloudLayout(String cloudLayout) {
            this.cloudLayout = cloudLayout;
            return this;
        }

        @Override
        public final Builder cloudLayout(WordCloudCloudLayout cloudLayout) {
            this.cloudLayout(cloudLayout == null ? null : cloudLayout.toString());
            return this;
        }

        public final String getWordCasing() {
            return this.wordCasing;
        }

        public final void setWordCasing(String wordCasing) {
            this.wordCasing = wordCasing;
        }

        @Override
        public final Builder wordCasing(String wordCasing) {
            this.wordCasing = wordCasing;
            return this;
        }

        @Override
        public final Builder wordCasing(WordCloudWordCasing wordCasing) {
            this.wordCasing(wordCasing == null ? null : wordCasing.toString());
            return this;
        }

        public final String getWordPadding() {
            return this.wordPadding;
        }

        public final void setWordPadding(String wordPadding) {
            this.wordPadding = wordPadding;
        }

        @Override
        public final Builder wordPadding(String wordPadding) {
            this.wordPadding = wordPadding;
            return this;
        }

        @Override
        public final Builder wordPadding(WordCloudWordPadding wordPadding) {
            this.wordPadding(wordPadding == null ? null : wordPadding.toString());
            return this;
        }

        public final Integer getMaximumStringLength() {
            return this.maximumStringLength;
        }

        public final void setMaximumStringLength(Integer maximumStringLength) {
            this.maximumStringLength = maximumStringLength;
        }

        @Override
        public final Builder maximumStringLength(Integer maximumStringLength) {
            this.maximumStringLength = maximumStringLength;
            return this;
        }

        public WordCloudOptions build() {
            return new WordCloudOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WordCloudOptions> {
        public Builder wordOrientation(String var1);

        public Builder wordOrientation(WordCloudWordOrientation var1);

        public Builder wordScaling(String var1);

        public Builder wordScaling(WordCloudWordScaling var1);

        public Builder cloudLayout(String var1);

        public Builder cloudLayout(WordCloudCloudLayout var1);

        public Builder wordCasing(String var1);

        public Builder wordCasing(WordCloudWordCasing var1);

        public Builder wordPadding(String var1);

        public Builder wordPadding(WordCloudWordPadding var1);

        public Builder maximumStringLength(Integer var1);
    }
}

