/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.AggFunction;
import software.amazon.awssdk.services.quicksight.model.CalculatedFieldReferenceListCopier;
import software.amazon.awssdk.services.quicksight.model.DisplayFormat;
import software.amazon.awssdk.services.quicksight.model.DisplayFormatOptions;
import software.amazon.awssdk.services.quicksight.model.Identifier;
import software.amazon.awssdk.services.quicksight.model.NamedEntityRef;
import software.amazon.awssdk.services.quicksight.model.OperandListCopier;
import software.amazon.awssdk.services.quicksight.model.TopicIRComparisonMethod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TopicIRMetric
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TopicIRMetric> {
    private static final SdkField<Identifier> METRIC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MetricId").getter(TopicIRMetric.getter(TopicIRMetric::metricId)).setter(TopicIRMetric.setter(Builder::metricId)).constructor(Identifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricId").build()}).build();
    private static final SdkField<AggFunction> FUNCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Function").getter(TopicIRMetric.getter(TopicIRMetric::function)).setter(TopicIRMetric.setter(Builder::function)).constructor(AggFunction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Function").build()}).build();
    private static final SdkField<List<Identifier>> OPERANDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Operands").getter(TopicIRMetric.getter(TopicIRMetric::operands)).setter(TopicIRMetric.setter(Builder::operands)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operands").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Identifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TopicIRComparisonMethod> COMPARISON_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ComparisonMethod").getter(TopicIRMetric.getter(TopicIRMetric::comparisonMethod)).setter(TopicIRMetric.setter(Builder::comparisonMethod)).constructor(TopicIRComparisonMethod::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonMethod").build()}).build();
    private static final SdkField<String> EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Expression").getter(TopicIRMetric.getter(TopicIRMetric::expression)).setter(TopicIRMetric.setter(Builder::expression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build()}).build();
    private static final SdkField<List<Identifier>> CALCULATED_FIELD_REFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CalculatedFieldReferences").getter(TopicIRMetric.getter(TopicIRMetric::calculatedFieldReferences)).setter(TopicIRMetric.setter(Builder::calculatedFieldReferences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatedFieldReferences").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Identifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DISPLAY_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayFormat").getter(TopicIRMetric.getter(TopicIRMetric::displayFormatAsString)).setter(TopicIRMetric.setter(Builder::displayFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayFormat").build()}).build();
    private static final SdkField<DisplayFormatOptions> DISPLAY_FORMAT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DisplayFormatOptions").getter(TopicIRMetric.getter(TopicIRMetric::displayFormatOptions)).setter(TopicIRMetric.setter(Builder::displayFormatOptions)).constructor(DisplayFormatOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayFormatOptions").build()}).build();
    private static final SdkField<NamedEntityRef> NAMED_ENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NamedEntity").getter(TopicIRMetric.getter(TopicIRMetric::namedEntity)).setter(TopicIRMetric.setter(Builder::namedEntity)).constructor(NamedEntityRef::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamedEntity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_ID_FIELD, FUNCTION_FIELD, OPERANDS_FIELD, COMPARISON_METHOD_FIELD, EXPRESSION_FIELD, CALCULATED_FIELD_REFERENCES_FIELD, DISPLAY_FORMAT_FIELD, DISPLAY_FORMAT_OPTIONS_FIELD, NAMED_ENTITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TopicIRMetric.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Identifier metricId;
    private final AggFunction function;
    private final List<Identifier> operands;
    private final TopicIRComparisonMethod comparisonMethod;
    private final String expression;
    private final List<Identifier> calculatedFieldReferences;
    private final String displayFormat;
    private final DisplayFormatOptions displayFormatOptions;
    private final NamedEntityRef namedEntity;

    private TopicIRMetric(BuilderImpl builder) {
        this.metricId = builder.metricId;
        this.function = builder.function;
        this.operands = builder.operands;
        this.comparisonMethod = builder.comparisonMethod;
        this.expression = builder.expression;
        this.calculatedFieldReferences = builder.calculatedFieldReferences;
        this.displayFormat = builder.displayFormat;
        this.displayFormatOptions = builder.displayFormatOptions;
        this.namedEntity = builder.namedEntity;
    }

    public final Identifier metricId() {
        return this.metricId;
    }

    public final AggFunction function() {
        return this.function;
    }

    public final boolean hasOperands() {
        return this.operands != null && !(this.operands instanceof SdkAutoConstructList);
    }

    public final List<Identifier> operands() {
        return this.operands;
    }

    public final TopicIRComparisonMethod comparisonMethod() {
        return this.comparisonMethod;
    }

    public final String expression() {
        return this.expression;
    }

    public final boolean hasCalculatedFieldReferences() {
        return this.calculatedFieldReferences != null && !(this.calculatedFieldReferences instanceof SdkAutoConstructList);
    }

    public final List<Identifier> calculatedFieldReferences() {
        return this.calculatedFieldReferences;
    }

    public final DisplayFormat displayFormat() {
        return DisplayFormat.fromValue(this.displayFormat);
    }

    public final String displayFormatAsString() {
        return this.displayFormat;
    }

    public final DisplayFormatOptions displayFormatOptions() {
        return this.displayFormatOptions;
    }

    public final NamedEntityRef namedEntity() {
        return this.namedEntity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metricId());
        hashCode = 31 * hashCode + Objects.hashCode(this.function());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOperands() ? this.operands() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.comparisonMethod());
        hashCode = 31 * hashCode + Objects.hashCode(this.expression());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCalculatedFieldReferences() ? this.calculatedFieldReferences() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.displayFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayFormatOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.namedEntity());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicIRMetric)) {
            return false;
        }
        TopicIRMetric other = (TopicIRMetric)obj;
        return Objects.equals(this.metricId(), other.metricId()) && Objects.equals(this.function(), other.function()) && this.hasOperands() == other.hasOperands() && Objects.equals(this.operands(), other.operands()) && Objects.equals(this.comparisonMethod(), other.comparisonMethod()) && Objects.equals(this.expression(), other.expression()) && this.hasCalculatedFieldReferences() == other.hasCalculatedFieldReferences() && Objects.equals(this.calculatedFieldReferences(), other.calculatedFieldReferences()) && Objects.equals(this.displayFormatAsString(), other.displayFormatAsString()) && Objects.equals(this.displayFormatOptions(), other.displayFormatOptions()) && Objects.equals(this.namedEntity(), other.namedEntity());
    }

    public final String toString() {
        return ToString.builder((String)"TopicIRMetric").add("MetricId", (Object)this.metricId()).add("Function", (Object)this.function()).add("Operands", this.hasOperands() ? this.operands() : null).add("ComparisonMethod", (Object)this.comparisonMethod()).add("Expression", (Object)(this.expression() == null ? null : "*** Sensitive Data Redacted ***")).add("CalculatedFieldReferences", this.hasCalculatedFieldReferences() ? this.calculatedFieldReferences() : null).add("DisplayFormat", (Object)this.displayFormatAsString()).add("DisplayFormatOptions", (Object)this.displayFormatOptions()).add("NamedEntity", (Object)this.namedEntity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricId": {
                return Optional.ofNullable(clazz.cast(this.metricId()));
            }
            case "Function": {
                return Optional.ofNullable(clazz.cast(this.function()));
            }
            case "Operands": {
                return Optional.ofNullable(clazz.cast(this.operands()));
            }
            case "ComparisonMethod": {
                return Optional.ofNullable(clazz.cast(this.comparisonMethod()));
            }
            case "Expression": {
                return Optional.ofNullable(clazz.cast(this.expression()));
            }
            case "CalculatedFieldReferences": {
                return Optional.ofNullable(clazz.cast(this.calculatedFieldReferences()));
            }
            case "DisplayFormat": {
                return Optional.ofNullable(clazz.cast(this.displayFormatAsString()));
            }
            case "DisplayFormatOptions": {
                return Optional.ofNullable(clazz.cast(this.displayFormatOptions()));
            }
            case "NamedEntity": {
                return Optional.ofNullable(clazz.cast(this.namedEntity()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MetricId", METRIC_ID_FIELD);
        map.put("Function", FUNCTION_FIELD);
        map.put("Operands", OPERANDS_FIELD);
        map.put("ComparisonMethod", COMPARISON_METHOD_FIELD);
        map.put("Expression", EXPRESSION_FIELD);
        map.put("CalculatedFieldReferences", CALCULATED_FIELD_REFERENCES_FIELD);
        map.put("DisplayFormat", DISPLAY_FORMAT_FIELD);
        map.put("DisplayFormatOptions", DISPLAY_FORMAT_OPTIONS_FIELD);
        map.put("NamedEntity", NAMED_ENTITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TopicIRMetric, T> g) {
        return obj -> g.apply((TopicIRMetric)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Identifier metricId;
        private AggFunction function;
        private List<Identifier> operands = DefaultSdkAutoConstructList.getInstance();
        private TopicIRComparisonMethod comparisonMethod;
        private String expression;
        private List<Identifier> calculatedFieldReferences = DefaultSdkAutoConstructList.getInstance();
        private String displayFormat;
        private DisplayFormatOptions displayFormatOptions;
        private NamedEntityRef namedEntity;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicIRMetric model) {
            this.metricId(model.metricId);
            this.function(model.function);
            this.operands(model.operands);
            this.comparisonMethod(model.comparisonMethod);
            this.expression(model.expression);
            this.calculatedFieldReferences(model.calculatedFieldReferences);
            this.displayFormat(model.displayFormat);
            this.displayFormatOptions(model.displayFormatOptions);
            this.namedEntity(model.namedEntity);
        }

        public final Identifier.Builder getMetricId() {
            return this.metricId != null ? this.metricId.toBuilder() : null;
        }

        public final void setMetricId(Identifier.BuilderImpl metricId) {
            this.metricId = metricId != null ? metricId.build() : null;
        }

        @Override
        public final Builder metricId(Identifier metricId) {
            this.metricId = metricId;
            return this;
        }

        public final AggFunction.Builder getFunction() {
            return this.function != null ? this.function.toBuilder() : null;
        }

        public final void setFunction(AggFunction.BuilderImpl function) {
            this.function = function != null ? function.build() : null;
        }

        @Override
        public final Builder function(AggFunction function) {
            this.function = function;
            return this;
        }

        public final List<Identifier.Builder> getOperands() {
            List<Identifier.Builder> result = OperandListCopier.copyToBuilder(this.operands);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOperands(Collection<Identifier.BuilderImpl> operands) {
            this.operands = OperandListCopier.copyFromBuilder(operands);
        }

        @Override
        public final Builder operands(Collection<Identifier> operands) {
            this.operands = OperandListCopier.copy(operands);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operands(Identifier ... operands) {
            this.operands(Arrays.asList(operands));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operands(Consumer<Identifier.Builder> ... operands) {
            this.operands(Stream.of(operands).map(c -> (Identifier)((Identifier.Builder)Identifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final TopicIRComparisonMethod.Builder getComparisonMethod() {
            return this.comparisonMethod != null ? this.comparisonMethod.toBuilder() : null;
        }

        public final void setComparisonMethod(TopicIRComparisonMethod.BuilderImpl comparisonMethod) {
            this.comparisonMethod = comparisonMethod != null ? comparisonMethod.build() : null;
        }

        @Override
        public final Builder comparisonMethod(TopicIRComparisonMethod comparisonMethod) {
            this.comparisonMethod = comparisonMethod;
            return this;
        }

        public final String getExpression() {
            return this.expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final List<Identifier.Builder> getCalculatedFieldReferences() {
            List<Identifier.Builder> result = CalculatedFieldReferenceListCopier.copyToBuilder(this.calculatedFieldReferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCalculatedFieldReferences(Collection<Identifier.BuilderImpl> calculatedFieldReferences) {
            this.calculatedFieldReferences = CalculatedFieldReferenceListCopier.copyFromBuilder(calculatedFieldReferences);
        }

        @Override
        public final Builder calculatedFieldReferences(Collection<Identifier> calculatedFieldReferences) {
            this.calculatedFieldReferences = CalculatedFieldReferenceListCopier.copy(calculatedFieldReferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder calculatedFieldReferences(Identifier ... calculatedFieldReferences) {
            this.calculatedFieldReferences(Arrays.asList(calculatedFieldReferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder calculatedFieldReferences(Consumer<Identifier.Builder> ... calculatedFieldReferences) {
            this.calculatedFieldReferences(Stream.of(calculatedFieldReferences).map(c -> (Identifier)((Identifier.Builder)Identifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDisplayFormat() {
            return this.displayFormat;
        }

        public final void setDisplayFormat(String displayFormat) {
            this.displayFormat = displayFormat;
        }

        @Override
        public final Builder displayFormat(String displayFormat) {
            this.displayFormat = displayFormat;
            return this;
        }

        @Override
        public final Builder displayFormat(DisplayFormat displayFormat) {
            this.displayFormat(displayFormat == null ? null : displayFormat.toString());
            return this;
        }

        public final DisplayFormatOptions.Builder getDisplayFormatOptions() {
            return this.displayFormatOptions != null ? this.displayFormatOptions.toBuilder() : null;
        }

        public final void setDisplayFormatOptions(DisplayFormatOptions.BuilderImpl displayFormatOptions) {
            this.displayFormatOptions = displayFormatOptions != null ? displayFormatOptions.build() : null;
        }

        @Override
        public final Builder displayFormatOptions(DisplayFormatOptions displayFormatOptions) {
            this.displayFormatOptions = displayFormatOptions;
            return this;
        }

        public final NamedEntityRef.Builder getNamedEntity() {
            return this.namedEntity != null ? this.namedEntity.toBuilder() : null;
        }

        public final void setNamedEntity(NamedEntityRef.BuilderImpl namedEntity) {
            this.namedEntity = namedEntity != null ? namedEntity.build() : null;
        }

        @Override
        public final Builder namedEntity(NamedEntityRef namedEntity) {
            this.namedEntity = namedEntity;
            return this;
        }

        public TopicIRMetric build() {
            return new TopicIRMetric(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TopicIRMetric> {
        public Builder metricId(Identifier var1);

        default public Builder metricId(Consumer<Identifier.Builder> metricId) {
            return this.metricId((Identifier)((Identifier.Builder)Identifier.builder().applyMutation(metricId)).build());
        }

        public Builder function(AggFunction var1);

        default public Builder function(Consumer<AggFunction.Builder> function) {
            return this.function((AggFunction)((AggFunction.Builder)AggFunction.builder().applyMutation(function)).build());
        }

        public Builder operands(Collection<Identifier> var1);

        public Builder operands(Identifier ... var1);

        public Builder operands(Consumer<Identifier.Builder> ... var1);

        public Builder comparisonMethod(TopicIRComparisonMethod var1);

        default public Builder comparisonMethod(Consumer<TopicIRComparisonMethod.Builder> comparisonMethod) {
            return this.comparisonMethod((TopicIRComparisonMethod)((TopicIRComparisonMethod.Builder)TopicIRComparisonMethod.builder().applyMutation(comparisonMethod)).build());
        }

        public Builder expression(String var1);

        public Builder calculatedFieldReferences(Collection<Identifier> var1);

        public Builder calculatedFieldReferences(Identifier ... var1);

        public Builder calculatedFieldReferences(Consumer<Identifier.Builder> ... var1);

        public Builder displayFormat(String var1);

        public Builder displayFormat(DisplayFormat var1);

        public Builder displayFormatOptions(DisplayFormatOptions var1);

        default public Builder displayFormatOptions(Consumer<DisplayFormatOptions.Builder> displayFormatOptions) {
            return this.displayFormatOptions((DisplayFormatOptions)((DisplayFormatOptions.Builder)DisplayFormatOptions.builder().applyMutation(displayFormatOptions)).build());
        }

        public Builder namedEntity(NamedEntityRef var1);

        default public Builder namedEntity(Consumer<NamedEntityRef.Builder> namedEntity) {
            return this.namedEntity((NamedEntityRef)((NamedEntityRef.Builder)NamedEntityRef.builder().applyMutation(namedEntity)).build());
        }
    }
}

