/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.services.quicksight.model.TopicRefreshSchedule;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTopicRefreshScheduleResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, DescribeTopicRefreshScheduleResponse> {
    private static final SdkField<String> TOPIC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TopicId").getter(DescribeTopicRefreshScheduleResponse.getter(DescribeTopicRefreshScheduleResponse::topicId)).setter(DescribeTopicRefreshScheduleResponse.setter(Builder::topicId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicId").build()}).build();
    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TopicArn").getter(DescribeTopicRefreshScheduleResponse.getter(DescribeTopicRefreshScheduleResponse::topicArn)).setter(DescribeTopicRefreshScheduleResponse.setter(Builder::topicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicArn").build()}).build();
    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetArn").getter(DescribeTopicRefreshScheduleResponse.getter(DescribeTopicRefreshScheduleResponse::datasetArn)).setter(DescribeTopicRefreshScheduleResponse.setter(Builder::datasetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArn").build()}).build();
    private static final SdkField<TopicRefreshSchedule> REFRESH_SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RefreshSchedule").getter(DescribeTopicRefreshScheduleResponse.getter(DescribeTopicRefreshScheduleResponse::refreshSchedule)).setter(DescribeTopicRefreshScheduleResponse.setter(Builder::refreshSchedule)).constructor(TopicRefreshSchedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshSchedule").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(DescribeTopicRefreshScheduleResponse.getter(DescribeTopicRefreshScheduleResponse::status)).setter(DescribeTopicRefreshScheduleResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(DescribeTopicRefreshScheduleResponse.getter(DescribeTopicRefreshScheduleResponse::requestId)).setter(DescribeTopicRefreshScheduleResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_ID_FIELD, TOPIC_ARN_FIELD, DATASET_ARN_FIELD, REFRESH_SCHEDULE_FIELD, STATUS_FIELD, REQUEST_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeTopicRefreshScheduleResponse.memberNameToFieldInitializer();
    private final String topicId;
    private final String topicArn;
    private final String datasetArn;
    private final TopicRefreshSchedule refreshSchedule;
    private final Integer status;
    private final String requestId;

    private DescribeTopicRefreshScheduleResponse(BuilderImpl builder) {
        super(builder);
        this.topicId = builder.topicId;
        this.topicArn = builder.topicArn;
        this.datasetArn = builder.datasetArn;
        this.refreshSchedule = builder.refreshSchedule;
        this.status = builder.status;
        this.requestId = builder.requestId;
    }

    public final String topicId() {
        return this.topicId;
    }

    public final String topicArn() {
        return this.topicArn;
    }

    public final String datasetArn() {
        return this.datasetArn;
    }

    public final TopicRefreshSchedule refreshSchedule() {
        return this.refreshSchedule;
    }

    public final Integer status() {
        return this.status;
    }

    public final String requestId() {
        return this.requestId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.topicId());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshSchedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTopicRefreshScheduleResponse)) {
            return false;
        }
        DescribeTopicRefreshScheduleResponse other = (DescribeTopicRefreshScheduleResponse)((Object)obj);
        return Objects.equals(this.topicId(), other.topicId()) && Objects.equals(this.topicArn(), other.topicArn()) && Objects.equals(this.datasetArn(), other.datasetArn()) && Objects.equals(this.refreshSchedule(), other.refreshSchedule()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.requestId(), other.requestId());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTopicRefreshScheduleResponse").add("TopicId", (Object)this.topicId()).add("TopicArn", (Object)this.topicArn()).add("DatasetArn", (Object)this.datasetArn()).add("RefreshSchedule", (Object)this.refreshSchedule()).add("Status", (Object)this.status()).add("RequestId", (Object)this.requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TopicId": {
                return Optional.ofNullable(clazz.cast(this.topicId()));
            }
            case "TopicArn": {
                return Optional.ofNullable(clazz.cast(this.topicArn()));
            }
            case "DatasetArn": {
                return Optional.ofNullable(clazz.cast(this.datasetArn()));
            }
            case "RefreshSchedule": {
                return Optional.ofNullable(clazz.cast(this.refreshSchedule()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TopicId", TOPIC_ID_FIELD);
        map.put("TopicArn", TOPIC_ARN_FIELD);
        map.put("DatasetArn", DATASET_ARN_FIELD);
        map.put("RefreshSchedule", REFRESH_SCHEDULE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeTopicRefreshScheduleResponse, T> g) {
        return obj -> g.apply((DescribeTopicRefreshScheduleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private String topicId;
        private String topicArn;
        private String datasetArn;
        private TopicRefreshSchedule refreshSchedule;
        private Integer status;
        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTopicRefreshScheduleResponse model) {
            super(model);
            this.topicId(model.topicId);
            this.topicArn(model.topicArn);
            this.datasetArn(model.datasetArn);
            this.refreshSchedule(model.refreshSchedule);
            this.status(model.status);
            this.requestId(model.requestId);
        }

        public final String getTopicId() {
            return this.topicId;
        }

        public final void setTopicId(String topicId) {
            this.topicId = topicId;
        }

        @Override
        public final Builder topicId(String topicId) {
            this.topicId = topicId;
            return this;
        }

        public final String getTopicArn() {
            return this.topicArn;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final String getDatasetArn() {
            return this.datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final TopicRefreshSchedule.Builder getRefreshSchedule() {
            return this.refreshSchedule != null ? this.refreshSchedule.toBuilder() : null;
        }

        public final void setRefreshSchedule(TopicRefreshSchedule.BuilderImpl refreshSchedule) {
            this.refreshSchedule = refreshSchedule != null ? refreshSchedule.build() : null;
        }

        @Override
        public final Builder refreshSchedule(TopicRefreshSchedule refreshSchedule) {
            this.refreshSchedule = refreshSchedule;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public DescribeTopicRefreshScheduleResponse build() {
            return new DescribeTopicRefreshScheduleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTopicRefreshScheduleResponse> {
        public Builder topicId(String var1);

        public Builder topicArn(String var1);

        public Builder datasetArn(String var1);

        public Builder refreshSchedule(TopicRefreshSchedule var1);

        default public Builder refreshSchedule(Consumer<TopicRefreshSchedule.Builder> refreshSchedule) {
            return this.refreshSchedule((TopicRefreshSchedule)((TopicRefreshSchedule.Builder)TopicRefreshSchedule.builder().applyMutation(refreshSchedule)).build());
        }

        public Builder status(Integer var1);

        public Builder requestId(String var1);
    }
}

