/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.DataSourceCredentials;
import software.amazon.awssdk.services.quicksight.model.DataSourceParameters;
import software.amazon.awssdk.services.quicksight.model.DataSourceType;
import software.amazon.awssdk.services.quicksight.model.FolderArnListCopier;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.services.quicksight.model.ResourcePermission;
import software.amazon.awssdk.services.quicksight.model.ResourcePermissionListCopier;
import software.amazon.awssdk.services.quicksight.model.SslProperties;
import software.amazon.awssdk.services.quicksight.model.Tag;
import software.amazon.awssdk.services.quicksight.model.TagListCopier;
import software.amazon.awssdk.services.quicksight.model.VpcConnectionProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDataSourceRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, CreateDataSourceRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::awsAccountId)).setter(CreateDataSourceRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSourceId").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::dataSourceId)).setter(CreateDataSourceRequest.setter(Builder::dataSourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::name)).setter(CreateDataSourceRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::typeAsString)).setter(CreateDataSourceRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<DataSourceParameters> DATA_SOURCE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSourceParameters").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::dataSourceParameters)).setter(CreateDataSourceRequest.setter(Builder::dataSourceParameters)).constructor(DataSourceParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceParameters").build()}).build();
    private static final SdkField<DataSourceCredentials> CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Credentials").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::credentials)).setter(CreateDataSourceRequest.setter(Builder::credentials)).constructor(DataSourceCredentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credentials").build()}).build();
    private static final SdkField<List<ResourcePermission>> PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Permissions").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::permissions)).setter(CreateDataSourceRequest.setter(Builder::permissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourcePermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<VpcConnectionProperties> VPC_CONNECTION_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConnectionProperties").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::vpcConnectionProperties)).setter(CreateDataSourceRequest.setter(Builder::vpcConnectionProperties)).constructor(VpcConnectionProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConnectionProperties").build()}).build();
    private static final SdkField<SslProperties> SSL_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SslProperties").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::sslProperties)).setter(CreateDataSourceRequest.setter(Builder::sslProperties)).constructor(SslProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslProperties").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::tags)).setter(CreateDataSourceRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> FOLDER_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FolderArns").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::folderArns)).setter(CreateDataSourceRequest.setter(Builder::folderArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FolderArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, DATA_SOURCE_ID_FIELD, NAME_FIELD, TYPE_FIELD, DATA_SOURCE_PARAMETERS_FIELD, CREDENTIALS_FIELD, PERMISSIONS_FIELD, VPC_CONNECTION_PROPERTIES_FIELD, SSL_PROPERTIES_FIELD, TAGS_FIELD, FOLDER_ARNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDataSourceRequest.memberNameToFieldInitializer();
    private final String awsAccountId;
    private final String dataSourceId;
    private final String name;
    private final String type;
    private final DataSourceParameters dataSourceParameters;
    private final DataSourceCredentials credentials;
    private final List<ResourcePermission> permissions;
    private final VpcConnectionProperties vpcConnectionProperties;
    private final SslProperties sslProperties;
    private final List<Tag> tags;
    private final List<String> folderArns;

    private CreateDataSourceRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.dataSourceId = builder.dataSourceId;
        this.name = builder.name;
        this.type = builder.type;
        this.dataSourceParameters = builder.dataSourceParameters;
        this.credentials = builder.credentials;
        this.permissions = builder.permissions;
        this.vpcConnectionProperties = builder.vpcConnectionProperties;
        this.sslProperties = builder.sslProperties;
        this.tags = builder.tags;
        this.folderArns = builder.folderArns;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String dataSourceId() {
        return this.dataSourceId;
    }

    public final String name() {
        return this.name;
    }

    public final DataSourceType type() {
        return DataSourceType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final DataSourceParameters dataSourceParameters() {
        return this.dataSourceParameters;
    }

    public final DataSourceCredentials credentials() {
        return this.credentials;
    }

    public final boolean hasPermissions() {
        return this.permissions != null && !(this.permissions instanceof SdkAutoConstructList);
    }

    public final List<ResourcePermission> permissions() {
        return this.permissions;
    }

    public final VpcConnectionProperties vpcConnectionProperties() {
        return this.vpcConnectionProperties;
    }

    public final SslProperties sslProperties() {
        return this.sslProperties;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final boolean hasFolderArns() {
        return this.folderArns != null && !(this.folderArns instanceof SdkAutoConstructList);
    }

    public final List<String> folderArns() {
        return this.folderArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPermissions() ? this.permissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConnectionProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.sslProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFolderArns() ? this.folderArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataSourceRequest)) {
            return false;
        }
        CreateDataSourceRequest other = (CreateDataSourceRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.dataSourceId(), other.dataSourceId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.dataSourceParameters(), other.dataSourceParameters()) && Objects.equals(this.credentials(), other.credentials()) && this.hasPermissions() == other.hasPermissions() && Objects.equals(this.permissions(), other.permissions()) && Objects.equals(this.vpcConnectionProperties(), other.vpcConnectionProperties()) && Objects.equals(this.sslProperties(), other.sslProperties()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasFolderArns() == other.hasFolderArns() && Objects.equals(this.folderArns(), other.folderArns());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDataSourceRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("DataSourceId", (Object)this.dataSourceId()).add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("DataSourceParameters", (Object)this.dataSourceParameters()).add("Credentials", (Object)(this.credentials() == null ? null : "*** Sensitive Data Redacted ***")).add("Permissions", this.hasPermissions() ? this.permissions() : null).add("VpcConnectionProperties", (Object)this.vpcConnectionProperties()).add("SslProperties", (Object)this.sslProperties()).add("Tags", this.hasTags() ? this.tags() : null).add("FolderArns", this.hasFolderArns() ? this.folderArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "DataSourceId": {
                return Optional.ofNullable(clazz.cast(this.dataSourceId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "DataSourceParameters": {
                return Optional.ofNullable(clazz.cast(this.dataSourceParameters()));
            }
            case "Credentials": {
                return Optional.ofNullable(clazz.cast(this.credentials()));
            }
            case "Permissions": {
                return Optional.ofNullable(clazz.cast(this.permissions()));
            }
            case "VpcConnectionProperties": {
                return Optional.ofNullable(clazz.cast(this.vpcConnectionProperties()));
            }
            case "SslProperties": {
                return Optional.ofNullable(clazz.cast(this.sslProperties()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "FolderArns": {
                return Optional.ofNullable(clazz.cast(this.folderArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("DataSourceId", DATA_SOURCE_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("DataSourceParameters", DATA_SOURCE_PARAMETERS_FIELD);
        map.put("Credentials", CREDENTIALS_FIELD);
        map.put("Permissions", PERMISSIONS_FIELD);
        map.put("VpcConnectionProperties", VPC_CONNECTION_PROPERTIES_FIELD);
        map.put("SslProperties", SSL_PROPERTIES_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("FolderArns", FOLDER_ARNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDataSourceRequest, T> g) {
        return obj -> g.apply((CreateDataSourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String dataSourceId;
        private String name;
        private String type;
        private DataSourceParameters dataSourceParameters;
        private DataSourceCredentials credentials;
        private List<ResourcePermission> permissions = DefaultSdkAutoConstructList.getInstance();
        private VpcConnectionProperties vpcConnectionProperties;
        private SslProperties sslProperties;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<String> folderArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataSourceRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.dataSourceId(model.dataSourceId);
            this.name(model.name);
            this.type(model.type);
            this.dataSourceParameters(model.dataSourceParameters);
            this.credentials(model.credentials);
            this.permissions(model.permissions);
            this.vpcConnectionProperties(model.vpcConnectionProperties);
            this.sslProperties(model.sslProperties);
            this.tags(model.tags);
            this.folderArns(model.folderArns);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getDataSourceId() {
            return this.dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DataSourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final DataSourceParameters.Builder getDataSourceParameters() {
            return this.dataSourceParameters != null ? this.dataSourceParameters.toBuilder() : null;
        }

        public final void setDataSourceParameters(DataSourceParameters.BuilderImpl dataSourceParameters) {
            this.dataSourceParameters = dataSourceParameters != null ? dataSourceParameters.build() : null;
        }

        @Override
        public final Builder dataSourceParameters(DataSourceParameters dataSourceParameters) {
            this.dataSourceParameters = dataSourceParameters;
            return this;
        }

        public final DataSourceCredentials.Builder getCredentials() {
            return this.credentials != null ? this.credentials.toBuilder() : null;
        }

        public final void setCredentials(DataSourceCredentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(DataSourceCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final List<ResourcePermission.Builder> getPermissions() {
            List<ResourcePermission.Builder> result = ResourcePermissionListCopier.copyToBuilder(this.permissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPermissions(Collection<ResourcePermission.BuilderImpl> permissions) {
            this.permissions = ResourcePermissionListCopier.copyFromBuilder(permissions);
        }

        @Override
        public final Builder permissions(Collection<ResourcePermission> permissions) {
            this.permissions = ResourcePermissionListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(ResourcePermission ... permissions) {
            this.permissions(Arrays.asList(permissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Consumer<ResourcePermission.Builder> ... permissions) {
            this.permissions(Stream.of(permissions).map(c -> (ResourcePermission)((ResourcePermission.Builder)ResourcePermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final VpcConnectionProperties.Builder getVpcConnectionProperties() {
            return this.vpcConnectionProperties != null ? this.vpcConnectionProperties.toBuilder() : null;
        }

        public final void setVpcConnectionProperties(VpcConnectionProperties.BuilderImpl vpcConnectionProperties) {
            this.vpcConnectionProperties = vpcConnectionProperties != null ? vpcConnectionProperties.build() : null;
        }

        @Override
        public final Builder vpcConnectionProperties(VpcConnectionProperties vpcConnectionProperties) {
            this.vpcConnectionProperties = vpcConnectionProperties;
            return this;
        }

        public final SslProperties.Builder getSslProperties() {
            return this.sslProperties != null ? this.sslProperties.toBuilder() : null;
        }

        public final void setSslProperties(SslProperties.BuilderImpl sslProperties) {
            this.sslProperties = sslProperties != null ? sslProperties.build() : null;
        }

        @Override
        public final Builder sslProperties(SslProperties sslProperties) {
            this.sslProperties = sslProperties;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getFolderArns() {
            if (this.folderArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.folderArns;
        }

        public final void setFolderArns(Collection<String> folderArns) {
            this.folderArns = FolderArnListCopier.copy(folderArns);
        }

        @Override
        public final Builder folderArns(Collection<String> folderArns) {
            this.folderArns = FolderArnListCopier.copy(folderArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder folderArns(String ... folderArns) {
            this.folderArns(Arrays.asList(folderArns));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataSourceRequest build() {
            return new CreateDataSourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDataSourceRequest> {
        public Builder awsAccountId(String var1);

        public Builder dataSourceId(String var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(DataSourceType var1);

        public Builder dataSourceParameters(DataSourceParameters var1);

        default public Builder dataSourceParameters(Consumer<DataSourceParameters.Builder> dataSourceParameters) {
            return this.dataSourceParameters((DataSourceParameters)((DataSourceParameters.Builder)DataSourceParameters.builder().applyMutation(dataSourceParameters)).build());
        }

        public Builder credentials(DataSourceCredentials var1);

        default public Builder credentials(Consumer<DataSourceCredentials.Builder> credentials) {
            return this.credentials((DataSourceCredentials)((DataSourceCredentials.Builder)DataSourceCredentials.builder().applyMutation(credentials)).build());
        }

        public Builder permissions(Collection<ResourcePermission> var1);

        public Builder permissions(ResourcePermission ... var1);

        public Builder permissions(Consumer<ResourcePermission.Builder> ... var1);

        public Builder vpcConnectionProperties(VpcConnectionProperties var1);

        default public Builder vpcConnectionProperties(Consumer<VpcConnectionProperties.Builder> vpcConnectionProperties) {
            return this.vpcConnectionProperties((VpcConnectionProperties)((VpcConnectionProperties.Builder)VpcConnectionProperties.builder().applyMutation(vpcConnectionProperties)).build());
        }

        public Builder sslProperties(SslProperties var1);

        default public Builder sslProperties(Consumer<SslProperties.Builder> sslProperties) {
            return this.sslProperties((SslProperties)((SslProperties.Builder)SslProperties.builder().applyMutation(sslProperties)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder folderArns(Collection<String> var1);

        public Builder folderArns(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

