/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.BarChartVisual;
import software.amazon.awssdk.services.quicksight.model.BoxPlotVisual;
import software.amazon.awssdk.services.quicksight.model.ComboChartVisual;
import software.amazon.awssdk.services.quicksight.model.CustomContentVisual;
import software.amazon.awssdk.services.quicksight.model.EmptyVisual;
import software.amazon.awssdk.services.quicksight.model.FilledMapVisual;
import software.amazon.awssdk.services.quicksight.model.FunnelChartVisual;
import software.amazon.awssdk.services.quicksight.model.GaugeChartVisual;
import software.amazon.awssdk.services.quicksight.model.GeospatialMapVisual;
import software.amazon.awssdk.services.quicksight.model.HeatMapVisual;
import software.amazon.awssdk.services.quicksight.model.HistogramVisual;
import software.amazon.awssdk.services.quicksight.model.InsightVisual;
import software.amazon.awssdk.services.quicksight.model.KPIVisual;
import software.amazon.awssdk.services.quicksight.model.LayerMapVisual;
import software.amazon.awssdk.services.quicksight.model.LineChartVisual;
import software.amazon.awssdk.services.quicksight.model.PieChartVisual;
import software.amazon.awssdk.services.quicksight.model.PivotTableVisual;
import software.amazon.awssdk.services.quicksight.model.PluginVisual;
import software.amazon.awssdk.services.quicksight.model.RadarChartVisual;
import software.amazon.awssdk.services.quicksight.model.SankeyDiagramVisual;
import software.amazon.awssdk.services.quicksight.model.ScatterPlotVisual;
import software.amazon.awssdk.services.quicksight.model.TableVisual;
import software.amazon.awssdk.services.quicksight.model.TreeMapVisual;
import software.amazon.awssdk.services.quicksight.model.WaterfallVisual;
import software.amazon.awssdk.services.quicksight.model.WordCloudVisual;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Visual
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Visual> {
    private static final SdkField<TableVisual> TABLE_VISUAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TableVisual").getter(Visual.getter(Visual::tableVisual)).setter(Visual.setter(Builder::tableVisual)).constructor(TableVisual::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableVisual").build()}).build();
    private static final SdkField<PivotTableVisual> PIVOT_TABLE_VISUAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PivotTableVisual").getter(Visual.getter(Visual::pivotTableVisual)).setter(Visual.setter(Builder::pivotTableVisual)).constructor(PivotTableVisual::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PivotTableVisual").build()}).build();
    private static final SdkField<BarChartVisual> BAR_CHART_VISUAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BarChartVisual").getter(Visual.getter(Visual::barChartVisual)).setter(Visual.setter(Builder::barChartVisual)).constructor(BarChartVisual::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BarChartVisual").build()}).build();
    private static final SdkField<KPIVisual> KPI_VISUAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KPIVisual").getter(Visual.getter(Visual::kpiVisual)).setter(Visual.setter(Builder::kpiVisual)).constructor(KPIVisual::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KPIVisual").build()}).build();
    private static final SdkField<PieChartVisual> PIE_CHART_VISUAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PieChartVisual").getter(Visual.getter(Visual::pieChartVisual)).setter(Visual.setter(Builder::pieChartVisual)).constructor(PieChartVisual::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PieChartVisual").build()}).build();
    private static final SdkField<GaugeChartVisual> GAUGE_CHART_VISUAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GaugeChartVisual").getter(Visual.getter(Visual::gaugeChartVisual)).setter(Visual.setter(Builder::gaugeChartVisual)).constructor(GaugeChartVisual::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GaugeChartVisual").build()}).build();
    private static final SdkField<LineChartVisual> LINE_CHART_VISUAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LineChartVisual").getter(Visual.getter(Visual::lineChartVisual)).setter(Visual.setter(Builder::lineChartVisual)).constructor(LineChartVisual::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineChartVisual").build()}).build();
    private static final SdkField<HeatMapVisual> HEAT_MAP_VISUAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HeatMapVisual").getter(Visual.getter(Visual::heatMapVisual)).setter(Visual.setter(Builder::heatMapVisual)).constructor(HeatMapVisual::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeatMapVisual").build()}).build();
    private static final SdkField<TreeMapVisual> TREE_MAP_VISUAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TreeMapVisual").getter(Visual.getter(Visual::treeMapVisual)).setter(Visual.setter(Builder::treeMapVisual)).constructor(TreeMapVisual::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TreeMapVisual").build()}).build();
    private static final SdkField<GeospatialMapVisual> GEOSPATIAL_MAP_VISUAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GeospatialMapVisual").getter(Visual.getter(Visual::geospatialMapVisual)).setter(Visual.setter(Builder::geospatialMapVisual)).constructor(GeospatialMapVisual::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeospatialMapVisual").build()}).build();
    private static final SdkField<FilledMapVisual> FILLED_MAP_VISUAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FilledMapVisual").getter(Visual.getter(Visual::filledMapVisual)).setter(Visual.setter(Builder::filledMapVisual)).constructor(FilledMapVisual::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilledMapVisual").build()}).build();
    private static final SdkField<LayerMapVisual> LAYER_MAP_VISUAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LayerMapVisual").getter(Visual.getter(Visual::layerMapVisual)).setter(Visual.setter(Builder::layerMapVisual)).constructor(LayerMapVisual::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LayerMapVisual").build()}).build();
    private static final SdkField<FunnelChartVisual> FUNNEL_CHART_VISUAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FunnelChartVisual").getter(Visual.getter(Visual::funnelChartVisual)).setter(Visual.setter(Builder::funnelChartVisual)).constructor(FunnelChartVisual::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunnelChartVisual").build()}).build();
    private static final SdkField<ScatterPlotVisual> SCATTER_PLOT_VISUAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScatterPlotVisual").getter(Visual.getter(Visual::scatterPlotVisual)).setter(Visual.setter(Builder::scatterPlotVisual)).constructor(ScatterPlotVisual::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScatterPlotVisual").build()}).build();
    private static final SdkField<ComboChartVisual> COMBO_CHART_VISUAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ComboChartVisual").getter(Visual.getter(Visual::comboChartVisual)).setter(Visual.setter(Builder::comboChartVisual)).constructor(ComboChartVisual::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComboChartVisual").build()}).build();
    private static final SdkField<BoxPlotVisual> BOX_PLOT_VISUAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BoxPlotVisual").getter(Visual.getter(Visual::boxPlotVisual)).setter(Visual.setter(Builder::boxPlotVisual)).constructor(BoxPlotVisual::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoxPlotVisual").build()}).build();
    private static final SdkField<WaterfallVisual> WATERFALL_VISUAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WaterfallVisual").getter(Visual.getter(Visual::waterfallVisual)).setter(Visual.setter(Builder::waterfallVisual)).constructor(WaterfallVisual::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaterfallVisual").build()}).build();
    private static final SdkField<HistogramVisual> HISTOGRAM_VISUAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HistogramVisual").getter(Visual.getter(Visual::histogramVisual)).setter(Visual.setter(Builder::histogramVisual)).constructor(HistogramVisual::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HistogramVisual").build()}).build();
    private static final SdkField<WordCloudVisual> WORD_CLOUD_VISUAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WordCloudVisual").getter(Visual.getter(Visual::wordCloudVisual)).setter(Visual.setter(Builder::wordCloudVisual)).constructor(WordCloudVisual::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WordCloudVisual").build()}).build();
    private static final SdkField<InsightVisual> INSIGHT_VISUAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InsightVisual").getter(Visual.getter(Visual::insightVisual)).setter(Visual.setter(Builder::insightVisual)).constructor(InsightVisual::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightVisual").build()}).build();
    private static final SdkField<SankeyDiagramVisual> SANKEY_DIAGRAM_VISUAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SankeyDiagramVisual").getter(Visual.getter(Visual::sankeyDiagramVisual)).setter(Visual.setter(Builder::sankeyDiagramVisual)).constructor(SankeyDiagramVisual::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SankeyDiagramVisual").build()}).build();
    private static final SdkField<CustomContentVisual> CUSTOM_CONTENT_VISUAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomContentVisual").getter(Visual.getter(Visual::customContentVisual)).setter(Visual.setter(Builder::customContentVisual)).constructor(CustomContentVisual::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomContentVisual").build()}).build();
    private static final SdkField<EmptyVisual> EMPTY_VISUAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EmptyVisual").getter(Visual.getter(Visual::emptyVisual)).setter(Visual.setter(Builder::emptyVisual)).constructor(EmptyVisual::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmptyVisual").build()}).build();
    private static final SdkField<RadarChartVisual> RADAR_CHART_VISUAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RadarChartVisual").getter(Visual.getter(Visual::radarChartVisual)).setter(Visual.setter(Builder::radarChartVisual)).constructor(RadarChartVisual::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RadarChartVisual").build()}).build();
    private static final SdkField<PluginVisual> PLUGIN_VISUAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PluginVisual").getter(Visual.getter(Visual::pluginVisual)).setter(Visual.setter(Builder::pluginVisual)).constructor(PluginVisual::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PluginVisual").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_VISUAL_FIELD, PIVOT_TABLE_VISUAL_FIELD, BAR_CHART_VISUAL_FIELD, KPI_VISUAL_FIELD, PIE_CHART_VISUAL_FIELD, GAUGE_CHART_VISUAL_FIELD, LINE_CHART_VISUAL_FIELD, HEAT_MAP_VISUAL_FIELD, TREE_MAP_VISUAL_FIELD, GEOSPATIAL_MAP_VISUAL_FIELD, FILLED_MAP_VISUAL_FIELD, LAYER_MAP_VISUAL_FIELD, FUNNEL_CHART_VISUAL_FIELD, SCATTER_PLOT_VISUAL_FIELD, COMBO_CHART_VISUAL_FIELD, BOX_PLOT_VISUAL_FIELD, WATERFALL_VISUAL_FIELD, HISTOGRAM_VISUAL_FIELD, WORD_CLOUD_VISUAL_FIELD, INSIGHT_VISUAL_FIELD, SANKEY_DIAGRAM_VISUAL_FIELD, CUSTOM_CONTENT_VISUAL_FIELD, EMPTY_VISUAL_FIELD, RADAR_CHART_VISUAL_FIELD, PLUGIN_VISUAL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Visual.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final TableVisual tableVisual;
    private final PivotTableVisual pivotTableVisual;
    private final BarChartVisual barChartVisual;
    private final KPIVisual kpiVisual;
    private final PieChartVisual pieChartVisual;
    private final GaugeChartVisual gaugeChartVisual;
    private final LineChartVisual lineChartVisual;
    private final HeatMapVisual heatMapVisual;
    private final TreeMapVisual treeMapVisual;
    private final GeospatialMapVisual geospatialMapVisual;
    private final FilledMapVisual filledMapVisual;
    private final LayerMapVisual layerMapVisual;
    private final FunnelChartVisual funnelChartVisual;
    private final ScatterPlotVisual scatterPlotVisual;
    private final ComboChartVisual comboChartVisual;
    private final BoxPlotVisual boxPlotVisual;
    private final WaterfallVisual waterfallVisual;
    private final HistogramVisual histogramVisual;
    private final WordCloudVisual wordCloudVisual;
    private final InsightVisual insightVisual;
    private final SankeyDiagramVisual sankeyDiagramVisual;
    private final CustomContentVisual customContentVisual;
    private final EmptyVisual emptyVisual;
    private final RadarChartVisual radarChartVisual;
    private final PluginVisual pluginVisual;

    private Visual(BuilderImpl builder) {
        this.tableVisual = builder.tableVisual;
        this.pivotTableVisual = builder.pivotTableVisual;
        this.barChartVisual = builder.barChartVisual;
        this.kpiVisual = builder.kpiVisual;
        this.pieChartVisual = builder.pieChartVisual;
        this.gaugeChartVisual = builder.gaugeChartVisual;
        this.lineChartVisual = builder.lineChartVisual;
        this.heatMapVisual = builder.heatMapVisual;
        this.treeMapVisual = builder.treeMapVisual;
        this.geospatialMapVisual = builder.geospatialMapVisual;
        this.filledMapVisual = builder.filledMapVisual;
        this.layerMapVisual = builder.layerMapVisual;
        this.funnelChartVisual = builder.funnelChartVisual;
        this.scatterPlotVisual = builder.scatterPlotVisual;
        this.comboChartVisual = builder.comboChartVisual;
        this.boxPlotVisual = builder.boxPlotVisual;
        this.waterfallVisual = builder.waterfallVisual;
        this.histogramVisual = builder.histogramVisual;
        this.wordCloudVisual = builder.wordCloudVisual;
        this.insightVisual = builder.insightVisual;
        this.sankeyDiagramVisual = builder.sankeyDiagramVisual;
        this.customContentVisual = builder.customContentVisual;
        this.emptyVisual = builder.emptyVisual;
        this.radarChartVisual = builder.radarChartVisual;
        this.pluginVisual = builder.pluginVisual;
    }

    public final TableVisual tableVisual() {
        return this.tableVisual;
    }

    public final PivotTableVisual pivotTableVisual() {
        return this.pivotTableVisual;
    }

    public final BarChartVisual barChartVisual() {
        return this.barChartVisual;
    }

    public final KPIVisual kpiVisual() {
        return this.kpiVisual;
    }

    public final PieChartVisual pieChartVisual() {
        return this.pieChartVisual;
    }

    public final GaugeChartVisual gaugeChartVisual() {
        return this.gaugeChartVisual;
    }

    public final LineChartVisual lineChartVisual() {
        return this.lineChartVisual;
    }

    public final HeatMapVisual heatMapVisual() {
        return this.heatMapVisual;
    }

    public final TreeMapVisual treeMapVisual() {
        return this.treeMapVisual;
    }

    public final GeospatialMapVisual geospatialMapVisual() {
        return this.geospatialMapVisual;
    }

    public final FilledMapVisual filledMapVisual() {
        return this.filledMapVisual;
    }

    public final LayerMapVisual layerMapVisual() {
        return this.layerMapVisual;
    }

    public final FunnelChartVisual funnelChartVisual() {
        return this.funnelChartVisual;
    }

    public final ScatterPlotVisual scatterPlotVisual() {
        return this.scatterPlotVisual;
    }

    public final ComboChartVisual comboChartVisual() {
        return this.comboChartVisual;
    }

    public final BoxPlotVisual boxPlotVisual() {
        return this.boxPlotVisual;
    }

    public final WaterfallVisual waterfallVisual() {
        return this.waterfallVisual;
    }

    public final HistogramVisual histogramVisual() {
        return this.histogramVisual;
    }

    public final WordCloudVisual wordCloudVisual() {
        return this.wordCloudVisual;
    }

    public final InsightVisual insightVisual() {
        return this.insightVisual;
    }

    public final SankeyDiagramVisual sankeyDiagramVisual() {
        return this.sankeyDiagramVisual;
    }

    public final CustomContentVisual customContentVisual() {
        return this.customContentVisual;
    }

    public final EmptyVisual emptyVisual() {
        return this.emptyVisual;
    }

    public final RadarChartVisual radarChartVisual() {
        return this.radarChartVisual;
    }

    public final PluginVisual pluginVisual() {
        return this.pluginVisual;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tableVisual());
        hashCode = 31 * hashCode + Objects.hashCode(this.pivotTableVisual());
        hashCode = 31 * hashCode + Objects.hashCode(this.barChartVisual());
        hashCode = 31 * hashCode + Objects.hashCode(this.kpiVisual());
        hashCode = 31 * hashCode + Objects.hashCode(this.pieChartVisual());
        hashCode = 31 * hashCode + Objects.hashCode(this.gaugeChartVisual());
        hashCode = 31 * hashCode + Objects.hashCode(this.lineChartVisual());
        hashCode = 31 * hashCode + Objects.hashCode(this.heatMapVisual());
        hashCode = 31 * hashCode + Objects.hashCode(this.treeMapVisual());
        hashCode = 31 * hashCode + Objects.hashCode(this.geospatialMapVisual());
        hashCode = 31 * hashCode + Objects.hashCode(this.filledMapVisual());
        hashCode = 31 * hashCode + Objects.hashCode(this.layerMapVisual());
        hashCode = 31 * hashCode + Objects.hashCode(this.funnelChartVisual());
        hashCode = 31 * hashCode + Objects.hashCode(this.scatterPlotVisual());
        hashCode = 31 * hashCode + Objects.hashCode(this.comboChartVisual());
        hashCode = 31 * hashCode + Objects.hashCode(this.boxPlotVisual());
        hashCode = 31 * hashCode + Objects.hashCode(this.waterfallVisual());
        hashCode = 31 * hashCode + Objects.hashCode(this.histogramVisual());
        hashCode = 31 * hashCode + Objects.hashCode(this.wordCloudVisual());
        hashCode = 31 * hashCode + Objects.hashCode(this.insightVisual());
        hashCode = 31 * hashCode + Objects.hashCode(this.sankeyDiagramVisual());
        hashCode = 31 * hashCode + Objects.hashCode(this.customContentVisual());
        hashCode = 31 * hashCode + Objects.hashCode(this.emptyVisual());
        hashCode = 31 * hashCode + Objects.hashCode(this.radarChartVisual());
        hashCode = 31 * hashCode + Objects.hashCode(this.pluginVisual());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Visual)) {
            return false;
        }
        Visual other = (Visual)obj;
        return Objects.equals(this.tableVisual(), other.tableVisual()) && Objects.equals(this.pivotTableVisual(), other.pivotTableVisual()) && Objects.equals(this.barChartVisual(), other.barChartVisual()) && Objects.equals(this.kpiVisual(), other.kpiVisual()) && Objects.equals(this.pieChartVisual(), other.pieChartVisual()) && Objects.equals(this.gaugeChartVisual(), other.gaugeChartVisual()) && Objects.equals(this.lineChartVisual(), other.lineChartVisual()) && Objects.equals(this.heatMapVisual(), other.heatMapVisual()) && Objects.equals(this.treeMapVisual(), other.treeMapVisual()) && Objects.equals(this.geospatialMapVisual(), other.geospatialMapVisual()) && Objects.equals(this.filledMapVisual(), other.filledMapVisual()) && Objects.equals(this.layerMapVisual(), other.layerMapVisual()) && Objects.equals(this.funnelChartVisual(), other.funnelChartVisual()) && Objects.equals(this.scatterPlotVisual(), other.scatterPlotVisual()) && Objects.equals(this.comboChartVisual(), other.comboChartVisual()) && Objects.equals(this.boxPlotVisual(), other.boxPlotVisual()) && Objects.equals(this.waterfallVisual(), other.waterfallVisual()) && Objects.equals(this.histogramVisual(), other.histogramVisual()) && Objects.equals(this.wordCloudVisual(), other.wordCloudVisual()) && Objects.equals(this.insightVisual(), other.insightVisual()) && Objects.equals(this.sankeyDiagramVisual(), other.sankeyDiagramVisual()) && Objects.equals(this.customContentVisual(), other.customContentVisual()) && Objects.equals(this.emptyVisual(), other.emptyVisual()) && Objects.equals(this.radarChartVisual(), other.radarChartVisual()) && Objects.equals(this.pluginVisual(), other.pluginVisual());
    }

    public final String toString() {
        return ToString.builder((String)"Visual").add("TableVisual", (Object)this.tableVisual()).add("PivotTableVisual", (Object)this.pivotTableVisual()).add("BarChartVisual", (Object)this.barChartVisual()).add("KPIVisual", (Object)this.kpiVisual()).add("PieChartVisual", (Object)this.pieChartVisual()).add("GaugeChartVisual", (Object)this.gaugeChartVisual()).add("LineChartVisual", (Object)this.lineChartVisual()).add("HeatMapVisual", (Object)this.heatMapVisual()).add("TreeMapVisual", (Object)this.treeMapVisual()).add("GeospatialMapVisual", (Object)this.geospatialMapVisual()).add("FilledMapVisual", (Object)this.filledMapVisual()).add("LayerMapVisual", (Object)this.layerMapVisual()).add("FunnelChartVisual", (Object)this.funnelChartVisual()).add("ScatterPlotVisual", (Object)this.scatterPlotVisual()).add("ComboChartVisual", (Object)this.comboChartVisual()).add("BoxPlotVisual", (Object)this.boxPlotVisual()).add("WaterfallVisual", (Object)this.waterfallVisual()).add("HistogramVisual", (Object)this.histogramVisual()).add("WordCloudVisual", (Object)this.wordCloudVisual()).add("InsightVisual", (Object)this.insightVisual()).add("SankeyDiagramVisual", (Object)this.sankeyDiagramVisual()).add("CustomContentVisual", (Object)this.customContentVisual()).add("EmptyVisual", (Object)this.emptyVisual()).add("RadarChartVisual", (Object)this.radarChartVisual()).add("PluginVisual", (Object)this.pluginVisual()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableVisual": {
                return Optional.ofNullable(clazz.cast(this.tableVisual()));
            }
            case "PivotTableVisual": {
                return Optional.ofNullable(clazz.cast(this.pivotTableVisual()));
            }
            case "BarChartVisual": {
                return Optional.ofNullable(clazz.cast(this.barChartVisual()));
            }
            case "KPIVisual": {
                return Optional.ofNullable(clazz.cast(this.kpiVisual()));
            }
            case "PieChartVisual": {
                return Optional.ofNullable(clazz.cast(this.pieChartVisual()));
            }
            case "GaugeChartVisual": {
                return Optional.ofNullable(clazz.cast(this.gaugeChartVisual()));
            }
            case "LineChartVisual": {
                return Optional.ofNullable(clazz.cast(this.lineChartVisual()));
            }
            case "HeatMapVisual": {
                return Optional.ofNullable(clazz.cast(this.heatMapVisual()));
            }
            case "TreeMapVisual": {
                return Optional.ofNullable(clazz.cast(this.treeMapVisual()));
            }
            case "GeospatialMapVisual": {
                return Optional.ofNullable(clazz.cast(this.geospatialMapVisual()));
            }
            case "FilledMapVisual": {
                return Optional.ofNullable(clazz.cast(this.filledMapVisual()));
            }
            case "LayerMapVisual": {
                return Optional.ofNullable(clazz.cast(this.layerMapVisual()));
            }
            case "FunnelChartVisual": {
                return Optional.ofNullable(clazz.cast(this.funnelChartVisual()));
            }
            case "ScatterPlotVisual": {
                return Optional.ofNullable(clazz.cast(this.scatterPlotVisual()));
            }
            case "ComboChartVisual": {
                return Optional.ofNullable(clazz.cast(this.comboChartVisual()));
            }
            case "BoxPlotVisual": {
                return Optional.ofNullable(clazz.cast(this.boxPlotVisual()));
            }
            case "WaterfallVisual": {
                return Optional.ofNullable(clazz.cast(this.waterfallVisual()));
            }
            case "HistogramVisual": {
                return Optional.ofNullable(clazz.cast(this.histogramVisual()));
            }
            case "WordCloudVisual": {
                return Optional.ofNullable(clazz.cast(this.wordCloudVisual()));
            }
            case "InsightVisual": {
                return Optional.ofNullable(clazz.cast(this.insightVisual()));
            }
            case "SankeyDiagramVisual": {
                return Optional.ofNullable(clazz.cast(this.sankeyDiagramVisual()));
            }
            case "CustomContentVisual": {
                return Optional.ofNullable(clazz.cast(this.customContentVisual()));
            }
            case "EmptyVisual": {
                return Optional.ofNullable(clazz.cast(this.emptyVisual()));
            }
            case "RadarChartVisual": {
                return Optional.ofNullable(clazz.cast(this.radarChartVisual()));
            }
            case "PluginVisual": {
                return Optional.ofNullable(clazz.cast(this.pluginVisual()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TableVisual", TABLE_VISUAL_FIELD);
        map.put("PivotTableVisual", PIVOT_TABLE_VISUAL_FIELD);
        map.put("BarChartVisual", BAR_CHART_VISUAL_FIELD);
        map.put("KPIVisual", KPI_VISUAL_FIELD);
        map.put("PieChartVisual", PIE_CHART_VISUAL_FIELD);
        map.put("GaugeChartVisual", GAUGE_CHART_VISUAL_FIELD);
        map.put("LineChartVisual", LINE_CHART_VISUAL_FIELD);
        map.put("HeatMapVisual", HEAT_MAP_VISUAL_FIELD);
        map.put("TreeMapVisual", TREE_MAP_VISUAL_FIELD);
        map.put("GeospatialMapVisual", GEOSPATIAL_MAP_VISUAL_FIELD);
        map.put("FilledMapVisual", FILLED_MAP_VISUAL_FIELD);
        map.put("LayerMapVisual", LAYER_MAP_VISUAL_FIELD);
        map.put("FunnelChartVisual", FUNNEL_CHART_VISUAL_FIELD);
        map.put("ScatterPlotVisual", SCATTER_PLOT_VISUAL_FIELD);
        map.put("ComboChartVisual", COMBO_CHART_VISUAL_FIELD);
        map.put("BoxPlotVisual", BOX_PLOT_VISUAL_FIELD);
        map.put("WaterfallVisual", WATERFALL_VISUAL_FIELD);
        map.put("HistogramVisual", HISTOGRAM_VISUAL_FIELD);
        map.put("WordCloudVisual", WORD_CLOUD_VISUAL_FIELD);
        map.put("InsightVisual", INSIGHT_VISUAL_FIELD);
        map.put("SankeyDiagramVisual", SANKEY_DIAGRAM_VISUAL_FIELD);
        map.put("CustomContentVisual", CUSTOM_CONTENT_VISUAL_FIELD);
        map.put("EmptyVisual", EMPTY_VISUAL_FIELD);
        map.put("RadarChartVisual", RADAR_CHART_VISUAL_FIELD);
        map.put("PluginVisual", PLUGIN_VISUAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Visual, T> g) {
        return obj -> g.apply((Visual)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private TableVisual tableVisual;
        private PivotTableVisual pivotTableVisual;
        private BarChartVisual barChartVisual;
        private KPIVisual kpiVisual;
        private PieChartVisual pieChartVisual;
        private GaugeChartVisual gaugeChartVisual;
        private LineChartVisual lineChartVisual;
        private HeatMapVisual heatMapVisual;
        private TreeMapVisual treeMapVisual;
        private GeospatialMapVisual geospatialMapVisual;
        private FilledMapVisual filledMapVisual;
        private LayerMapVisual layerMapVisual;
        private FunnelChartVisual funnelChartVisual;
        private ScatterPlotVisual scatterPlotVisual;
        private ComboChartVisual comboChartVisual;
        private BoxPlotVisual boxPlotVisual;
        private WaterfallVisual waterfallVisual;
        private HistogramVisual histogramVisual;
        private WordCloudVisual wordCloudVisual;
        private InsightVisual insightVisual;
        private SankeyDiagramVisual sankeyDiagramVisual;
        private CustomContentVisual customContentVisual;
        private EmptyVisual emptyVisual;
        private RadarChartVisual radarChartVisual;
        private PluginVisual pluginVisual;

        private BuilderImpl() {
        }

        private BuilderImpl(Visual model) {
            this.tableVisual(model.tableVisual);
            this.pivotTableVisual(model.pivotTableVisual);
            this.barChartVisual(model.barChartVisual);
            this.kpiVisual(model.kpiVisual);
            this.pieChartVisual(model.pieChartVisual);
            this.gaugeChartVisual(model.gaugeChartVisual);
            this.lineChartVisual(model.lineChartVisual);
            this.heatMapVisual(model.heatMapVisual);
            this.treeMapVisual(model.treeMapVisual);
            this.geospatialMapVisual(model.geospatialMapVisual);
            this.filledMapVisual(model.filledMapVisual);
            this.layerMapVisual(model.layerMapVisual);
            this.funnelChartVisual(model.funnelChartVisual);
            this.scatterPlotVisual(model.scatterPlotVisual);
            this.comboChartVisual(model.comboChartVisual);
            this.boxPlotVisual(model.boxPlotVisual);
            this.waterfallVisual(model.waterfallVisual);
            this.histogramVisual(model.histogramVisual);
            this.wordCloudVisual(model.wordCloudVisual);
            this.insightVisual(model.insightVisual);
            this.sankeyDiagramVisual(model.sankeyDiagramVisual);
            this.customContentVisual(model.customContentVisual);
            this.emptyVisual(model.emptyVisual);
            this.radarChartVisual(model.radarChartVisual);
            this.pluginVisual(model.pluginVisual);
        }

        public final TableVisual.Builder getTableVisual() {
            return this.tableVisual != null ? this.tableVisual.toBuilder() : null;
        }

        public final void setTableVisual(TableVisual.BuilderImpl tableVisual) {
            this.tableVisual = tableVisual != null ? tableVisual.build() : null;
        }

        @Override
        public final Builder tableVisual(TableVisual tableVisual) {
            this.tableVisual = tableVisual;
            return this;
        }

        public final PivotTableVisual.Builder getPivotTableVisual() {
            return this.pivotTableVisual != null ? this.pivotTableVisual.toBuilder() : null;
        }

        public final void setPivotTableVisual(PivotTableVisual.BuilderImpl pivotTableVisual) {
            this.pivotTableVisual = pivotTableVisual != null ? pivotTableVisual.build() : null;
        }

        @Override
        public final Builder pivotTableVisual(PivotTableVisual pivotTableVisual) {
            this.pivotTableVisual = pivotTableVisual;
            return this;
        }

        public final BarChartVisual.Builder getBarChartVisual() {
            return this.barChartVisual != null ? this.barChartVisual.toBuilder() : null;
        }

        public final void setBarChartVisual(BarChartVisual.BuilderImpl barChartVisual) {
            this.barChartVisual = barChartVisual != null ? barChartVisual.build() : null;
        }

        @Override
        public final Builder barChartVisual(BarChartVisual barChartVisual) {
            this.barChartVisual = barChartVisual;
            return this;
        }

        public final KPIVisual.Builder getKpiVisual() {
            return this.kpiVisual != null ? this.kpiVisual.toBuilder() : null;
        }

        public final void setKpiVisual(KPIVisual.BuilderImpl kpiVisual) {
            this.kpiVisual = kpiVisual != null ? kpiVisual.build() : null;
        }

        @Override
        public final Builder kpiVisual(KPIVisual kpiVisual) {
            this.kpiVisual = kpiVisual;
            return this;
        }

        public final PieChartVisual.Builder getPieChartVisual() {
            return this.pieChartVisual != null ? this.pieChartVisual.toBuilder() : null;
        }

        public final void setPieChartVisual(PieChartVisual.BuilderImpl pieChartVisual) {
            this.pieChartVisual = pieChartVisual != null ? pieChartVisual.build() : null;
        }

        @Override
        public final Builder pieChartVisual(PieChartVisual pieChartVisual) {
            this.pieChartVisual = pieChartVisual;
            return this;
        }

        public final GaugeChartVisual.Builder getGaugeChartVisual() {
            return this.gaugeChartVisual != null ? this.gaugeChartVisual.toBuilder() : null;
        }

        public final void setGaugeChartVisual(GaugeChartVisual.BuilderImpl gaugeChartVisual) {
            this.gaugeChartVisual = gaugeChartVisual != null ? gaugeChartVisual.build() : null;
        }

        @Override
        public final Builder gaugeChartVisual(GaugeChartVisual gaugeChartVisual) {
            this.gaugeChartVisual = gaugeChartVisual;
            return this;
        }

        public final LineChartVisual.Builder getLineChartVisual() {
            return this.lineChartVisual != null ? this.lineChartVisual.toBuilder() : null;
        }

        public final void setLineChartVisual(LineChartVisual.BuilderImpl lineChartVisual) {
            this.lineChartVisual = lineChartVisual != null ? lineChartVisual.build() : null;
        }

        @Override
        public final Builder lineChartVisual(LineChartVisual lineChartVisual) {
            this.lineChartVisual = lineChartVisual;
            return this;
        }

        public final HeatMapVisual.Builder getHeatMapVisual() {
            return this.heatMapVisual != null ? this.heatMapVisual.toBuilder() : null;
        }

        public final void setHeatMapVisual(HeatMapVisual.BuilderImpl heatMapVisual) {
            this.heatMapVisual = heatMapVisual != null ? heatMapVisual.build() : null;
        }

        @Override
        public final Builder heatMapVisual(HeatMapVisual heatMapVisual) {
            this.heatMapVisual = heatMapVisual;
            return this;
        }

        public final TreeMapVisual.Builder getTreeMapVisual() {
            return this.treeMapVisual != null ? this.treeMapVisual.toBuilder() : null;
        }

        public final void setTreeMapVisual(TreeMapVisual.BuilderImpl treeMapVisual) {
            this.treeMapVisual = treeMapVisual != null ? treeMapVisual.build() : null;
        }

        @Override
        public final Builder treeMapVisual(TreeMapVisual treeMapVisual) {
            this.treeMapVisual = treeMapVisual;
            return this;
        }

        public final GeospatialMapVisual.Builder getGeospatialMapVisual() {
            return this.geospatialMapVisual != null ? this.geospatialMapVisual.toBuilder() : null;
        }

        public final void setGeospatialMapVisual(GeospatialMapVisual.BuilderImpl geospatialMapVisual) {
            this.geospatialMapVisual = geospatialMapVisual != null ? geospatialMapVisual.build() : null;
        }

        @Override
        public final Builder geospatialMapVisual(GeospatialMapVisual geospatialMapVisual) {
            this.geospatialMapVisual = geospatialMapVisual;
            return this;
        }

        public final FilledMapVisual.Builder getFilledMapVisual() {
            return this.filledMapVisual != null ? this.filledMapVisual.toBuilder() : null;
        }

        public final void setFilledMapVisual(FilledMapVisual.BuilderImpl filledMapVisual) {
            this.filledMapVisual = filledMapVisual != null ? filledMapVisual.build() : null;
        }

        @Override
        public final Builder filledMapVisual(FilledMapVisual filledMapVisual) {
            this.filledMapVisual = filledMapVisual;
            return this;
        }

        public final LayerMapVisual.Builder getLayerMapVisual() {
            return this.layerMapVisual != null ? this.layerMapVisual.toBuilder() : null;
        }

        public final void setLayerMapVisual(LayerMapVisual.BuilderImpl layerMapVisual) {
            this.layerMapVisual = layerMapVisual != null ? layerMapVisual.build() : null;
        }

        @Override
        public final Builder layerMapVisual(LayerMapVisual layerMapVisual) {
            this.layerMapVisual = layerMapVisual;
            return this;
        }

        public final FunnelChartVisual.Builder getFunnelChartVisual() {
            return this.funnelChartVisual != null ? this.funnelChartVisual.toBuilder() : null;
        }

        public final void setFunnelChartVisual(FunnelChartVisual.BuilderImpl funnelChartVisual) {
            this.funnelChartVisual = funnelChartVisual != null ? funnelChartVisual.build() : null;
        }

        @Override
        public final Builder funnelChartVisual(FunnelChartVisual funnelChartVisual) {
            this.funnelChartVisual = funnelChartVisual;
            return this;
        }

        public final ScatterPlotVisual.Builder getScatterPlotVisual() {
            return this.scatterPlotVisual != null ? this.scatterPlotVisual.toBuilder() : null;
        }

        public final void setScatterPlotVisual(ScatterPlotVisual.BuilderImpl scatterPlotVisual) {
            this.scatterPlotVisual = scatterPlotVisual != null ? scatterPlotVisual.build() : null;
        }

        @Override
        public final Builder scatterPlotVisual(ScatterPlotVisual scatterPlotVisual) {
            this.scatterPlotVisual = scatterPlotVisual;
            return this;
        }

        public final ComboChartVisual.Builder getComboChartVisual() {
            return this.comboChartVisual != null ? this.comboChartVisual.toBuilder() : null;
        }

        public final void setComboChartVisual(ComboChartVisual.BuilderImpl comboChartVisual) {
            this.comboChartVisual = comboChartVisual != null ? comboChartVisual.build() : null;
        }

        @Override
        public final Builder comboChartVisual(ComboChartVisual comboChartVisual) {
            this.comboChartVisual = comboChartVisual;
            return this;
        }

        public final BoxPlotVisual.Builder getBoxPlotVisual() {
            return this.boxPlotVisual != null ? this.boxPlotVisual.toBuilder() : null;
        }

        public final void setBoxPlotVisual(BoxPlotVisual.BuilderImpl boxPlotVisual) {
            this.boxPlotVisual = boxPlotVisual != null ? boxPlotVisual.build() : null;
        }

        @Override
        public final Builder boxPlotVisual(BoxPlotVisual boxPlotVisual) {
            this.boxPlotVisual = boxPlotVisual;
            return this;
        }

        public final WaterfallVisual.Builder getWaterfallVisual() {
            return this.waterfallVisual != null ? this.waterfallVisual.toBuilder() : null;
        }

        public final void setWaterfallVisual(WaterfallVisual.BuilderImpl waterfallVisual) {
            this.waterfallVisual = waterfallVisual != null ? waterfallVisual.build() : null;
        }

        @Override
        public final Builder waterfallVisual(WaterfallVisual waterfallVisual) {
            this.waterfallVisual = waterfallVisual;
            return this;
        }

        public final HistogramVisual.Builder getHistogramVisual() {
            return this.histogramVisual != null ? this.histogramVisual.toBuilder() : null;
        }

        public final void setHistogramVisual(HistogramVisual.BuilderImpl histogramVisual) {
            this.histogramVisual = histogramVisual != null ? histogramVisual.build() : null;
        }

        @Override
        public final Builder histogramVisual(HistogramVisual histogramVisual) {
            this.histogramVisual = histogramVisual;
            return this;
        }

        public final WordCloudVisual.Builder getWordCloudVisual() {
            return this.wordCloudVisual != null ? this.wordCloudVisual.toBuilder() : null;
        }

        public final void setWordCloudVisual(WordCloudVisual.BuilderImpl wordCloudVisual) {
            this.wordCloudVisual = wordCloudVisual != null ? wordCloudVisual.build() : null;
        }

        @Override
        public final Builder wordCloudVisual(WordCloudVisual wordCloudVisual) {
            this.wordCloudVisual = wordCloudVisual;
            return this;
        }

        public final InsightVisual.Builder getInsightVisual() {
            return this.insightVisual != null ? this.insightVisual.toBuilder() : null;
        }

        public final void setInsightVisual(InsightVisual.BuilderImpl insightVisual) {
            this.insightVisual = insightVisual != null ? insightVisual.build() : null;
        }

        @Override
        public final Builder insightVisual(InsightVisual insightVisual) {
            this.insightVisual = insightVisual;
            return this;
        }

        public final SankeyDiagramVisual.Builder getSankeyDiagramVisual() {
            return this.sankeyDiagramVisual != null ? this.sankeyDiagramVisual.toBuilder() : null;
        }

        public final void setSankeyDiagramVisual(SankeyDiagramVisual.BuilderImpl sankeyDiagramVisual) {
            this.sankeyDiagramVisual = sankeyDiagramVisual != null ? sankeyDiagramVisual.build() : null;
        }

        @Override
        public final Builder sankeyDiagramVisual(SankeyDiagramVisual sankeyDiagramVisual) {
            this.sankeyDiagramVisual = sankeyDiagramVisual;
            return this;
        }

        public final CustomContentVisual.Builder getCustomContentVisual() {
            return this.customContentVisual != null ? this.customContentVisual.toBuilder() : null;
        }

        public final void setCustomContentVisual(CustomContentVisual.BuilderImpl customContentVisual) {
            this.customContentVisual = customContentVisual != null ? customContentVisual.build() : null;
        }

        @Override
        public final Builder customContentVisual(CustomContentVisual customContentVisual) {
            this.customContentVisual = customContentVisual;
            return this;
        }

        public final EmptyVisual.Builder getEmptyVisual() {
            return this.emptyVisual != null ? this.emptyVisual.toBuilder() : null;
        }

        public final void setEmptyVisual(EmptyVisual.BuilderImpl emptyVisual) {
            this.emptyVisual = emptyVisual != null ? emptyVisual.build() : null;
        }

        @Override
        public final Builder emptyVisual(EmptyVisual emptyVisual) {
            this.emptyVisual = emptyVisual;
            return this;
        }

        public final RadarChartVisual.Builder getRadarChartVisual() {
            return this.radarChartVisual != null ? this.radarChartVisual.toBuilder() : null;
        }

        public final void setRadarChartVisual(RadarChartVisual.BuilderImpl radarChartVisual) {
            this.radarChartVisual = radarChartVisual != null ? radarChartVisual.build() : null;
        }

        @Override
        public final Builder radarChartVisual(RadarChartVisual radarChartVisual) {
            this.radarChartVisual = radarChartVisual;
            return this;
        }

        public final PluginVisual.Builder getPluginVisual() {
            return this.pluginVisual != null ? this.pluginVisual.toBuilder() : null;
        }

        public final void setPluginVisual(PluginVisual.BuilderImpl pluginVisual) {
            this.pluginVisual = pluginVisual != null ? pluginVisual.build() : null;
        }

        @Override
        public final Builder pluginVisual(PluginVisual pluginVisual) {
            this.pluginVisual = pluginVisual;
            return this;
        }

        public Visual build() {
            return new Visual(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Visual> {
        public Builder tableVisual(TableVisual var1);

        default public Builder tableVisual(Consumer<TableVisual.Builder> tableVisual) {
            return this.tableVisual((TableVisual)((TableVisual.Builder)TableVisual.builder().applyMutation(tableVisual)).build());
        }

        public Builder pivotTableVisual(PivotTableVisual var1);

        default public Builder pivotTableVisual(Consumer<PivotTableVisual.Builder> pivotTableVisual) {
            return this.pivotTableVisual((PivotTableVisual)((PivotTableVisual.Builder)PivotTableVisual.builder().applyMutation(pivotTableVisual)).build());
        }

        public Builder barChartVisual(BarChartVisual var1);

        default public Builder barChartVisual(Consumer<BarChartVisual.Builder> barChartVisual) {
            return this.barChartVisual((BarChartVisual)((BarChartVisual.Builder)BarChartVisual.builder().applyMutation(barChartVisual)).build());
        }

        public Builder kpiVisual(KPIVisual var1);

        default public Builder kpiVisual(Consumer<KPIVisual.Builder> kpiVisual) {
            return this.kpiVisual((KPIVisual)((KPIVisual.Builder)KPIVisual.builder().applyMutation(kpiVisual)).build());
        }

        public Builder pieChartVisual(PieChartVisual var1);

        default public Builder pieChartVisual(Consumer<PieChartVisual.Builder> pieChartVisual) {
            return this.pieChartVisual((PieChartVisual)((PieChartVisual.Builder)PieChartVisual.builder().applyMutation(pieChartVisual)).build());
        }

        public Builder gaugeChartVisual(GaugeChartVisual var1);

        default public Builder gaugeChartVisual(Consumer<GaugeChartVisual.Builder> gaugeChartVisual) {
            return this.gaugeChartVisual((GaugeChartVisual)((GaugeChartVisual.Builder)GaugeChartVisual.builder().applyMutation(gaugeChartVisual)).build());
        }

        public Builder lineChartVisual(LineChartVisual var1);

        default public Builder lineChartVisual(Consumer<LineChartVisual.Builder> lineChartVisual) {
            return this.lineChartVisual((LineChartVisual)((LineChartVisual.Builder)LineChartVisual.builder().applyMutation(lineChartVisual)).build());
        }

        public Builder heatMapVisual(HeatMapVisual var1);

        default public Builder heatMapVisual(Consumer<HeatMapVisual.Builder> heatMapVisual) {
            return this.heatMapVisual((HeatMapVisual)((HeatMapVisual.Builder)HeatMapVisual.builder().applyMutation(heatMapVisual)).build());
        }

        public Builder treeMapVisual(TreeMapVisual var1);

        default public Builder treeMapVisual(Consumer<TreeMapVisual.Builder> treeMapVisual) {
            return this.treeMapVisual((TreeMapVisual)((TreeMapVisual.Builder)TreeMapVisual.builder().applyMutation(treeMapVisual)).build());
        }

        public Builder geospatialMapVisual(GeospatialMapVisual var1);

        default public Builder geospatialMapVisual(Consumer<GeospatialMapVisual.Builder> geospatialMapVisual) {
            return this.geospatialMapVisual((GeospatialMapVisual)((GeospatialMapVisual.Builder)GeospatialMapVisual.builder().applyMutation(geospatialMapVisual)).build());
        }

        public Builder filledMapVisual(FilledMapVisual var1);

        default public Builder filledMapVisual(Consumer<FilledMapVisual.Builder> filledMapVisual) {
            return this.filledMapVisual((FilledMapVisual)((FilledMapVisual.Builder)FilledMapVisual.builder().applyMutation(filledMapVisual)).build());
        }

        public Builder layerMapVisual(LayerMapVisual var1);

        default public Builder layerMapVisual(Consumer<LayerMapVisual.Builder> layerMapVisual) {
            return this.layerMapVisual((LayerMapVisual)((LayerMapVisual.Builder)LayerMapVisual.builder().applyMutation(layerMapVisual)).build());
        }

        public Builder funnelChartVisual(FunnelChartVisual var1);

        default public Builder funnelChartVisual(Consumer<FunnelChartVisual.Builder> funnelChartVisual) {
            return this.funnelChartVisual((FunnelChartVisual)((FunnelChartVisual.Builder)FunnelChartVisual.builder().applyMutation(funnelChartVisual)).build());
        }

        public Builder scatterPlotVisual(ScatterPlotVisual var1);

        default public Builder scatterPlotVisual(Consumer<ScatterPlotVisual.Builder> scatterPlotVisual) {
            return this.scatterPlotVisual((ScatterPlotVisual)((ScatterPlotVisual.Builder)ScatterPlotVisual.builder().applyMutation(scatterPlotVisual)).build());
        }

        public Builder comboChartVisual(ComboChartVisual var1);

        default public Builder comboChartVisual(Consumer<ComboChartVisual.Builder> comboChartVisual) {
            return this.comboChartVisual((ComboChartVisual)((ComboChartVisual.Builder)ComboChartVisual.builder().applyMutation(comboChartVisual)).build());
        }

        public Builder boxPlotVisual(BoxPlotVisual var1);

        default public Builder boxPlotVisual(Consumer<BoxPlotVisual.Builder> boxPlotVisual) {
            return this.boxPlotVisual((BoxPlotVisual)((BoxPlotVisual.Builder)BoxPlotVisual.builder().applyMutation(boxPlotVisual)).build());
        }

        public Builder waterfallVisual(WaterfallVisual var1);

        default public Builder waterfallVisual(Consumer<WaterfallVisual.Builder> waterfallVisual) {
            return this.waterfallVisual((WaterfallVisual)((WaterfallVisual.Builder)WaterfallVisual.builder().applyMutation(waterfallVisual)).build());
        }

        public Builder histogramVisual(HistogramVisual var1);

        default public Builder histogramVisual(Consumer<HistogramVisual.Builder> histogramVisual) {
            return this.histogramVisual((HistogramVisual)((HistogramVisual.Builder)HistogramVisual.builder().applyMutation(histogramVisual)).build());
        }

        public Builder wordCloudVisual(WordCloudVisual var1);

        default public Builder wordCloudVisual(Consumer<WordCloudVisual.Builder> wordCloudVisual) {
            return this.wordCloudVisual((WordCloudVisual)((WordCloudVisual.Builder)WordCloudVisual.builder().applyMutation(wordCloudVisual)).build());
        }

        public Builder insightVisual(InsightVisual var1);

        default public Builder insightVisual(Consumer<InsightVisual.Builder> insightVisual) {
            return this.insightVisual((InsightVisual)((InsightVisual.Builder)InsightVisual.builder().applyMutation(insightVisual)).build());
        }

        public Builder sankeyDiagramVisual(SankeyDiagramVisual var1);

        default public Builder sankeyDiagramVisual(Consumer<SankeyDiagramVisual.Builder> sankeyDiagramVisual) {
            return this.sankeyDiagramVisual((SankeyDiagramVisual)((SankeyDiagramVisual.Builder)SankeyDiagramVisual.builder().applyMutation(sankeyDiagramVisual)).build());
        }

        public Builder customContentVisual(CustomContentVisual var1);

        default public Builder customContentVisual(Consumer<CustomContentVisual.Builder> customContentVisual) {
            return this.customContentVisual((CustomContentVisual)((CustomContentVisual.Builder)CustomContentVisual.builder().applyMutation(customContentVisual)).build());
        }

        public Builder emptyVisual(EmptyVisual var1);

        default public Builder emptyVisual(Consumer<EmptyVisual.Builder> emptyVisual) {
            return this.emptyVisual((EmptyVisual)((EmptyVisual.Builder)EmptyVisual.builder().applyMutation(emptyVisual)).build());
        }

        public Builder radarChartVisual(RadarChartVisual var1);

        default public Builder radarChartVisual(Consumer<RadarChartVisual.Builder> radarChartVisual) {
            return this.radarChartVisual((RadarChartVisual)((RadarChartVisual.Builder)RadarChartVisual.builder().applyMutation(radarChartVisual)).build());
        }

        public Builder pluginVisual(PluginVisual var1);

        default public Builder pluginVisual(Consumer<PluginVisual.Builder> pluginVisual) {
            return this.pluginVisual((PluginVisual)((PluginVisual.Builder)PluginVisual.builder().applyMutation(pluginVisual)).build());
        }
    }
}

