/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.services.quicksight.model.SnapshotConfiguration;
import software.amazon.awssdk.services.quicksight.model.SnapshotUserConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartDashboardSnapshotJobRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, StartDashboardSnapshotJobRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(StartDashboardSnapshotJobRequest.getter(StartDashboardSnapshotJobRequest::awsAccountId)).setter(StartDashboardSnapshotJobRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> DASHBOARD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DashboardId").getter(StartDashboardSnapshotJobRequest.getter(StartDashboardSnapshotJobRequest::dashboardId)).setter(StartDashboardSnapshotJobRequest.setter(Builder::dashboardId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DashboardId").build()}).build();
    private static final SdkField<String> SNAPSHOT_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotJobId").getter(StartDashboardSnapshotJobRequest.getter(StartDashboardSnapshotJobRequest::snapshotJobId)).setter(StartDashboardSnapshotJobRequest.setter(Builder::snapshotJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotJobId").build()}).build();
    private static final SdkField<SnapshotUserConfiguration> USER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UserConfiguration").getter(StartDashboardSnapshotJobRequest.getter(StartDashboardSnapshotJobRequest::userConfiguration)).setter(StartDashboardSnapshotJobRequest.setter(Builder::userConfiguration)).constructor(SnapshotUserConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserConfiguration").build()}).build();
    private static final SdkField<SnapshotConfiguration> SNAPSHOT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SnapshotConfiguration").getter(StartDashboardSnapshotJobRequest.getter(StartDashboardSnapshotJobRequest::snapshotConfiguration)).setter(StartDashboardSnapshotJobRequest.setter(Builder::snapshotConfiguration)).constructor(SnapshotConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, DASHBOARD_ID_FIELD, SNAPSHOT_JOB_ID_FIELD, USER_CONFIGURATION_FIELD, SNAPSHOT_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartDashboardSnapshotJobRequest.memberNameToFieldInitializer();
    private final String awsAccountId;
    private final String dashboardId;
    private final String snapshotJobId;
    private final SnapshotUserConfiguration userConfiguration;
    private final SnapshotConfiguration snapshotConfiguration;

    private StartDashboardSnapshotJobRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.dashboardId = builder.dashboardId;
        this.snapshotJobId = builder.snapshotJobId;
        this.userConfiguration = builder.userConfiguration;
        this.snapshotConfiguration = builder.snapshotConfiguration;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String dashboardId() {
        return this.dashboardId;
    }

    public final String snapshotJobId() {
        return this.snapshotJobId;
    }

    public final SnapshotUserConfiguration userConfiguration() {
        return this.userConfiguration;
    }

    public final SnapshotConfiguration snapshotConfiguration() {
        return this.snapshotConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardId());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDashboardSnapshotJobRequest)) {
            return false;
        }
        StartDashboardSnapshotJobRequest other = (StartDashboardSnapshotJobRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.dashboardId(), other.dashboardId()) && Objects.equals(this.snapshotJobId(), other.snapshotJobId()) && Objects.equals(this.userConfiguration(), other.userConfiguration()) && Objects.equals(this.snapshotConfiguration(), other.snapshotConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"StartDashboardSnapshotJobRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("DashboardId", (Object)this.dashboardId()).add("SnapshotJobId", (Object)this.snapshotJobId()).add("UserConfiguration", (Object)this.userConfiguration()).add("SnapshotConfiguration", (Object)this.snapshotConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "DashboardId": {
                return Optional.ofNullable(clazz.cast(this.dashboardId()));
            }
            case "SnapshotJobId": {
                return Optional.ofNullable(clazz.cast(this.snapshotJobId()));
            }
            case "UserConfiguration": {
                return Optional.ofNullable(clazz.cast(this.userConfiguration()));
            }
            case "SnapshotConfiguration": {
                return Optional.ofNullable(clazz.cast(this.snapshotConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("DashboardId", DASHBOARD_ID_FIELD);
        map.put("SnapshotJobId", SNAPSHOT_JOB_ID_FIELD);
        map.put("UserConfiguration", USER_CONFIGURATION_FIELD);
        map.put("SnapshotConfiguration", SNAPSHOT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartDashboardSnapshotJobRequest, T> g) {
        return obj -> g.apply((StartDashboardSnapshotJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String dashboardId;
        private String snapshotJobId;
        private SnapshotUserConfiguration userConfiguration;
        private SnapshotConfiguration snapshotConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDashboardSnapshotJobRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.dashboardId(model.dashboardId);
            this.snapshotJobId(model.snapshotJobId);
            this.userConfiguration(model.userConfiguration);
            this.snapshotConfiguration(model.snapshotConfiguration);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getDashboardId() {
            return this.dashboardId;
        }

        public final void setDashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
        }

        @Override
        public final Builder dashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
            return this;
        }

        public final String getSnapshotJobId() {
            return this.snapshotJobId;
        }

        public final void setSnapshotJobId(String snapshotJobId) {
            this.snapshotJobId = snapshotJobId;
        }

        @Override
        public final Builder snapshotJobId(String snapshotJobId) {
            this.snapshotJobId = snapshotJobId;
            return this;
        }

        public final SnapshotUserConfiguration.Builder getUserConfiguration() {
            return this.userConfiguration != null ? this.userConfiguration.toBuilder() : null;
        }

        public final void setUserConfiguration(SnapshotUserConfiguration.BuilderImpl userConfiguration) {
            this.userConfiguration = userConfiguration != null ? userConfiguration.build() : null;
        }

        @Override
        public final Builder userConfiguration(SnapshotUserConfiguration userConfiguration) {
            this.userConfiguration = userConfiguration;
            return this;
        }

        public final SnapshotConfiguration.Builder getSnapshotConfiguration() {
            return this.snapshotConfiguration != null ? this.snapshotConfiguration.toBuilder() : null;
        }

        public final void setSnapshotConfiguration(SnapshotConfiguration.BuilderImpl snapshotConfiguration) {
            this.snapshotConfiguration = snapshotConfiguration != null ? snapshotConfiguration.build() : null;
        }

        @Override
        public final Builder snapshotConfiguration(SnapshotConfiguration snapshotConfiguration) {
            this.snapshotConfiguration = snapshotConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDashboardSnapshotJobRequest build() {
            return new StartDashboardSnapshotJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartDashboardSnapshotJobRequest> {
        public Builder awsAccountId(String var1);

        public Builder dashboardId(String var1);

        public Builder snapshotJobId(String var1);

        public Builder userConfiguration(SnapshotUserConfiguration var1);

        default public Builder userConfiguration(Consumer<SnapshotUserConfiguration.Builder> userConfiguration) {
            return this.userConfiguration((SnapshotUserConfiguration)((SnapshotUserConfiguration.Builder)SnapshotUserConfiguration.builder().applyMutation(userConfiguration)).build());
        }

        public Builder snapshotConfiguration(SnapshotConfiguration var1);

        default public Builder snapshotConfiguration(Consumer<SnapshotConfiguration.Builder> snapshotConfiguration) {
            return this.snapshotConfiguration((SnapshotConfiguration)((SnapshotConfiguration.Builder)SnapshotConfiguration.builder().applyMutation(snapshotConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

