/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.BrandStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BrandSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BrandSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(BrandSummary.getter(BrandSummary::arn)).setter(BrandSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> BRAND_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BrandId").getter(BrandSummary.getter(BrandSummary::brandId)).setter(BrandSummary.setter(Builder::brandId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BrandId").build()}).build();
    private static final SdkField<String> BRAND_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BrandName").getter(BrandSummary.getter(BrandSummary::brandName)).setter(BrandSummary.setter(Builder::brandName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BrandName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(BrandSummary.getter(BrandSummary::description)).setter(BrandSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> BRAND_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BrandStatus").getter(BrandSummary.getter(BrandSummary::brandStatusAsString)).setter(BrandSummary.setter(Builder::brandStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BrandStatus").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(BrandSummary.getter(BrandSummary::createdTime)).setter(BrandSummary.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(BrandSummary.getter(BrandSummary::lastUpdatedTime)).setter(BrandSummary.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, BRAND_ID_FIELD, BRAND_NAME_FIELD, DESCRIPTION_FIELD, BRAND_STATUS_FIELD, CREATED_TIME_FIELD, LAST_UPDATED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BrandSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String brandId;
    private final String brandName;
    private final String description;
    private final String brandStatus;
    private final Instant createdTime;
    private final Instant lastUpdatedTime;

    private BrandSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.brandId = builder.brandId;
        this.brandName = builder.brandName;
        this.description = builder.description;
        this.brandStatus = builder.brandStatus;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    public final String arn() {
        return this.arn;
    }

    public final String brandId() {
        return this.brandId;
    }

    public final String brandName() {
        return this.brandName;
    }

    public final String description() {
        return this.description;
    }

    public final BrandStatus brandStatus() {
        return BrandStatus.fromValue(this.brandStatus);
    }

    public final String brandStatusAsString() {
        return this.brandStatus;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.brandId());
        hashCode = 31 * hashCode + Objects.hashCode(this.brandName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.brandStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrandSummary)) {
            return false;
        }
        BrandSummary other = (BrandSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.brandId(), other.brandId()) && Objects.equals(this.brandName(), other.brandName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.brandStatusAsString(), other.brandStatusAsString()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime());
    }

    public final String toString() {
        return ToString.builder((String)"BrandSummary").add("Arn", (Object)this.arn()).add("BrandId", (Object)this.brandId()).add("BrandName", (Object)this.brandName()).add("Description", (Object)this.description()).add("BrandStatus", (Object)this.brandStatusAsString()).add("CreatedTime", (Object)this.createdTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "BrandId": {
                return Optional.ofNullable(clazz.cast(this.brandId()));
            }
            case "BrandName": {
                return Optional.ofNullable(clazz.cast(this.brandName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "BrandStatus": {
                return Optional.ofNullable(clazz.cast(this.brandStatusAsString()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("BrandId", BRAND_ID_FIELD);
        map.put("BrandName", BRAND_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("BrandStatus", BRAND_STATUS_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BrandSummary, T> g) {
        return obj -> g.apply((BrandSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String brandId;
        private String brandName;
        private String description;
        private String brandStatus;
        private Instant createdTime;
        private Instant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(BrandSummary model) {
            this.arn(model.arn);
            this.brandId(model.brandId);
            this.brandName(model.brandName);
            this.description(model.description);
            this.brandStatus(model.brandStatus);
            this.createdTime(model.createdTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getBrandId() {
            return this.brandId;
        }

        public final void setBrandId(String brandId) {
            this.brandId = brandId;
        }

        @Override
        public final Builder brandId(String brandId) {
            this.brandId = brandId;
            return this;
        }

        public final String getBrandName() {
            return this.brandName;
        }

        public final void setBrandName(String brandName) {
            this.brandName = brandName;
        }

        @Override
        public final Builder brandName(String brandName) {
            this.brandName = brandName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getBrandStatus() {
            return this.brandStatus;
        }

        public final void setBrandStatus(String brandStatus) {
            this.brandStatus = brandStatus;
        }

        @Override
        public final Builder brandStatus(String brandStatus) {
            this.brandStatus = brandStatus;
            return this;
        }

        @Override
        public final Builder brandStatus(BrandStatus brandStatus) {
            this.brandStatus(brandStatus == null ? null : brandStatus.toString());
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public BrandSummary build() {
            return new BrandSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BrandSummary> {
        public Builder arn(String var1);

        public Builder brandId(String var1);

        public Builder brandName(String var1);

        public Builder description(String var1);

        public Builder brandStatus(String var1);

        public Builder brandStatus(BrandStatus var1);

        public Builder createdTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);
    }
}

