/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.AxisBinding;
import software.amazon.awssdk.services.quicksight.model.ReferenceLineDynamicDataConfiguration;
import software.amazon.awssdk.services.quicksight.model.ReferenceLineSeriesType;
import software.amazon.awssdk.services.quicksight.model.ReferenceLineStaticDataConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReferenceLineDataConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReferenceLineDataConfiguration> {
    private static final SdkField<ReferenceLineStaticDataConfiguration> STATIC_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StaticConfiguration").getter(ReferenceLineDataConfiguration.getter(ReferenceLineDataConfiguration::staticConfiguration)).setter(ReferenceLineDataConfiguration.setter(Builder::staticConfiguration)).constructor(ReferenceLineStaticDataConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaticConfiguration").build()}).build();
    private static final SdkField<ReferenceLineDynamicDataConfiguration> DYNAMIC_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DynamicConfiguration").getter(ReferenceLineDataConfiguration.getter(ReferenceLineDataConfiguration::dynamicConfiguration)).setter(ReferenceLineDataConfiguration.setter(Builder::dynamicConfiguration)).constructor(ReferenceLineDynamicDataConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamicConfiguration").build()}).build();
    private static final SdkField<String> AXIS_BINDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AxisBinding").getter(ReferenceLineDataConfiguration.getter(ReferenceLineDataConfiguration::axisBindingAsString)).setter(ReferenceLineDataConfiguration.setter(Builder::axisBinding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AxisBinding").build()}).build();
    private static final SdkField<String> SERIES_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SeriesType").getter(ReferenceLineDataConfiguration.getter(ReferenceLineDataConfiguration::seriesTypeAsString)).setter(ReferenceLineDataConfiguration.setter(Builder::seriesType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SeriesType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATIC_CONFIGURATION_FIELD, DYNAMIC_CONFIGURATION_FIELD, AXIS_BINDING_FIELD, SERIES_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReferenceLineDataConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ReferenceLineStaticDataConfiguration staticConfiguration;
    private final ReferenceLineDynamicDataConfiguration dynamicConfiguration;
    private final String axisBinding;
    private final String seriesType;

    private ReferenceLineDataConfiguration(BuilderImpl builder) {
        this.staticConfiguration = builder.staticConfiguration;
        this.dynamicConfiguration = builder.dynamicConfiguration;
        this.axisBinding = builder.axisBinding;
        this.seriesType = builder.seriesType;
    }

    public final ReferenceLineStaticDataConfiguration staticConfiguration() {
        return this.staticConfiguration;
    }

    public final ReferenceLineDynamicDataConfiguration dynamicConfiguration() {
        return this.dynamicConfiguration;
    }

    public final AxisBinding axisBinding() {
        return AxisBinding.fromValue(this.axisBinding);
    }

    public final String axisBindingAsString() {
        return this.axisBinding;
    }

    public final ReferenceLineSeriesType seriesType() {
        return ReferenceLineSeriesType.fromValue(this.seriesType);
    }

    public final String seriesTypeAsString() {
        return this.seriesType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.staticConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamicConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.axisBindingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.seriesTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceLineDataConfiguration)) {
            return false;
        }
        ReferenceLineDataConfiguration other = (ReferenceLineDataConfiguration)obj;
        return Objects.equals(this.staticConfiguration(), other.staticConfiguration()) && Objects.equals(this.dynamicConfiguration(), other.dynamicConfiguration()) && Objects.equals(this.axisBindingAsString(), other.axisBindingAsString()) && Objects.equals(this.seriesTypeAsString(), other.seriesTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ReferenceLineDataConfiguration").add("StaticConfiguration", (Object)this.staticConfiguration()).add("DynamicConfiguration", (Object)this.dynamicConfiguration()).add("AxisBinding", (Object)this.axisBindingAsString()).add("SeriesType", (Object)this.seriesTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StaticConfiguration": {
                return Optional.ofNullable(clazz.cast(this.staticConfiguration()));
            }
            case "DynamicConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dynamicConfiguration()));
            }
            case "AxisBinding": {
                return Optional.ofNullable(clazz.cast(this.axisBindingAsString()));
            }
            case "SeriesType": {
                return Optional.ofNullable(clazz.cast(this.seriesTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StaticConfiguration", STATIC_CONFIGURATION_FIELD);
        map.put("DynamicConfiguration", DYNAMIC_CONFIGURATION_FIELD);
        map.put("AxisBinding", AXIS_BINDING_FIELD);
        map.put("SeriesType", SERIES_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReferenceLineDataConfiguration, T> g) {
        return obj -> g.apply((ReferenceLineDataConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ReferenceLineStaticDataConfiguration staticConfiguration;
        private ReferenceLineDynamicDataConfiguration dynamicConfiguration;
        private String axisBinding;
        private String seriesType;

        private BuilderImpl() {
        }

        private BuilderImpl(ReferenceLineDataConfiguration model) {
            this.staticConfiguration(model.staticConfiguration);
            this.dynamicConfiguration(model.dynamicConfiguration);
            this.axisBinding(model.axisBinding);
            this.seriesType(model.seriesType);
        }

        public final ReferenceLineStaticDataConfiguration.Builder getStaticConfiguration() {
            return this.staticConfiguration != null ? this.staticConfiguration.toBuilder() : null;
        }

        public final void setStaticConfiguration(ReferenceLineStaticDataConfiguration.BuilderImpl staticConfiguration) {
            this.staticConfiguration = staticConfiguration != null ? staticConfiguration.build() : null;
        }

        @Override
        public final Builder staticConfiguration(ReferenceLineStaticDataConfiguration staticConfiguration) {
            this.staticConfiguration = staticConfiguration;
            return this;
        }

        public final ReferenceLineDynamicDataConfiguration.Builder getDynamicConfiguration() {
            return this.dynamicConfiguration != null ? this.dynamicConfiguration.toBuilder() : null;
        }

        public final void setDynamicConfiguration(ReferenceLineDynamicDataConfiguration.BuilderImpl dynamicConfiguration) {
            this.dynamicConfiguration = dynamicConfiguration != null ? dynamicConfiguration.build() : null;
        }

        @Override
        public final Builder dynamicConfiguration(ReferenceLineDynamicDataConfiguration dynamicConfiguration) {
            this.dynamicConfiguration = dynamicConfiguration;
            return this;
        }

        public final String getAxisBinding() {
            return this.axisBinding;
        }

        public final void setAxisBinding(String axisBinding) {
            this.axisBinding = axisBinding;
        }

        @Override
        public final Builder axisBinding(String axisBinding) {
            this.axisBinding = axisBinding;
            return this;
        }

        @Override
        public final Builder axisBinding(AxisBinding axisBinding) {
            this.axisBinding(axisBinding == null ? null : axisBinding.toString());
            return this;
        }

        public final String getSeriesType() {
            return this.seriesType;
        }

        public final void setSeriesType(String seriesType) {
            this.seriesType = seriesType;
        }

        @Override
        public final Builder seriesType(String seriesType) {
            this.seriesType = seriesType;
            return this;
        }

        @Override
        public final Builder seriesType(ReferenceLineSeriesType seriesType) {
            this.seriesType(seriesType == null ? null : seriesType.toString());
            return this;
        }

        public ReferenceLineDataConfiguration build() {
            return new ReferenceLineDataConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReferenceLineDataConfiguration> {
        public Builder staticConfiguration(ReferenceLineStaticDataConfiguration var1);

        default public Builder staticConfiguration(Consumer<ReferenceLineStaticDataConfiguration.Builder> staticConfiguration) {
            return this.staticConfiguration((ReferenceLineStaticDataConfiguration)((ReferenceLineStaticDataConfiguration.Builder)ReferenceLineStaticDataConfiguration.builder().applyMutation(staticConfiguration)).build());
        }

        public Builder dynamicConfiguration(ReferenceLineDynamicDataConfiguration var1);

        default public Builder dynamicConfiguration(Consumer<ReferenceLineDynamicDataConfiguration.Builder> dynamicConfiguration) {
            return this.dynamicConfiguration((ReferenceLineDynamicDataConfiguration)((ReferenceLineDynamicDataConfiguration.Builder)ReferenceLineDynamicDataConfiguration.builder().applyMutation(dynamicConfiguration)).build());
        }

        public Builder axisBinding(String var1);

        public Builder axisBinding(AxisBinding var1);

        public Builder seriesType(String var1);

        public Builder seriesType(ReferenceLineSeriesType var1);
    }
}

