/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.quicksight.model.TypeParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SemanticEntityType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SemanticEntityType> {
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeName").getter(SemanticEntityType.getter(SemanticEntityType::typeName)).setter(SemanticEntityType.setter(Builder::typeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()}).build();
    private static final SdkField<String> SUB_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubTypeName").getter(SemanticEntityType.getter(SemanticEntityType::subTypeName)).setter(SemanticEntityType.setter(Builder::subTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubTypeName").build()}).build();
    private static final SdkField<Map<String, String>> TYPE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("TypeParameters").getter(SemanticEntityType.getter(SemanticEntityType::typeParameters)).setter(SemanticEntityType.setter(Builder::typeParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_NAME_FIELD, SUB_TYPE_NAME_FIELD, TYPE_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SemanticEntityType.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String typeName;
    private final String subTypeName;
    private final Map<String, String> typeParameters;

    private SemanticEntityType(BuilderImpl builder) {
        this.typeName = builder.typeName;
        this.subTypeName = builder.subTypeName;
        this.typeParameters = builder.typeParameters;
    }

    public final String typeName() {
        return this.typeName;
    }

    public final String subTypeName() {
        return this.subTypeName;
    }

    public final boolean hasTypeParameters() {
        return this.typeParameters != null && !(this.typeParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> typeParameters() {
        return this.typeParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.subTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTypeParameters() ? this.typeParameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SemanticEntityType)) {
            return false;
        }
        SemanticEntityType other = (SemanticEntityType)obj;
        return Objects.equals(this.typeName(), other.typeName()) && Objects.equals(this.subTypeName(), other.subTypeName()) && this.hasTypeParameters() == other.hasTypeParameters() && Objects.equals(this.typeParameters(), other.typeParameters());
    }

    public final String toString() {
        return ToString.builder((String)"SemanticEntityType").add("TypeName", (Object)this.typeName()).add("SubTypeName", (Object)this.subTypeName()).add("TypeParameters", this.hasTypeParameters() ? this.typeParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TypeName": {
                return Optional.ofNullable(clazz.cast(this.typeName()));
            }
            case "SubTypeName": {
                return Optional.ofNullable(clazz.cast(this.subTypeName()));
            }
            case "TypeParameters": {
                return Optional.ofNullable(clazz.cast(this.typeParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TypeName", TYPE_NAME_FIELD);
        map.put("SubTypeName", SUB_TYPE_NAME_FIELD);
        map.put("TypeParameters", TYPE_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SemanticEntityType, T> g) {
        return obj -> g.apply((SemanticEntityType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String typeName;
        private String subTypeName;
        private Map<String, String> typeParameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SemanticEntityType model) {
            this.typeName(model.typeName);
            this.subTypeName(model.subTypeName);
            this.typeParameters(model.typeParameters);
        }

        public final String getTypeName() {
            return this.typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getSubTypeName() {
            return this.subTypeName;
        }

        public final void setSubTypeName(String subTypeName) {
            this.subTypeName = subTypeName;
        }

        @Override
        public final Builder subTypeName(String subTypeName) {
            this.subTypeName = subTypeName;
            return this;
        }

        public final Map<String, String> getTypeParameters() {
            if (this.typeParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.typeParameters;
        }

        public final void setTypeParameters(Map<String, String> typeParameters) {
            this.typeParameters = TypeParametersCopier.copy(typeParameters);
        }

        @Override
        public final Builder typeParameters(Map<String, String> typeParameters) {
            this.typeParameters = TypeParametersCopier.copy(typeParameters);
            return this;
        }

        public SemanticEntityType build() {
            return new SemanticEntityType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SemanticEntityType> {
        public Builder typeName(String var1);

        public Builder subTypeName(String var1);

        public Builder typeParameters(Map<String, String> var1);
    }
}

