/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.GeospatialDataSourceItem;
import software.amazon.awssdk.services.quicksight.model.GeospatialLayerDefinition;
import software.amazon.awssdk.services.quicksight.model.GeospatialLayerJoinDefinition;
import software.amazon.awssdk.services.quicksight.model.GeospatialLayerType;
import software.amazon.awssdk.services.quicksight.model.LayerCustomAction;
import software.amazon.awssdk.services.quicksight.model.LayerCustomActionListCopier;
import software.amazon.awssdk.services.quicksight.model.TooltipOptions;
import software.amazon.awssdk.services.quicksight.model.Visibility;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GeospatialLayerItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GeospatialLayerItem> {
    private static final SdkField<String> LAYER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LayerId").getter(GeospatialLayerItem.getter(GeospatialLayerItem::layerId)).setter(GeospatialLayerItem.setter(Builder::layerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LayerId").build()}).build();
    private static final SdkField<String> LAYER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LayerType").getter(GeospatialLayerItem.getter(GeospatialLayerItem::layerTypeAsString)).setter(GeospatialLayerItem.setter(Builder::layerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LayerType").build()}).build();
    private static final SdkField<GeospatialDataSourceItem> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSource").getter(GeospatialLayerItem.getter(GeospatialLayerItem::dataSource)).setter(GeospatialLayerItem.setter(Builder::dataSource)).constructor(GeospatialDataSourceItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()}).build();
    private static final SdkField<String> LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Label").getter(GeospatialLayerItem.getter(GeospatialLayerItem::label)).setter(GeospatialLayerItem.setter(Builder::label)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()}).build();
    private static final SdkField<String> VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Visibility").getter(GeospatialLayerItem.getter(GeospatialLayerItem::visibilityAsString)).setter(GeospatialLayerItem.setter(Builder::visibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()}).build();
    private static final SdkField<GeospatialLayerDefinition> LAYER_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LayerDefinition").getter(GeospatialLayerItem.getter(GeospatialLayerItem::layerDefinition)).setter(GeospatialLayerItem.setter(Builder::layerDefinition)).constructor(GeospatialLayerDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LayerDefinition").build()}).build();
    private static final SdkField<TooltipOptions> TOOLTIP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Tooltip").getter(GeospatialLayerItem.getter(GeospatialLayerItem::tooltip)).setter(GeospatialLayerItem.setter(Builder::tooltip)).constructor(TooltipOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tooltip").build()}).build();
    private static final SdkField<GeospatialLayerJoinDefinition> JOIN_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JoinDefinition").getter(GeospatialLayerItem.getter(GeospatialLayerItem::joinDefinition)).setter(GeospatialLayerItem.setter(Builder::joinDefinition)).constructor(GeospatialLayerJoinDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JoinDefinition").build()}).build();
    private static final SdkField<List<LayerCustomAction>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Actions").getter(GeospatialLayerItem.getter(GeospatialLayerItem::actions)).setter(GeospatialLayerItem.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LayerCustomAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAYER_ID_FIELD, LAYER_TYPE_FIELD, DATA_SOURCE_FIELD, LABEL_FIELD, VISIBILITY_FIELD, LAYER_DEFINITION_FIELD, TOOLTIP_FIELD, JOIN_DEFINITION_FIELD, ACTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GeospatialLayerItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String layerId;
    private final String layerType;
    private final GeospatialDataSourceItem dataSource;
    private final String label;
    private final String visibility;
    private final GeospatialLayerDefinition layerDefinition;
    private final TooltipOptions tooltip;
    private final GeospatialLayerJoinDefinition joinDefinition;
    private final List<LayerCustomAction> actions;

    private GeospatialLayerItem(BuilderImpl builder) {
        this.layerId = builder.layerId;
        this.layerType = builder.layerType;
        this.dataSource = builder.dataSource;
        this.label = builder.label;
        this.visibility = builder.visibility;
        this.layerDefinition = builder.layerDefinition;
        this.tooltip = builder.tooltip;
        this.joinDefinition = builder.joinDefinition;
        this.actions = builder.actions;
    }

    public final String layerId() {
        return this.layerId;
    }

    public final GeospatialLayerType layerType() {
        return GeospatialLayerType.fromValue(this.layerType);
    }

    public final String layerTypeAsString() {
        return this.layerType;
    }

    public final GeospatialDataSourceItem dataSource() {
        return this.dataSource;
    }

    public final String label() {
        return this.label;
    }

    public final Visibility visibility() {
        return Visibility.fromValue(this.visibility);
    }

    public final String visibilityAsString() {
        return this.visibility;
    }

    public final GeospatialLayerDefinition layerDefinition() {
        return this.layerDefinition;
    }

    public final TooltipOptions tooltip() {
        return this.tooltip;
    }

    public final GeospatialLayerJoinDefinition joinDefinition() {
        return this.joinDefinition;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<LayerCustomAction> actions() {
        return this.actions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.layerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.layerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.label());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.layerDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.tooltip());
        hashCode = 31 * hashCode + Objects.hashCode(this.joinDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeospatialLayerItem)) {
            return false;
        }
        GeospatialLayerItem other = (GeospatialLayerItem)obj;
        return Objects.equals(this.layerId(), other.layerId()) && Objects.equals(this.layerTypeAsString(), other.layerTypeAsString()) && Objects.equals(this.dataSource(), other.dataSource()) && Objects.equals(this.label(), other.label()) && Objects.equals(this.visibilityAsString(), other.visibilityAsString()) && Objects.equals(this.layerDefinition(), other.layerDefinition()) && Objects.equals(this.tooltip(), other.tooltip()) && Objects.equals(this.joinDefinition(), other.joinDefinition()) && this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions());
    }

    public final String toString() {
        return ToString.builder((String)"GeospatialLayerItem").add("LayerId", (Object)this.layerId()).add("LayerType", (Object)this.layerTypeAsString()).add("DataSource", (Object)this.dataSource()).add("Label", (Object)this.label()).add("Visibility", (Object)this.visibilityAsString()).add("LayerDefinition", (Object)this.layerDefinition()).add("Tooltip", (Object)this.tooltip()).add("JoinDefinition", (Object)this.joinDefinition()).add("Actions", this.hasActions() ? this.actions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LayerId": {
                return Optional.ofNullable(clazz.cast(this.layerId()));
            }
            case "LayerType": {
                return Optional.ofNullable(clazz.cast(this.layerTypeAsString()));
            }
            case "DataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSource()));
            }
            case "Label": {
                return Optional.ofNullable(clazz.cast(this.label()));
            }
            case "Visibility": {
                return Optional.ofNullable(clazz.cast(this.visibilityAsString()));
            }
            case "LayerDefinition": {
                return Optional.ofNullable(clazz.cast(this.layerDefinition()));
            }
            case "Tooltip": {
                return Optional.ofNullable(clazz.cast(this.tooltip()));
            }
            case "JoinDefinition": {
                return Optional.ofNullable(clazz.cast(this.joinDefinition()));
            }
            case "Actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LayerId", LAYER_ID_FIELD);
        map.put("LayerType", LAYER_TYPE_FIELD);
        map.put("DataSource", DATA_SOURCE_FIELD);
        map.put("Label", LABEL_FIELD);
        map.put("Visibility", VISIBILITY_FIELD);
        map.put("LayerDefinition", LAYER_DEFINITION_FIELD);
        map.put("Tooltip", TOOLTIP_FIELD);
        map.put("JoinDefinition", JOIN_DEFINITION_FIELD);
        map.put("Actions", ACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeospatialLayerItem, T> g) {
        return obj -> g.apply((GeospatialLayerItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String layerId;
        private String layerType;
        private GeospatialDataSourceItem dataSource;
        private String label;
        private String visibility;
        private GeospatialLayerDefinition layerDefinition;
        private TooltipOptions tooltip;
        private GeospatialLayerJoinDefinition joinDefinition;
        private List<LayerCustomAction> actions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GeospatialLayerItem model) {
            this.layerId(model.layerId);
            this.layerType(model.layerType);
            this.dataSource(model.dataSource);
            this.label(model.label);
            this.visibility(model.visibility);
            this.layerDefinition(model.layerDefinition);
            this.tooltip(model.tooltip);
            this.joinDefinition(model.joinDefinition);
            this.actions(model.actions);
        }

        public final String getLayerId() {
            return this.layerId;
        }

        public final void setLayerId(String layerId) {
            this.layerId = layerId;
        }

        @Override
        public final Builder layerId(String layerId) {
            this.layerId = layerId;
            return this;
        }

        public final String getLayerType() {
            return this.layerType;
        }

        public final void setLayerType(String layerType) {
            this.layerType = layerType;
        }

        @Override
        public final Builder layerType(String layerType) {
            this.layerType = layerType;
            return this;
        }

        @Override
        public final Builder layerType(GeospatialLayerType layerType) {
            this.layerType(layerType == null ? null : layerType.toString());
            return this;
        }

        public final GeospatialDataSourceItem.Builder getDataSource() {
            return this.dataSource != null ? this.dataSource.toBuilder() : null;
        }

        public final void setDataSource(GeospatialDataSourceItem.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(GeospatialDataSourceItem dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final String getLabel() {
            return this.label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final String getVisibility() {
            return this.visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final GeospatialLayerDefinition.Builder getLayerDefinition() {
            return this.layerDefinition != null ? this.layerDefinition.toBuilder() : null;
        }

        public final void setLayerDefinition(GeospatialLayerDefinition.BuilderImpl layerDefinition) {
            this.layerDefinition = layerDefinition != null ? layerDefinition.build() : null;
        }

        @Override
        public final Builder layerDefinition(GeospatialLayerDefinition layerDefinition) {
            this.layerDefinition = layerDefinition;
            return this;
        }

        public final TooltipOptions.Builder getTooltip() {
            return this.tooltip != null ? this.tooltip.toBuilder() : null;
        }

        public final void setTooltip(TooltipOptions.BuilderImpl tooltip) {
            this.tooltip = tooltip != null ? tooltip.build() : null;
        }

        @Override
        public final Builder tooltip(TooltipOptions tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public final GeospatialLayerJoinDefinition.Builder getJoinDefinition() {
            return this.joinDefinition != null ? this.joinDefinition.toBuilder() : null;
        }

        public final void setJoinDefinition(GeospatialLayerJoinDefinition.BuilderImpl joinDefinition) {
            this.joinDefinition = joinDefinition != null ? joinDefinition.build() : null;
        }

        @Override
        public final Builder joinDefinition(GeospatialLayerJoinDefinition joinDefinition) {
            this.joinDefinition = joinDefinition;
            return this;
        }

        public final List<LayerCustomAction.Builder> getActions() {
            List<LayerCustomAction.Builder> result = LayerCustomActionListCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<LayerCustomAction.BuilderImpl> actions) {
            this.actions = LayerCustomActionListCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<LayerCustomAction> actions) {
            this.actions = LayerCustomActionListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(LayerCustomAction ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<LayerCustomAction.Builder> ... actions) {
            this.actions(Stream.of(actions).map(c -> (LayerCustomAction)((LayerCustomAction.Builder)LayerCustomAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public GeospatialLayerItem build() {
            return new GeospatialLayerItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GeospatialLayerItem> {
        public Builder layerId(String var1);

        public Builder layerType(String var1);

        public Builder layerType(GeospatialLayerType var1);

        public Builder dataSource(GeospatialDataSourceItem var1);

        default public Builder dataSource(Consumer<GeospatialDataSourceItem.Builder> dataSource) {
            return this.dataSource((GeospatialDataSourceItem)((GeospatialDataSourceItem.Builder)GeospatialDataSourceItem.builder().applyMutation(dataSource)).build());
        }

        public Builder label(String var1);

        public Builder visibility(String var1);

        public Builder visibility(Visibility var1);

        public Builder layerDefinition(GeospatialLayerDefinition var1);

        default public Builder layerDefinition(Consumer<GeospatialLayerDefinition.Builder> layerDefinition) {
            return this.layerDefinition((GeospatialLayerDefinition)((GeospatialLayerDefinition.Builder)GeospatialLayerDefinition.builder().applyMutation(layerDefinition)).build());
        }

        public Builder tooltip(TooltipOptions var1);

        default public Builder tooltip(Consumer<TooltipOptions.Builder> tooltip) {
            return this.tooltip((TooltipOptions)((TooltipOptions.Builder)TooltipOptions.builder().applyMutation(tooltip)).build());
        }

        public Builder joinDefinition(GeospatialLayerJoinDefinition var1);

        default public Builder joinDefinition(Consumer<GeospatialLayerJoinDefinition.Builder> joinDefinition) {
            return this.joinDefinition((GeospatialLayerJoinDefinition)((GeospatialLayerJoinDefinition.Builder)GeospatialLayerJoinDefinition.builder().applyMutation(joinDefinition)).build());
        }

        public Builder actions(Collection<LayerCustomAction> var1);

        public Builder actions(LayerCustomAction ... var1);

        public Builder actions(Consumer<LayerCustomAction.Builder> ... var1);
    }
}

