/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.AssetBundleResourceLinkSharingConfiguration;
import software.amazon.awssdk.services.quicksight.model.AssetBundleResourcePermissions;
import software.amazon.awssdk.services.quicksight.model.AssetBundleRestrictiveResourceIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetBundleImportJobDashboardOverridePermissions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetBundleImportJobDashboardOverridePermissions> {
    private static final SdkField<List<String>> DASHBOARD_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DashboardIds").getter(AssetBundleImportJobDashboardOverridePermissions.getter(AssetBundleImportJobDashboardOverridePermissions::dashboardIds)).setter(AssetBundleImportJobDashboardOverridePermissions.setter(Builder::dashboardIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AssetBundleResourcePermissions> PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Permissions").getter(AssetBundleImportJobDashboardOverridePermissions.getter(AssetBundleImportJobDashboardOverridePermissions::permissions)).setter(AssetBundleImportJobDashboardOverridePermissions.setter(Builder::permissions)).constructor(AssetBundleResourcePermissions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build()}).build();
    private static final SdkField<AssetBundleResourceLinkSharingConfiguration> LINK_SHARING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LinkSharingConfiguration").getter(AssetBundleImportJobDashboardOverridePermissions.getter(AssetBundleImportJobDashboardOverridePermissions::linkSharingConfiguration)).setter(AssetBundleImportJobDashboardOverridePermissions.setter(Builder::linkSharingConfiguration)).constructor(AssetBundleResourceLinkSharingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkSharingConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_IDS_FIELD, PERMISSIONS_FIELD, LINK_SHARING_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssetBundleImportJobDashboardOverridePermissions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> dashboardIds;
    private final AssetBundleResourcePermissions permissions;
    private final AssetBundleResourceLinkSharingConfiguration linkSharingConfiguration;

    private AssetBundleImportJobDashboardOverridePermissions(BuilderImpl builder) {
        this.dashboardIds = builder.dashboardIds;
        this.permissions = builder.permissions;
        this.linkSharingConfiguration = builder.linkSharingConfiguration;
    }

    public final boolean hasDashboardIds() {
        return this.dashboardIds != null && !(this.dashboardIds instanceof SdkAutoConstructList);
    }

    public final List<String> dashboardIds() {
        return this.dashboardIds;
    }

    public final AssetBundleResourcePermissions permissions() {
        return this.permissions;
    }

    public final AssetBundleResourceLinkSharingConfiguration linkSharingConfiguration() {
        return this.linkSharingConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDashboardIds() ? this.dashboardIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.permissions());
        hashCode = 31 * hashCode + Objects.hashCode(this.linkSharingConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetBundleImportJobDashboardOverridePermissions)) {
            return false;
        }
        AssetBundleImportJobDashboardOverridePermissions other = (AssetBundleImportJobDashboardOverridePermissions)obj;
        return this.hasDashboardIds() == other.hasDashboardIds() && Objects.equals(this.dashboardIds(), other.dashboardIds()) && Objects.equals(this.permissions(), other.permissions()) && Objects.equals(this.linkSharingConfiguration(), other.linkSharingConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"AssetBundleImportJobDashboardOverridePermissions").add("DashboardIds", this.hasDashboardIds() ? this.dashboardIds() : null).add("Permissions", (Object)this.permissions()).add("LinkSharingConfiguration", (Object)this.linkSharingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DashboardIds": {
                return Optional.ofNullable(clazz.cast(this.dashboardIds()));
            }
            case "Permissions": {
                return Optional.ofNullable(clazz.cast(this.permissions()));
            }
            case "LinkSharingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.linkSharingConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DashboardIds", DASHBOARD_IDS_FIELD);
        map.put("Permissions", PERMISSIONS_FIELD);
        map.put("LinkSharingConfiguration", LINK_SHARING_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssetBundleImportJobDashboardOverridePermissions, T> g) {
        return obj -> g.apply((AssetBundleImportJobDashboardOverridePermissions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> dashboardIds = DefaultSdkAutoConstructList.getInstance();
        private AssetBundleResourcePermissions permissions;
        private AssetBundleResourceLinkSharingConfiguration linkSharingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetBundleImportJobDashboardOverridePermissions model) {
            this.dashboardIds(model.dashboardIds);
            this.permissions(model.permissions);
            this.linkSharingConfiguration(model.linkSharingConfiguration);
        }

        public final Collection<String> getDashboardIds() {
            if (this.dashboardIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dashboardIds;
        }

        public final void setDashboardIds(Collection<String> dashboardIds) {
            this.dashboardIds = AssetBundleRestrictiveResourceIdListCopier.copy(dashboardIds);
        }

        @Override
        public final Builder dashboardIds(Collection<String> dashboardIds) {
            this.dashboardIds = AssetBundleRestrictiveResourceIdListCopier.copy(dashboardIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashboardIds(String ... dashboardIds) {
            this.dashboardIds(Arrays.asList(dashboardIds));
            return this;
        }

        public final AssetBundleResourcePermissions.Builder getPermissions() {
            return this.permissions != null ? this.permissions.toBuilder() : null;
        }

        public final void setPermissions(AssetBundleResourcePermissions.BuilderImpl permissions) {
            this.permissions = permissions != null ? permissions.build() : null;
        }

        @Override
        public final Builder permissions(AssetBundleResourcePermissions permissions) {
            this.permissions = permissions;
            return this;
        }

        public final AssetBundleResourceLinkSharingConfiguration.Builder getLinkSharingConfiguration() {
            return this.linkSharingConfiguration != null ? this.linkSharingConfiguration.toBuilder() : null;
        }

        public final void setLinkSharingConfiguration(AssetBundleResourceLinkSharingConfiguration.BuilderImpl linkSharingConfiguration) {
            this.linkSharingConfiguration = linkSharingConfiguration != null ? linkSharingConfiguration.build() : null;
        }

        @Override
        public final Builder linkSharingConfiguration(AssetBundleResourceLinkSharingConfiguration linkSharingConfiguration) {
            this.linkSharingConfiguration = linkSharingConfiguration;
            return this;
        }

        public AssetBundleImportJobDashboardOverridePermissions build() {
            return new AssetBundleImportJobDashboardOverridePermissions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetBundleImportJobDashboardOverridePermissions> {
        public Builder dashboardIds(Collection<String> var1);

        public Builder dashboardIds(String ... var1);

        public Builder permissions(AssetBundleResourcePermissions var1);

        default public Builder permissions(Consumer<AssetBundleResourcePermissions.Builder> permissions) {
            return this.permissions((AssetBundleResourcePermissions)((AssetBundleResourcePermissions.Builder)AssetBundleResourcePermissions.builder().applyMutation(permissions)).build());
        }

        public Builder linkSharingConfiguration(AssetBundleResourceLinkSharingConfiguration var1);

        default public Builder linkSharingConfiguration(Consumer<AssetBundleResourceLinkSharingConfiguration.Builder> linkSharingConfiguration) {
            return this.linkSharingConfiguration((AssetBundleResourceLinkSharingConfiguration)((AssetBundleResourceLinkSharingConfiguration.Builder)AssetBundleResourceLinkSharingConfiguration.builder().applyMutation(linkSharingConfiguration)).build());
        }
    }
}

