/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.MissingDataTreatmentOption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MissingDataConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MissingDataConfiguration> {
    private static final SdkField<String> TREATMENT_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TreatmentOption").getter(MissingDataConfiguration.getter(MissingDataConfiguration::treatmentOptionAsString)).setter(MissingDataConfiguration.setter(Builder::treatmentOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TreatmentOption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TREATMENT_OPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MissingDataConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String treatmentOption;

    private MissingDataConfiguration(BuilderImpl builder) {
        this.treatmentOption = builder.treatmentOption;
    }

    public final MissingDataTreatmentOption treatmentOption() {
        return MissingDataTreatmentOption.fromValue(this.treatmentOption);
    }

    public final String treatmentOptionAsString() {
        return this.treatmentOption;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.treatmentOptionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MissingDataConfiguration)) {
            return false;
        }
        MissingDataConfiguration other = (MissingDataConfiguration)obj;
        return Objects.equals(this.treatmentOptionAsString(), other.treatmentOptionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"MissingDataConfiguration").add("TreatmentOption", (Object)this.treatmentOptionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TreatmentOption": {
                return Optional.ofNullable(clazz.cast(this.treatmentOptionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("TreatmentOption", TREATMENT_OPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MissingDataConfiguration, T> g) {
        return obj -> g.apply((MissingDataConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String treatmentOption;

        private BuilderImpl() {
        }

        private BuilderImpl(MissingDataConfiguration model) {
            this.treatmentOption(model.treatmentOption);
        }

        public final String getTreatmentOption() {
            return this.treatmentOption;
        }

        public final void setTreatmentOption(String treatmentOption) {
            this.treatmentOption = treatmentOption;
        }

        @Override
        public final Builder treatmentOption(String treatmentOption) {
            this.treatmentOption = treatmentOption;
            return this;
        }

        @Override
        public final Builder treatmentOption(MissingDataTreatmentOption treatmentOption) {
            this.treatmentOption(treatmentOption == null ? null : treatmentOption.toString());
            return this;
        }

        public MissingDataConfiguration build() {
            return new MissingDataConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MissingDataConfiguration> {
        public Builder treatmentOption(String var1);

        public Builder treatmentOption(MissingDataTreatmentOption var1);
    }
}

