/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.DataQnAConfigurations;
import software.amazon.awssdk.services.quicksight.model.DataStoriesConfigurations;
import software.amazon.awssdk.services.quicksight.model.ExecutiveSummaryConfigurations;
import software.amazon.awssdk.services.quicksight.model.GenerativeAuthoringConfigurations;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AmazonQInQuickSightConsoleConfigurations
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AmazonQInQuickSightConsoleConfigurations> {
    private static final SdkField<DataQnAConfigurations> DATA_QNA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataQnA").getter(AmazonQInQuickSightConsoleConfigurations.getter(AmazonQInQuickSightConsoleConfigurations::dataQnA)).setter(AmazonQInQuickSightConsoleConfigurations.setter(Builder::dataQnA)).constructor(DataQnAConfigurations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataQnA").build()}).build();
    private static final SdkField<GenerativeAuthoringConfigurations> GENERATIVE_AUTHORING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GenerativeAuthoring").getter(AmazonQInQuickSightConsoleConfigurations.getter(AmazonQInQuickSightConsoleConfigurations::generativeAuthoring)).setter(AmazonQInQuickSightConsoleConfigurations.setter(Builder::generativeAuthoring)).constructor(GenerativeAuthoringConfigurations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerativeAuthoring").build()}).build();
    private static final SdkField<ExecutiveSummaryConfigurations> EXECUTIVE_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExecutiveSummary").getter(AmazonQInQuickSightConsoleConfigurations.getter(AmazonQInQuickSightConsoleConfigurations::executiveSummary)).setter(AmazonQInQuickSightConsoleConfigurations.setter(Builder::executiveSummary)).constructor(ExecutiveSummaryConfigurations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutiveSummary").build()}).build();
    private static final SdkField<DataStoriesConfigurations> DATA_STORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataStories").getter(AmazonQInQuickSightConsoleConfigurations.getter(AmazonQInQuickSightConsoleConfigurations::dataStories)).setter(AmazonQInQuickSightConsoleConfigurations.setter(Builder::dataStories)).constructor(DataStoriesConfigurations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataStories").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_QNA_FIELD, GENERATIVE_AUTHORING_FIELD, EXECUTIVE_SUMMARY_FIELD, DATA_STORIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AmazonQInQuickSightConsoleConfigurations.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DataQnAConfigurations dataQnA;
    private final GenerativeAuthoringConfigurations generativeAuthoring;
    private final ExecutiveSummaryConfigurations executiveSummary;
    private final DataStoriesConfigurations dataStories;

    private AmazonQInQuickSightConsoleConfigurations(BuilderImpl builder) {
        this.dataQnA = builder.dataQnA;
        this.generativeAuthoring = builder.generativeAuthoring;
        this.executiveSummary = builder.executiveSummary;
        this.dataStories = builder.dataStories;
    }

    public final DataQnAConfigurations dataQnA() {
        return this.dataQnA;
    }

    public final GenerativeAuthoringConfigurations generativeAuthoring() {
        return this.generativeAuthoring;
    }

    public final ExecutiveSummaryConfigurations executiveSummary() {
        return this.executiveSummary;
    }

    public final DataStoriesConfigurations dataStories() {
        return this.dataStories;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataQnA());
        hashCode = 31 * hashCode + Objects.hashCode(this.generativeAuthoring());
        hashCode = 31 * hashCode + Objects.hashCode(this.executiveSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataStories());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmazonQInQuickSightConsoleConfigurations)) {
            return false;
        }
        AmazonQInQuickSightConsoleConfigurations other = (AmazonQInQuickSightConsoleConfigurations)obj;
        return Objects.equals(this.dataQnA(), other.dataQnA()) && Objects.equals(this.generativeAuthoring(), other.generativeAuthoring()) && Objects.equals(this.executiveSummary(), other.executiveSummary()) && Objects.equals(this.dataStories(), other.dataStories());
    }

    public final String toString() {
        return ToString.builder((String)"AmazonQInQuickSightConsoleConfigurations").add("DataQnA", (Object)this.dataQnA()).add("GenerativeAuthoring", (Object)this.generativeAuthoring()).add("ExecutiveSummary", (Object)this.executiveSummary()).add("DataStories", (Object)this.dataStories()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataQnA": {
                return Optional.ofNullable(clazz.cast(this.dataQnA()));
            }
            case "GenerativeAuthoring": {
                return Optional.ofNullable(clazz.cast(this.generativeAuthoring()));
            }
            case "ExecutiveSummary": {
                return Optional.ofNullable(clazz.cast(this.executiveSummary()));
            }
            case "DataStories": {
                return Optional.ofNullable(clazz.cast(this.dataStories()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DataQnA", DATA_QNA_FIELD);
        map.put("GenerativeAuthoring", GENERATIVE_AUTHORING_FIELD);
        map.put("ExecutiveSummary", EXECUTIVE_SUMMARY_FIELD);
        map.put("DataStories", DATA_STORIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AmazonQInQuickSightConsoleConfigurations, T> g) {
        return obj -> g.apply((AmazonQInQuickSightConsoleConfigurations)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DataQnAConfigurations dataQnA;
        private GenerativeAuthoringConfigurations generativeAuthoring;
        private ExecutiveSummaryConfigurations executiveSummary;
        private DataStoriesConfigurations dataStories;

        private BuilderImpl() {
        }

        private BuilderImpl(AmazonQInQuickSightConsoleConfigurations model) {
            this.dataQnA(model.dataQnA);
            this.generativeAuthoring(model.generativeAuthoring);
            this.executiveSummary(model.executiveSummary);
            this.dataStories(model.dataStories);
        }

        public final DataQnAConfigurations.Builder getDataQnA() {
            return this.dataQnA != null ? this.dataQnA.toBuilder() : null;
        }

        public final void setDataQnA(DataQnAConfigurations.BuilderImpl dataQnA) {
            this.dataQnA = dataQnA != null ? dataQnA.build() : null;
        }

        @Override
        public final Builder dataQnA(DataQnAConfigurations dataQnA) {
            this.dataQnA = dataQnA;
            return this;
        }

        public final GenerativeAuthoringConfigurations.Builder getGenerativeAuthoring() {
            return this.generativeAuthoring != null ? this.generativeAuthoring.toBuilder() : null;
        }

        public final void setGenerativeAuthoring(GenerativeAuthoringConfigurations.BuilderImpl generativeAuthoring) {
            this.generativeAuthoring = generativeAuthoring != null ? generativeAuthoring.build() : null;
        }

        @Override
        public final Builder generativeAuthoring(GenerativeAuthoringConfigurations generativeAuthoring) {
            this.generativeAuthoring = generativeAuthoring;
            return this;
        }

        public final ExecutiveSummaryConfigurations.Builder getExecutiveSummary() {
            return this.executiveSummary != null ? this.executiveSummary.toBuilder() : null;
        }

        public final void setExecutiveSummary(ExecutiveSummaryConfigurations.BuilderImpl executiveSummary) {
            this.executiveSummary = executiveSummary != null ? executiveSummary.build() : null;
        }

        @Override
        public final Builder executiveSummary(ExecutiveSummaryConfigurations executiveSummary) {
            this.executiveSummary = executiveSummary;
            return this;
        }

        public final DataStoriesConfigurations.Builder getDataStories() {
            return this.dataStories != null ? this.dataStories.toBuilder() : null;
        }

        public final void setDataStories(DataStoriesConfigurations.BuilderImpl dataStories) {
            this.dataStories = dataStories != null ? dataStories.build() : null;
        }

        @Override
        public final Builder dataStories(DataStoriesConfigurations dataStories) {
            this.dataStories = dataStories;
            return this;
        }

        public AmazonQInQuickSightConsoleConfigurations build() {
            return new AmazonQInQuickSightConsoleConfigurations(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AmazonQInQuickSightConsoleConfigurations> {
        public Builder dataQnA(DataQnAConfigurations var1);

        default public Builder dataQnA(Consumer<DataQnAConfigurations.Builder> dataQnA) {
            return this.dataQnA((DataQnAConfigurations)((DataQnAConfigurations.Builder)DataQnAConfigurations.builder().applyMutation(dataQnA)).build());
        }

        public Builder generativeAuthoring(GenerativeAuthoringConfigurations var1);

        default public Builder generativeAuthoring(Consumer<GenerativeAuthoringConfigurations.Builder> generativeAuthoring) {
            return this.generativeAuthoring((GenerativeAuthoringConfigurations)((GenerativeAuthoringConfigurations.Builder)GenerativeAuthoringConfigurations.builder().applyMutation(generativeAuthoring)).build());
        }

        public Builder executiveSummary(ExecutiveSummaryConfigurations var1);

        default public Builder executiveSummary(Consumer<ExecutiveSummaryConfigurations.Builder> executiveSummary) {
            return this.executiveSummary((ExecutiveSummaryConfigurations)((ExecutiveSummaryConfigurations.Builder)ExecutiveSummaryConfigurations.builder().applyMutation(executiveSummary)).build());
        }

        public Builder dataStories(DataStoriesConfigurations var1);

        default public Builder dataStories(Consumer<DataStoriesConfigurations.Builder> dataStories) {
            return this.dataStories((DataStoriesConfigurations)((DataStoriesConfigurations.Builder)DataStoriesConfigurations.builder().applyMutation(dataStories)).build());
        }
    }
}

