/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.PaperOrientation;
import software.amazon.awssdk.services.quicksight.model.PaperSize;
import software.amazon.awssdk.services.quicksight.model.Spacing;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SectionBasedLayoutPaperCanvasSizeOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SectionBasedLayoutPaperCanvasSizeOptions> {
    private static final SdkField<String> PAPER_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PaperSize").getter(SectionBasedLayoutPaperCanvasSizeOptions.getter(SectionBasedLayoutPaperCanvasSizeOptions::paperSizeAsString)).setter(SectionBasedLayoutPaperCanvasSizeOptions.setter(Builder::paperSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaperSize").build()}).build();
    private static final SdkField<String> PAPER_ORIENTATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PaperOrientation").getter(SectionBasedLayoutPaperCanvasSizeOptions.getter(SectionBasedLayoutPaperCanvasSizeOptions::paperOrientationAsString)).setter(SectionBasedLayoutPaperCanvasSizeOptions.setter(Builder::paperOrientation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaperOrientation").build()}).build();
    private static final SdkField<Spacing> PAPER_MARGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PaperMargin").getter(SectionBasedLayoutPaperCanvasSizeOptions.getter(SectionBasedLayoutPaperCanvasSizeOptions::paperMargin)).setter(SectionBasedLayoutPaperCanvasSizeOptions.setter(Builder::paperMargin)).constructor(Spacing::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaperMargin").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAPER_SIZE_FIELD, PAPER_ORIENTATION_FIELD, PAPER_MARGIN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SectionBasedLayoutPaperCanvasSizeOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String paperSize;
    private final String paperOrientation;
    private final Spacing paperMargin;

    private SectionBasedLayoutPaperCanvasSizeOptions(BuilderImpl builder) {
        this.paperSize = builder.paperSize;
        this.paperOrientation = builder.paperOrientation;
        this.paperMargin = builder.paperMargin;
    }

    public final PaperSize paperSize() {
        return PaperSize.fromValue(this.paperSize);
    }

    public final String paperSizeAsString() {
        return this.paperSize;
    }

    public final PaperOrientation paperOrientation() {
        return PaperOrientation.fromValue(this.paperOrientation);
    }

    public final String paperOrientationAsString() {
        return this.paperOrientation;
    }

    public final Spacing paperMargin() {
        return this.paperMargin;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.paperSizeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.paperOrientationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.paperMargin());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SectionBasedLayoutPaperCanvasSizeOptions)) {
            return false;
        }
        SectionBasedLayoutPaperCanvasSizeOptions other = (SectionBasedLayoutPaperCanvasSizeOptions)obj;
        return Objects.equals(this.paperSizeAsString(), other.paperSizeAsString()) && Objects.equals(this.paperOrientationAsString(), other.paperOrientationAsString()) && Objects.equals(this.paperMargin(), other.paperMargin());
    }

    public final String toString() {
        return ToString.builder((String)"SectionBasedLayoutPaperCanvasSizeOptions").add("PaperSize", (Object)this.paperSizeAsString()).add("PaperOrientation", (Object)this.paperOrientationAsString()).add("PaperMargin", (Object)this.paperMargin()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PaperSize": {
                return Optional.ofNullable(clazz.cast(this.paperSizeAsString()));
            }
            case "PaperOrientation": {
                return Optional.ofNullable(clazz.cast(this.paperOrientationAsString()));
            }
            case "PaperMargin": {
                return Optional.ofNullable(clazz.cast(this.paperMargin()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PaperSize", PAPER_SIZE_FIELD);
        map.put("PaperOrientation", PAPER_ORIENTATION_FIELD);
        map.put("PaperMargin", PAPER_MARGIN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SectionBasedLayoutPaperCanvasSizeOptions, T> g) {
        return obj -> g.apply((SectionBasedLayoutPaperCanvasSizeOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String paperSize;
        private String paperOrientation;
        private Spacing paperMargin;

        private BuilderImpl() {
        }

        private BuilderImpl(SectionBasedLayoutPaperCanvasSizeOptions model) {
            this.paperSize(model.paperSize);
            this.paperOrientation(model.paperOrientation);
            this.paperMargin(model.paperMargin);
        }

        public final String getPaperSize() {
            return this.paperSize;
        }

        public final void setPaperSize(String paperSize) {
            this.paperSize = paperSize;
        }

        @Override
        public final Builder paperSize(String paperSize) {
            this.paperSize = paperSize;
            return this;
        }

        @Override
        public final Builder paperSize(PaperSize paperSize) {
            this.paperSize(paperSize == null ? null : paperSize.toString());
            return this;
        }

        public final String getPaperOrientation() {
            return this.paperOrientation;
        }

        public final void setPaperOrientation(String paperOrientation) {
            this.paperOrientation = paperOrientation;
        }

        @Override
        public final Builder paperOrientation(String paperOrientation) {
            this.paperOrientation = paperOrientation;
            return this;
        }

        @Override
        public final Builder paperOrientation(PaperOrientation paperOrientation) {
            this.paperOrientation(paperOrientation == null ? null : paperOrientation.toString());
            return this;
        }

        public final Spacing.Builder getPaperMargin() {
            return this.paperMargin != null ? this.paperMargin.toBuilder() : null;
        }

        public final void setPaperMargin(Spacing.BuilderImpl paperMargin) {
            this.paperMargin = paperMargin != null ? paperMargin.build() : null;
        }

        @Override
        public final Builder paperMargin(Spacing paperMargin) {
            this.paperMargin = paperMargin;
            return this;
        }

        public SectionBasedLayoutPaperCanvasSizeOptions build() {
            return new SectionBasedLayoutPaperCanvasSizeOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SectionBasedLayoutPaperCanvasSizeOptions> {
        public Builder paperSize(String var1);

        public Builder paperSize(PaperSize var1);

        public Builder paperOrientation(String var1);

        public Builder paperOrientation(PaperOrientation var1);

        public Builder paperMargin(Spacing var1);

        default public Builder paperMargin(Consumer<Spacing.Builder> paperMargin) {
            return this.paperMargin((Spacing)((Spacing.Builder)Spacing.builder().applyMutation(paperMargin)).build());
        }
    }
}

