/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.BrandSummary;
import software.amazon.awssdk.services.quicksight.model.BrandSummaryListCopier;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBrandsResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, ListBrandsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListBrandsResponse.getter(ListBrandsResponse::nextToken)).setter(ListBrandsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<BrandSummary>> BRANDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Brands").getter(ListBrandsResponse.getter(ListBrandsResponse::brands)).setter(ListBrandsResponse.setter(Builder::brands)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Brands").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BrandSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, BRANDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListBrandsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<BrandSummary> brands;

    private ListBrandsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.brands = builder.brands;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasBrands() {
        return this.brands != null && !(this.brands instanceof SdkAutoConstructList);
    }

    public final List<BrandSummary> brands() {
        return this.brands;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBrands() ? this.brands() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBrandsResponse)) {
            return false;
        }
        ListBrandsResponse other = (ListBrandsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasBrands() == other.hasBrands() && Objects.equals(this.brands(), other.brands());
    }

    public final String toString() {
        return ToString.builder((String)"ListBrandsResponse").add("NextToken", (Object)this.nextToken()).add("Brands", this.hasBrands() ? this.brands() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Brands": {
                return Optional.ofNullable(clazz.cast(this.brands()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Brands", BRANDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBrandsResponse, T> g) {
        return obj -> g.apply((ListBrandsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<BrandSummary> brands = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListBrandsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.brands(model.brands);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<BrandSummary.Builder> getBrands() {
            List<BrandSummary.Builder> result = BrandSummaryListCopier.copyToBuilder(this.brands);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBrands(Collection<BrandSummary.BuilderImpl> brands) {
            this.brands = BrandSummaryListCopier.copyFromBuilder(brands);
        }

        @Override
        public final Builder brands(Collection<BrandSummary> brands) {
            this.brands = BrandSummaryListCopier.copy(brands);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder brands(BrandSummary ... brands) {
            this.brands(Arrays.asList(brands));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder brands(Consumer<BrandSummary.Builder> ... brands) {
            this.brands(Stream.of(brands).map(c -> (BrandSummary)((BrandSummary.Builder)BrandSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListBrandsResponse build() {
            return new ListBrandsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBrandsResponse> {
        public Builder nextToken(String var1);

        public Builder brands(Collection<BrandSummary> var1);

        public Builder brands(BrandSummary ... var1);

        public Builder brands(Consumer<BrandSummary.Builder> ... var1);
    }
}

