/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.AggregationFunction;
import software.amazon.awssdk.services.quicksight.model.ColumnIdentifier;
import software.amazon.awssdk.services.quicksight.model.SortDirection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ColumnSort
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ColumnSort> {
    private static final SdkField<ColumnIdentifier> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SortBy").getter(ColumnSort.getter(ColumnSort::sortBy)).setter(ColumnSort.setter(Builder::sortBy)).constructor(ColumnIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()}).build();
    private static final SdkField<String> DIRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Direction").getter(ColumnSort.getter(ColumnSort::directionAsString)).setter(ColumnSort.setter(Builder::direction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Direction").build()}).build();
    private static final SdkField<AggregationFunction> AGGREGATION_FUNCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AggregationFunction").getter(ColumnSort.getter(ColumnSort::aggregationFunction)).setter(ColumnSort.setter(Builder::aggregationFunction)).constructor(AggregationFunction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationFunction").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SORT_BY_FIELD, DIRECTION_FIELD, AGGREGATION_FUNCTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ColumnSort.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ColumnIdentifier sortBy;
    private final String direction;
    private final AggregationFunction aggregationFunction;

    private ColumnSort(BuilderImpl builder) {
        this.sortBy = builder.sortBy;
        this.direction = builder.direction;
        this.aggregationFunction = builder.aggregationFunction;
    }

    public final ColumnIdentifier sortBy() {
        return this.sortBy;
    }

    public final SortDirection direction() {
        return SortDirection.fromValue(this.direction);
    }

    public final String directionAsString() {
        return this.direction;
    }

    public final AggregationFunction aggregationFunction() {
        return this.aggregationFunction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sortBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.directionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationFunction());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnSort)) {
            return false;
        }
        ColumnSort other = (ColumnSort)obj;
        return Objects.equals(this.sortBy(), other.sortBy()) && Objects.equals(this.directionAsString(), other.directionAsString()) && Objects.equals(this.aggregationFunction(), other.aggregationFunction());
    }

    public final String toString() {
        return ToString.builder((String)"ColumnSort").add("SortBy", (Object)this.sortBy()).add("Direction", (Object)this.directionAsString()).add("AggregationFunction", (Object)this.aggregationFunction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SortBy": {
                return Optional.ofNullable(clazz.cast(this.sortBy()));
            }
            case "Direction": {
                return Optional.ofNullable(clazz.cast(this.directionAsString()));
            }
            case "AggregationFunction": {
                return Optional.ofNullable(clazz.cast(this.aggregationFunction()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SortBy", SORT_BY_FIELD);
        map.put("Direction", DIRECTION_FIELD);
        map.put("AggregationFunction", AGGREGATION_FUNCTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ColumnSort, T> g) {
        return obj -> g.apply((ColumnSort)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ColumnIdentifier sortBy;
        private String direction;
        private AggregationFunction aggregationFunction;

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnSort model) {
            this.sortBy(model.sortBy);
            this.direction(model.direction);
            this.aggregationFunction(model.aggregationFunction);
        }

        public final ColumnIdentifier.Builder getSortBy() {
            return this.sortBy != null ? this.sortBy.toBuilder() : null;
        }

        public final void setSortBy(ColumnIdentifier.BuilderImpl sortBy) {
            this.sortBy = sortBy != null ? sortBy.build() : null;
        }

        @Override
        public final Builder sortBy(ColumnIdentifier sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public final String getDirection() {
            return this.direction;
        }

        public final void setDirection(String direction) {
            this.direction = direction;
        }

        @Override
        public final Builder direction(String direction) {
            this.direction = direction;
            return this;
        }

        @Override
        public final Builder direction(SortDirection direction) {
            this.direction(direction == null ? null : direction.toString());
            return this;
        }

        public final AggregationFunction.Builder getAggregationFunction() {
            return this.aggregationFunction != null ? this.aggregationFunction.toBuilder() : null;
        }

        public final void setAggregationFunction(AggregationFunction.BuilderImpl aggregationFunction) {
            this.aggregationFunction = aggregationFunction != null ? aggregationFunction.build() : null;
        }

        @Override
        public final Builder aggregationFunction(AggregationFunction aggregationFunction) {
            this.aggregationFunction = aggregationFunction;
            return this;
        }

        public ColumnSort build() {
            return new ColumnSort(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ColumnSort> {
        public Builder sortBy(ColumnIdentifier var1);

        default public Builder sortBy(Consumer<ColumnIdentifier.Builder> sortBy) {
            return this.sortBy((ColumnIdentifier)((ColumnIdentifier.Builder)ColumnIdentifier.builder().applyMutation(sortBy)).build());
        }

        public Builder direction(String var1);

        public Builder direction(SortDirection var1);

        public Builder aggregationFunction(AggregationFunction var1);

        default public Builder aggregationFunction(Consumer<AggregationFunction.Builder> aggregationFunction) {
            return this.aggregationFunction((AggregationFunction)((AggregationFunction.Builder)AggregationFunction.builder().applyMutation(aggregationFunction)).build());
        }
    }
}

