/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.DataSetArnsListCopier;
import software.amazon.awssdk.services.quicksight.model.DayOfTheWeek;
import software.amazon.awssdk.services.quicksight.model.QBusinessInsightsStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetOptions> {
    private static final SdkField<String> TIMEZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Timezone").getter(AssetOptions.getter(AssetOptions::timezone)).setter(AssetOptions.setter(Builder::timezone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()}).build();
    private static final SdkField<String> WEEK_START_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WeekStart").getter(AssetOptions.getter(AssetOptions::weekStartAsString)).setter(AssetOptions.setter(Builder::weekStart)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeekStart").build()}).build();
    private static final SdkField<String> Q_BUSINESS_INSIGHTS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QBusinessInsightsStatus").getter(AssetOptions.getter(AssetOptions::qBusinessInsightsStatusAsString)).setter(AssetOptions.setter(Builder::qBusinessInsightsStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QBusinessInsightsStatus").build()}).build();
    private static final SdkField<List<String>> EXCLUDED_DATA_SET_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludedDataSetArns").getter(AssetOptions.getter(AssetOptions::excludedDataSetArns)).setter(AssetOptions.setter(Builder::excludedDataSetArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludedDataSetArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMEZONE_FIELD, WEEK_START_FIELD, Q_BUSINESS_INSIGHTS_STATUS_FIELD, EXCLUDED_DATA_SET_ARNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssetOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String timezone;
    private final String weekStart;
    private final String qBusinessInsightsStatus;
    private final List<String> excludedDataSetArns;

    private AssetOptions(BuilderImpl builder) {
        this.timezone = builder.timezone;
        this.weekStart = builder.weekStart;
        this.qBusinessInsightsStatus = builder.qBusinessInsightsStatus;
        this.excludedDataSetArns = builder.excludedDataSetArns;
    }

    public final String timezone() {
        return this.timezone;
    }

    public final DayOfTheWeek weekStart() {
        return DayOfTheWeek.fromValue(this.weekStart);
    }

    public final String weekStartAsString() {
        return this.weekStart;
    }

    public final QBusinessInsightsStatus qBusinessInsightsStatus() {
        return QBusinessInsightsStatus.fromValue(this.qBusinessInsightsStatus);
    }

    public final String qBusinessInsightsStatusAsString() {
        return this.qBusinessInsightsStatus;
    }

    public final boolean hasExcludedDataSetArns() {
        return this.excludedDataSetArns != null && !(this.excludedDataSetArns instanceof SdkAutoConstructList);
    }

    public final List<String> excludedDataSetArns() {
        return this.excludedDataSetArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timezone());
        hashCode = 31 * hashCode + Objects.hashCode(this.weekStartAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.qBusinessInsightsStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludedDataSetArns() ? this.excludedDataSetArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetOptions)) {
            return false;
        }
        AssetOptions other = (AssetOptions)obj;
        return Objects.equals(this.timezone(), other.timezone()) && Objects.equals(this.weekStartAsString(), other.weekStartAsString()) && Objects.equals(this.qBusinessInsightsStatusAsString(), other.qBusinessInsightsStatusAsString()) && this.hasExcludedDataSetArns() == other.hasExcludedDataSetArns() && Objects.equals(this.excludedDataSetArns(), other.excludedDataSetArns());
    }

    public final String toString() {
        return ToString.builder((String)"AssetOptions").add("Timezone", (Object)this.timezone()).add("WeekStart", (Object)this.weekStartAsString()).add("QBusinessInsightsStatus", (Object)this.qBusinessInsightsStatusAsString()).add("ExcludedDataSetArns", this.hasExcludedDataSetArns() ? this.excludedDataSetArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Timezone": {
                return Optional.ofNullable(clazz.cast(this.timezone()));
            }
            case "WeekStart": {
                return Optional.ofNullable(clazz.cast(this.weekStartAsString()));
            }
            case "QBusinessInsightsStatus": {
                return Optional.ofNullable(clazz.cast(this.qBusinessInsightsStatusAsString()));
            }
            case "ExcludedDataSetArns": {
                return Optional.ofNullable(clazz.cast(this.excludedDataSetArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Timezone", TIMEZONE_FIELD);
        map.put("WeekStart", WEEK_START_FIELD);
        map.put("QBusinessInsightsStatus", Q_BUSINESS_INSIGHTS_STATUS_FIELD);
        map.put("ExcludedDataSetArns", EXCLUDED_DATA_SET_ARNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssetOptions, T> g) {
        return obj -> g.apply((AssetOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String timezone;
        private String weekStart;
        private String qBusinessInsightsStatus;
        private List<String> excludedDataSetArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssetOptions model) {
            this.timezone(model.timezone);
            this.weekStart(model.weekStart);
            this.qBusinessInsightsStatus(model.qBusinessInsightsStatus);
            this.excludedDataSetArns(model.excludedDataSetArns);
        }

        public final String getTimezone() {
            return this.timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final String getWeekStart() {
            return this.weekStart;
        }

        public final void setWeekStart(String weekStart) {
            this.weekStart = weekStart;
        }

        @Override
        public final Builder weekStart(String weekStart) {
            this.weekStart = weekStart;
            return this;
        }

        @Override
        public final Builder weekStart(DayOfTheWeek weekStart) {
            this.weekStart(weekStart == null ? null : weekStart.toString());
            return this;
        }

        public final String getQBusinessInsightsStatus() {
            return this.qBusinessInsightsStatus;
        }

        public final void setQBusinessInsightsStatus(String qBusinessInsightsStatus) {
            this.qBusinessInsightsStatus = qBusinessInsightsStatus;
        }

        @Override
        public final Builder qBusinessInsightsStatus(String qBusinessInsightsStatus) {
            this.qBusinessInsightsStatus = qBusinessInsightsStatus;
            return this;
        }

        @Override
        public final Builder qBusinessInsightsStatus(QBusinessInsightsStatus qBusinessInsightsStatus) {
            this.qBusinessInsightsStatus(qBusinessInsightsStatus == null ? null : qBusinessInsightsStatus.toString());
            return this;
        }

        public final Collection<String> getExcludedDataSetArns() {
            if (this.excludedDataSetArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.excludedDataSetArns;
        }

        public final void setExcludedDataSetArns(Collection<String> excludedDataSetArns) {
            this.excludedDataSetArns = DataSetArnsListCopier.copy(excludedDataSetArns);
        }

        @Override
        public final Builder excludedDataSetArns(Collection<String> excludedDataSetArns) {
            this.excludedDataSetArns = DataSetArnsListCopier.copy(excludedDataSetArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedDataSetArns(String ... excludedDataSetArns) {
            this.excludedDataSetArns(Arrays.asList(excludedDataSetArns));
            return this;
        }

        public AssetOptions build() {
            return new AssetOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetOptions> {
        public Builder timezone(String var1);

        public Builder weekStart(String var1);

        public Builder weekStart(DayOfTheWeek var1);

        public Builder qBusinessInsightsStatus(String var1);

        public Builder qBusinessInsightsStatus(QBusinessInsightsStatus var1);

        public Builder excludedDataSetArns(Collection<String> var1);

        public Builder excludedDataSetArns(String ... var1);
    }
}

