/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.services.quicksight.model.VPCConnectionAvailabilityStatus;
import software.amazon.awssdk.services.quicksight.model.VPCConnectionResourceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateVpcConnectionResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, UpdateVpcConnectionResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(UpdateVpcConnectionResponse.getter(UpdateVpcConnectionResponse::arn)).setter(UpdateVpcConnectionResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> VPC_CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VPCConnectionId").getter(UpdateVpcConnectionResponse.getter(UpdateVpcConnectionResponse::vpcConnectionId)).setter(UpdateVpcConnectionResponse.setter(Builder::vpcConnectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCConnectionId").build()}).build();
    private static final SdkField<String> UPDATE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdateStatus").getter(UpdateVpcConnectionResponse.getter(UpdateVpcConnectionResponse::updateStatusAsString)).setter(UpdateVpcConnectionResponse.setter(Builder::updateStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateStatus").build()}).build();
    private static final SdkField<String> AVAILABILITY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityStatus").getter(UpdateVpcConnectionResponse.getter(UpdateVpcConnectionResponse::availabilityStatusAsString)).setter(UpdateVpcConnectionResponse.setter(Builder::availabilityStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityStatus").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(UpdateVpcConnectionResponse.getter(UpdateVpcConnectionResponse::requestId)).setter(UpdateVpcConnectionResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(UpdateVpcConnectionResponse.getter(UpdateVpcConnectionResponse::status)).setter(UpdateVpcConnectionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, VPC_CONNECTION_ID_FIELD, UPDATE_STATUS_FIELD, AVAILABILITY_STATUS_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateVpcConnectionResponse.memberNameToFieldInitializer();
    private final String arn;
    private final String vpcConnectionId;
    private final String updateStatus;
    private final String availabilityStatus;
    private final String requestId;
    private final Integer status;

    private UpdateVpcConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.vpcConnectionId = builder.vpcConnectionId;
        this.updateStatus = builder.updateStatus;
        this.availabilityStatus = builder.availabilityStatus;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    public final String arn() {
        return this.arn;
    }

    public final String vpcConnectionId() {
        return this.vpcConnectionId;
    }

    public final VPCConnectionResourceStatus updateStatus() {
        return VPCConnectionResourceStatus.fromValue(this.updateStatus);
    }

    public final String updateStatusAsString() {
        return this.updateStatus;
    }

    public final VPCConnectionAvailabilityStatus availabilityStatus() {
        return VPCConnectionAvailabilityStatus.fromValue(this.availabilityStatus);
    }

    public final String availabilityStatusAsString() {
        return this.availabilityStatus;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final Integer status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConnectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVpcConnectionResponse)) {
            return false;
        }
        UpdateVpcConnectionResponse other = (UpdateVpcConnectionResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.vpcConnectionId(), other.vpcConnectionId()) && Objects.equals(this.updateStatusAsString(), other.updateStatusAsString()) && Objects.equals(this.availabilityStatusAsString(), other.availabilityStatusAsString()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateVpcConnectionResponse").add("Arn", (Object)this.arn()).add("VPCConnectionId", (Object)this.vpcConnectionId()).add("UpdateStatus", (Object)this.updateStatusAsString()).add("AvailabilityStatus", (Object)this.availabilityStatusAsString()).add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "VPCConnectionId": {
                return Optional.ofNullable(clazz.cast(this.vpcConnectionId()));
            }
            case "UpdateStatus": {
                return Optional.ofNullable(clazz.cast(this.updateStatusAsString()));
            }
            case "AvailabilityStatus": {
                return Optional.ofNullable(clazz.cast(this.availabilityStatusAsString()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("VPCConnectionId", VPC_CONNECTION_ID_FIELD);
        map.put("UpdateStatus", UPDATE_STATUS_FIELD);
        map.put("AvailabilityStatus", AVAILABILITY_STATUS_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateVpcConnectionResponse, T> g) {
        return obj -> g.apply((UpdateVpcConnectionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String vpcConnectionId;
        private String updateStatus;
        private String availabilityStatus;
        private String requestId;
        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVpcConnectionResponse model) {
            super(model);
            this.arn(model.arn);
            this.vpcConnectionId(model.vpcConnectionId);
            this.updateStatus(model.updateStatus);
            this.availabilityStatus(model.availabilityStatus);
            this.requestId(model.requestId);
            this.status(model.status);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getVpcConnectionId() {
            return this.vpcConnectionId;
        }

        public final void setVpcConnectionId(String vpcConnectionId) {
            this.vpcConnectionId = vpcConnectionId;
        }

        @Override
        public final Builder vpcConnectionId(String vpcConnectionId) {
            this.vpcConnectionId = vpcConnectionId;
            return this;
        }

        public final String getUpdateStatus() {
            return this.updateStatus;
        }

        public final void setUpdateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
        }

        @Override
        public final Builder updateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
            return this;
        }

        @Override
        public final Builder updateStatus(VPCConnectionResourceStatus updateStatus) {
            this.updateStatus(updateStatus == null ? null : updateStatus.toString());
            return this;
        }

        public final String getAvailabilityStatus() {
            return this.availabilityStatus;
        }

        public final void setAvailabilityStatus(String availabilityStatus) {
            this.availabilityStatus = availabilityStatus;
        }

        @Override
        public final Builder availabilityStatus(String availabilityStatus) {
            this.availabilityStatus = availabilityStatus;
            return this;
        }

        @Override
        public final Builder availabilityStatus(VPCConnectionAvailabilityStatus availabilityStatus) {
            this.availabilityStatus(availabilityStatus == null ? null : availabilityStatus.toString());
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public UpdateVpcConnectionResponse build() {
            return new UpdateVpcConnectionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateVpcConnectionResponse> {
        public Builder arn(String var1);

        public Builder vpcConnectionId(String var1);

        public Builder updateStatus(String var1);

        public Builder updateStatus(VPCConnectionResourceStatus var1);

        public Builder availabilityStatus(String var1);

        public Builder availabilityStatus(VPCConnectionAvailabilityStatus var1);

        public Builder requestId(String var1);

        public Builder status(Integer var1);
    }
}

