/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PluginVisualAxisName {
    GROUP_BY("GROUP_BY"),
    VALUE("VALUE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PluginVisualAxisName> VALUE_MAP;
    private final String value;

    private PluginVisualAxisName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PluginVisualAxisName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PluginVisualAxisName> knownValues() {
        EnumSet<PluginVisualAxisName> knownValues = EnumSet.allOf(PluginVisualAxisName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PluginVisualAxisName.class, PluginVisualAxisName::toString);
    }
}

