/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.BodySectionDynamicDimensionSortConfigurationListCopier;
import software.amazon.awssdk.services.quicksight.model.ColumnIdentifier;
import software.amazon.awssdk.services.quicksight.model.ColumnSort;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BodySectionDynamicNumericDimensionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BodySectionDynamicNumericDimensionConfiguration> {
    private static final SdkField<ColumnIdentifier> COLUMN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Column").getter(BodySectionDynamicNumericDimensionConfiguration.getter(BodySectionDynamicNumericDimensionConfiguration::column)).setter(BodySectionDynamicNumericDimensionConfiguration.setter(Builder::column)).constructor(ColumnIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Limit").getter(BodySectionDynamicNumericDimensionConfiguration.getter(BodySectionDynamicNumericDimensionConfiguration::limit)).setter(BodySectionDynamicNumericDimensionConfiguration.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final SdkField<List<ColumnSort>> SORT_BY_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SortByMetrics").getter(BodySectionDynamicNumericDimensionConfiguration.getter(BodySectionDynamicNumericDimensionConfiguration::sortByMetrics)).setter(BodySectionDynamicNumericDimensionConfiguration.setter(Builder::sortByMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortByMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnSort::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_FIELD, LIMIT_FIELD, SORT_BY_METRICS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BodySectionDynamicNumericDimensionConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ColumnIdentifier column;
    private final Integer limit;
    private final List<ColumnSort> sortByMetrics;

    private BodySectionDynamicNumericDimensionConfiguration(BuilderImpl builder) {
        this.column = builder.column;
        this.limit = builder.limit;
        this.sortByMetrics = builder.sortByMetrics;
    }

    public final ColumnIdentifier column() {
        return this.column;
    }

    public final Integer limit() {
        return this.limit;
    }

    public final boolean hasSortByMetrics() {
        return this.sortByMetrics != null && !(this.sortByMetrics instanceof SdkAutoConstructList);
    }

    public final List<ColumnSort> sortByMetrics() {
        return this.sortByMetrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.column());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSortByMetrics() ? this.sortByMetrics() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BodySectionDynamicNumericDimensionConfiguration)) {
            return false;
        }
        BodySectionDynamicNumericDimensionConfiguration other = (BodySectionDynamicNumericDimensionConfiguration)obj;
        return Objects.equals(this.column(), other.column()) && Objects.equals(this.limit(), other.limit()) && this.hasSortByMetrics() == other.hasSortByMetrics() && Objects.equals(this.sortByMetrics(), other.sortByMetrics());
    }

    public final String toString() {
        return ToString.builder((String)"BodySectionDynamicNumericDimensionConfiguration").add("Column", (Object)this.column()).add("Limit", (Object)this.limit()).add("SortByMetrics", this.hasSortByMetrics() ? this.sortByMetrics() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Column": {
                return Optional.ofNullable(clazz.cast(this.column()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "SortByMetrics": {
                return Optional.ofNullable(clazz.cast(this.sortByMetrics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Column", COLUMN_FIELD);
        map.put("Limit", LIMIT_FIELD);
        map.put("SortByMetrics", SORT_BY_METRICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BodySectionDynamicNumericDimensionConfiguration, T> g) {
        return obj -> g.apply((BodySectionDynamicNumericDimensionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ColumnIdentifier column;
        private Integer limit;
        private List<ColumnSort> sortByMetrics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BodySectionDynamicNumericDimensionConfiguration model) {
            this.column(model.column);
            this.limit(model.limit);
            this.sortByMetrics(model.sortByMetrics);
        }

        public final ColumnIdentifier.Builder getColumn() {
            return this.column != null ? this.column.toBuilder() : null;
        }

        public final void setColumn(ColumnIdentifier.BuilderImpl column) {
            this.column = column != null ? column.build() : null;
        }

        @Override
        public final Builder column(ColumnIdentifier column) {
            this.column = column;
            return this;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final List<ColumnSort.Builder> getSortByMetrics() {
            List<ColumnSort.Builder> result = BodySectionDynamicDimensionSortConfigurationListCopier.copyToBuilder(this.sortByMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSortByMetrics(Collection<ColumnSort.BuilderImpl> sortByMetrics) {
            this.sortByMetrics = BodySectionDynamicDimensionSortConfigurationListCopier.copyFromBuilder(sortByMetrics);
        }

        @Override
        public final Builder sortByMetrics(Collection<ColumnSort> sortByMetrics) {
            this.sortByMetrics = BodySectionDynamicDimensionSortConfigurationListCopier.copy(sortByMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortByMetrics(ColumnSort ... sortByMetrics) {
            this.sortByMetrics(Arrays.asList(sortByMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortByMetrics(Consumer<ColumnSort.Builder> ... sortByMetrics) {
            this.sortByMetrics(Stream.of(sortByMetrics).map(c -> (ColumnSort)((ColumnSort.Builder)ColumnSort.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public BodySectionDynamicNumericDimensionConfiguration build() {
            return new BodySectionDynamicNumericDimensionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BodySectionDynamicNumericDimensionConfiguration> {
        public Builder column(ColumnIdentifier var1);

        default public Builder column(Consumer<ColumnIdentifier.Builder> column) {
            return this.column((ColumnIdentifier)((ColumnIdentifier.Builder)ColumnIdentifier.builder().applyMutation(column)).build());
        }

        public Builder limit(Integer var1);

        public Builder sortByMetrics(Collection<ColumnSort> var1);

        public Builder sortByMetrics(ColumnSort ... var1);

        public Builder sortByMetrics(Consumer<ColumnSort.Builder> ... var1);
    }
}

