/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAccountSettingsRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, UpdateAccountSettingsRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(UpdateAccountSettingsRequest.getter(UpdateAccountSettingsRequest::awsAccountId)).setter(UpdateAccountSettingsRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> DEFAULT_NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultNamespace").getter(UpdateAccountSettingsRequest.getter(UpdateAccountSettingsRequest::defaultNamespace)).setter(UpdateAccountSettingsRequest.setter(Builder::defaultNamespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultNamespace").build()}).build();
    private static final SdkField<String> NOTIFICATION_EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotificationEmail").getter(UpdateAccountSettingsRequest.getter(UpdateAccountSettingsRequest::notificationEmail)).setter(UpdateAccountSettingsRequest.setter(Builder::notificationEmail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationEmail").build()}).build();
    private static final SdkField<Boolean> TERMINATION_PROTECTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TerminationProtectionEnabled").getter(UpdateAccountSettingsRequest.getter(UpdateAccountSettingsRequest::terminationProtectionEnabled)).setter(UpdateAccountSettingsRequest.setter(Builder::terminationProtectionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationProtectionEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, DEFAULT_NAMESPACE_FIELD, NOTIFICATION_EMAIL_FIELD, TERMINATION_PROTECTION_ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAccountSettingsRequest.memberNameToFieldInitializer();
    private final String awsAccountId;
    private final String defaultNamespace;
    private final String notificationEmail;
    private final Boolean terminationProtectionEnabled;

    private UpdateAccountSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.defaultNamespace = builder.defaultNamespace;
        this.notificationEmail = builder.notificationEmail;
        this.terminationProtectionEnabled = builder.terminationProtectionEnabled;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String defaultNamespace() {
        return this.defaultNamespace;
    }

    public final String notificationEmail() {
        return this.notificationEmail;
    }

    public final Boolean terminationProtectionEnabled() {
        return this.terminationProtectionEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationEmail());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminationProtectionEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAccountSettingsRequest)) {
            return false;
        }
        UpdateAccountSettingsRequest other = (UpdateAccountSettingsRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.defaultNamespace(), other.defaultNamespace()) && Objects.equals(this.notificationEmail(), other.notificationEmail()) && Objects.equals(this.terminationProtectionEnabled(), other.terminationProtectionEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAccountSettingsRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("DefaultNamespace", (Object)this.defaultNamespace()).add("NotificationEmail", (Object)this.notificationEmail()).add("TerminationProtectionEnabled", (Object)this.terminationProtectionEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "DefaultNamespace": {
                return Optional.ofNullable(clazz.cast(this.defaultNamespace()));
            }
            case "NotificationEmail": {
                return Optional.ofNullable(clazz.cast(this.notificationEmail()));
            }
            case "TerminationProtectionEnabled": {
                return Optional.ofNullable(clazz.cast(this.terminationProtectionEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("DefaultNamespace", DEFAULT_NAMESPACE_FIELD);
        map.put("NotificationEmail", NOTIFICATION_EMAIL_FIELD);
        map.put("TerminationProtectionEnabled", TERMINATION_PROTECTION_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAccountSettingsRequest, T> g) {
        return obj -> g.apply((UpdateAccountSettingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String defaultNamespace;
        private String notificationEmail;
        private Boolean terminationProtectionEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAccountSettingsRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.defaultNamespace(model.defaultNamespace);
            this.notificationEmail(model.notificationEmail);
            this.terminationProtectionEnabled(model.terminationProtectionEnabled);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getDefaultNamespace() {
            return this.defaultNamespace;
        }

        public final void setDefaultNamespace(String defaultNamespace) {
            this.defaultNamespace = defaultNamespace;
        }

        @Override
        public final Builder defaultNamespace(String defaultNamespace) {
            this.defaultNamespace = defaultNamespace;
            return this;
        }

        public final String getNotificationEmail() {
            return this.notificationEmail;
        }

        public final void setNotificationEmail(String notificationEmail) {
            this.notificationEmail = notificationEmail;
        }

        @Override
        public final Builder notificationEmail(String notificationEmail) {
            this.notificationEmail = notificationEmail;
            return this;
        }

        public final Boolean getTerminationProtectionEnabled() {
            return this.terminationProtectionEnabled;
        }

        public final void setTerminationProtectionEnabled(Boolean terminationProtectionEnabled) {
            this.terminationProtectionEnabled = terminationProtectionEnabled;
        }

        @Override
        public final Builder terminationProtectionEnabled(Boolean terminationProtectionEnabled) {
            this.terminationProtectionEnabled = terminationProtectionEnabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAccountSettingsRequest build() {
            return new UpdateAccountSettingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAccountSettingsRequest> {
        public Builder awsAccountId(String var1);

        public Builder defaultNamespace(String var1);

        public Builder notificationEmail(String var1);

        public Builder terminationProtectionEnabled(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

