/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSessionEmbedUrlRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, GetSessionEmbedUrlRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(GetSessionEmbedUrlRequest.getter(GetSessionEmbedUrlRequest::awsAccountId)).setter(GetSessionEmbedUrlRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> ENTRY_POINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntryPoint").getter(GetSessionEmbedUrlRequest.getter(GetSessionEmbedUrlRequest::entryPoint)).setter(GetSessionEmbedUrlRequest.setter(Builder::entryPoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("entry-point").build()}).build();
    private static final SdkField<Long> SESSION_LIFETIME_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("SessionLifetimeInMinutes").getter(GetSessionEmbedUrlRequest.getter(GetSessionEmbedUrlRequest::sessionLifetimeInMinutes)).setter(GetSessionEmbedUrlRequest.setter(Builder::sessionLifetimeInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("session-lifetime").build()}).build();
    private static final SdkField<String> USER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserArn").getter(GetSessionEmbedUrlRequest.getter(GetSessionEmbedUrlRequest::userArn)).setter(GetSessionEmbedUrlRequest.setter(Builder::userArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("user-arn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, ENTRY_POINT_FIELD, SESSION_LIFETIME_IN_MINUTES_FIELD, USER_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetSessionEmbedUrlRequest.memberNameToFieldInitializer();
    private final String awsAccountId;
    private final String entryPoint;
    private final Long sessionLifetimeInMinutes;
    private final String userArn;

    private GetSessionEmbedUrlRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.entryPoint = builder.entryPoint;
        this.sessionLifetimeInMinutes = builder.sessionLifetimeInMinutes;
        this.userArn = builder.userArn;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String entryPoint() {
        return this.entryPoint;
    }

    public final Long sessionLifetimeInMinutes() {
        return this.sessionLifetimeInMinutes;
    }

    public final String userArn() {
        return this.userArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.entryPoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionLifetimeInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.userArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSessionEmbedUrlRequest)) {
            return false;
        }
        GetSessionEmbedUrlRequest other = (GetSessionEmbedUrlRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.entryPoint(), other.entryPoint()) && Objects.equals(this.sessionLifetimeInMinutes(), other.sessionLifetimeInMinutes()) && Objects.equals(this.userArn(), other.userArn());
    }

    public final String toString() {
        return ToString.builder((String)"GetSessionEmbedUrlRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("EntryPoint", (Object)this.entryPoint()).add("SessionLifetimeInMinutes", (Object)this.sessionLifetimeInMinutes()).add("UserArn", (Object)this.userArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "EntryPoint": {
                return Optional.ofNullable(clazz.cast(this.entryPoint()));
            }
            case "SessionLifetimeInMinutes": {
                return Optional.ofNullable(clazz.cast(this.sessionLifetimeInMinutes()));
            }
            case "UserArn": {
                return Optional.ofNullable(clazz.cast(this.userArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("entry-point", ENTRY_POINT_FIELD);
        map.put("session-lifetime", SESSION_LIFETIME_IN_MINUTES_FIELD);
        map.put("user-arn", USER_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSessionEmbedUrlRequest, T> g) {
        return obj -> g.apply((GetSessionEmbedUrlRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String entryPoint;
        private Long sessionLifetimeInMinutes;
        private String userArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSessionEmbedUrlRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.entryPoint(model.entryPoint);
            this.sessionLifetimeInMinutes(model.sessionLifetimeInMinutes);
            this.userArn(model.userArn);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getEntryPoint() {
            return this.entryPoint;
        }

        public final void setEntryPoint(String entryPoint) {
            this.entryPoint = entryPoint;
        }

        @Override
        public final Builder entryPoint(String entryPoint) {
            this.entryPoint = entryPoint;
            return this;
        }

        public final Long getSessionLifetimeInMinutes() {
            return this.sessionLifetimeInMinutes;
        }

        public final void setSessionLifetimeInMinutes(Long sessionLifetimeInMinutes) {
            this.sessionLifetimeInMinutes = sessionLifetimeInMinutes;
        }

        @Override
        public final Builder sessionLifetimeInMinutes(Long sessionLifetimeInMinutes) {
            this.sessionLifetimeInMinutes = sessionLifetimeInMinutes;
            return this;
        }

        public final String getUserArn() {
            return this.userArn;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        @Override
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSessionEmbedUrlRequest build() {
            return new GetSessionEmbedUrlRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSessionEmbedUrlRequest> {
        public Builder awsAccountId(String var1);

        public Builder entryPoint(String var1);

        public Builder sessionLifetimeInMinutes(Long var1);

        public Builder userArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

