/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.DateTimeParameter;
import software.amazon.awssdk.services.quicksight.model.DateTimeParameterListCopier;
import software.amazon.awssdk.services.quicksight.model.DecimalParameter;
import software.amazon.awssdk.services.quicksight.model.DecimalParameterListCopier;
import software.amazon.awssdk.services.quicksight.model.IntegerParameter;
import software.amazon.awssdk.services.quicksight.model.IntegerParameterListCopier;
import software.amazon.awssdk.services.quicksight.model.StringParameter;
import software.amazon.awssdk.services.quicksight.model.StringParameterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Parameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Parameters> {
    private static final SdkField<List<StringParameter>> STRING_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StringParameters").getter(Parameters.getter(Parameters::stringParameters)).setter(Parameters.setter(Builder::stringParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StringParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<IntegerParameter>> INTEGER_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IntegerParameters").getter(Parameters.getter(Parameters::integerParameters)).setter(Parameters.setter(Builder::integerParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegerParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IntegerParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DecimalParameter>> DECIMAL_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DecimalParameters").getter(Parameters.getter(Parameters::decimalParameters)).setter(Parameters.setter(Builder::decimalParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DecimalParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DecimalParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DateTimeParameter>> DATE_TIME_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DateTimeParameters").getter(Parameters.getter(Parameters::dateTimeParameters)).setter(Parameters.setter(Builder::dateTimeParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateTimeParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DateTimeParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_PARAMETERS_FIELD, INTEGER_PARAMETERS_FIELD, DECIMAL_PARAMETERS_FIELD, DATE_TIME_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Parameters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<StringParameter> stringParameters;
    private final List<IntegerParameter> integerParameters;
    private final List<DecimalParameter> decimalParameters;
    private final List<DateTimeParameter> dateTimeParameters;

    private Parameters(BuilderImpl builder) {
        this.stringParameters = builder.stringParameters;
        this.integerParameters = builder.integerParameters;
        this.decimalParameters = builder.decimalParameters;
        this.dateTimeParameters = builder.dateTimeParameters;
    }

    public final boolean hasStringParameters() {
        return this.stringParameters != null && !(this.stringParameters instanceof SdkAutoConstructList);
    }

    public final List<StringParameter> stringParameters() {
        return this.stringParameters;
    }

    public final boolean hasIntegerParameters() {
        return this.integerParameters != null && !(this.integerParameters instanceof SdkAutoConstructList);
    }

    public final List<IntegerParameter> integerParameters() {
        return this.integerParameters;
    }

    public final boolean hasDecimalParameters() {
        return this.decimalParameters != null && !(this.decimalParameters instanceof SdkAutoConstructList);
    }

    public final List<DecimalParameter> decimalParameters() {
        return this.decimalParameters;
    }

    public final boolean hasDateTimeParameters() {
        return this.dateTimeParameters != null && !(this.dateTimeParameters instanceof SdkAutoConstructList);
    }

    public final List<DateTimeParameter> dateTimeParameters() {
        return this.dateTimeParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStringParameters() ? this.stringParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIntegerParameters() ? this.integerParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDecimalParameters() ? this.decimalParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDateTimeParameters() ? this.dateTimeParameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Parameters)) {
            return false;
        }
        Parameters other = (Parameters)obj;
        return this.hasStringParameters() == other.hasStringParameters() && Objects.equals(this.stringParameters(), other.stringParameters()) && this.hasIntegerParameters() == other.hasIntegerParameters() && Objects.equals(this.integerParameters(), other.integerParameters()) && this.hasDecimalParameters() == other.hasDecimalParameters() && Objects.equals(this.decimalParameters(), other.decimalParameters()) && this.hasDateTimeParameters() == other.hasDateTimeParameters() && Objects.equals(this.dateTimeParameters(), other.dateTimeParameters());
    }

    public final String toString() {
        return ToString.builder((String)"Parameters").add("StringParameters", this.hasStringParameters() ? this.stringParameters() : null).add("IntegerParameters", this.hasIntegerParameters() ? this.integerParameters() : null).add("DecimalParameters", this.hasDecimalParameters() ? this.decimalParameters() : null).add("DateTimeParameters", this.hasDateTimeParameters() ? this.dateTimeParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StringParameters": {
                return Optional.ofNullable(clazz.cast(this.stringParameters()));
            }
            case "IntegerParameters": {
                return Optional.ofNullable(clazz.cast(this.integerParameters()));
            }
            case "DecimalParameters": {
                return Optional.ofNullable(clazz.cast(this.decimalParameters()));
            }
            case "DateTimeParameters": {
                return Optional.ofNullable(clazz.cast(this.dateTimeParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StringParameters", STRING_PARAMETERS_FIELD);
        map.put("IntegerParameters", INTEGER_PARAMETERS_FIELD);
        map.put("DecimalParameters", DECIMAL_PARAMETERS_FIELD);
        map.put("DateTimeParameters", DATE_TIME_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Parameters, T> g) {
        return obj -> g.apply((Parameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<StringParameter> stringParameters = DefaultSdkAutoConstructList.getInstance();
        private List<IntegerParameter> integerParameters = DefaultSdkAutoConstructList.getInstance();
        private List<DecimalParameter> decimalParameters = DefaultSdkAutoConstructList.getInstance();
        private List<DateTimeParameter> dateTimeParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Parameters model) {
            this.stringParameters(model.stringParameters);
            this.integerParameters(model.integerParameters);
            this.decimalParameters(model.decimalParameters);
            this.dateTimeParameters(model.dateTimeParameters);
        }

        public final List<StringParameter.Builder> getStringParameters() {
            List<StringParameter.Builder> result = StringParameterListCopier.copyToBuilder(this.stringParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStringParameters(Collection<StringParameter.BuilderImpl> stringParameters) {
            this.stringParameters = StringParameterListCopier.copyFromBuilder(stringParameters);
        }

        @Override
        public final Builder stringParameters(Collection<StringParameter> stringParameters) {
            this.stringParameters = StringParameterListCopier.copy(stringParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringParameters(StringParameter ... stringParameters) {
            this.stringParameters(Arrays.asList(stringParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringParameters(Consumer<StringParameter.Builder> ... stringParameters) {
            this.stringParameters(Stream.of(stringParameters).map(c -> (StringParameter)((StringParameter.Builder)StringParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<IntegerParameter.Builder> getIntegerParameters() {
            List<IntegerParameter.Builder> result = IntegerParameterListCopier.copyToBuilder(this.integerParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIntegerParameters(Collection<IntegerParameter.BuilderImpl> integerParameters) {
            this.integerParameters = IntegerParameterListCopier.copyFromBuilder(integerParameters);
        }

        @Override
        public final Builder integerParameters(Collection<IntegerParameter> integerParameters) {
            this.integerParameters = IntegerParameterListCopier.copy(integerParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integerParameters(IntegerParameter ... integerParameters) {
            this.integerParameters(Arrays.asList(integerParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integerParameters(Consumer<IntegerParameter.Builder> ... integerParameters) {
            this.integerParameters(Stream.of(integerParameters).map(c -> (IntegerParameter)((IntegerParameter.Builder)IntegerParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DecimalParameter.Builder> getDecimalParameters() {
            List<DecimalParameter.Builder> result = DecimalParameterListCopier.copyToBuilder(this.decimalParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDecimalParameters(Collection<DecimalParameter.BuilderImpl> decimalParameters) {
            this.decimalParameters = DecimalParameterListCopier.copyFromBuilder(decimalParameters);
        }

        @Override
        public final Builder decimalParameters(Collection<DecimalParameter> decimalParameters) {
            this.decimalParameters = DecimalParameterListCopier.copy(decimalParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder decimalParameters(DecimalParameter ... decimalParameters) {
            this.decimalParameters(Arrays.asList(decimalParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder decimalParameters(Consumer<DecimalParameter.Builder> ... decimalParameters) {
            this.decimalParameters(Stream.of(decimalParameters).map(c -> (DecimalParameter)((DecimalParameter.Builder)DecimalParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DateTimeParameter.Builder> getDateTimeParameters() {
            List<DateTimeParameter.Builder> result = DateTimeParameterListCopier.copyToBuilder(this.dateTimeParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDateTimeParameters(Collection<DateTimeParameter.BuilderImpl> dateTimeParameters) {
            this.dateTimeParameters = DateTimeParameterListCopier.copyFromBuilder(dateTimeParameters);
        }

        @Override
        public final Builder dateTimeParameters(Collection<DateTimeParameter> dateTimeParameters) {
            this.dateTimeParameters = DateTimeParameterListCopier.copy(dateTimeParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dateTimeParameters(DateTimeParameter ... dateTimeParameters) {
            this.dateTimeParameters(Arrays.asList(dateTimeParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dateTimeParameters(Consumer<DateTimeParameter.Builder> ... dateTimeParameters) {
            this.dateTimeParameters(Stream.of(dateTimeParameters).map(c -> (DateTimeParameter)((DateTimeParameter.Builder)DateTimeParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Parameters build() {
            return new Parameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Parameters> {
        public Builder stringParameters(Collection<StringParameter> var1);

        public Builder stringParameters(StringParameter ... var1);

        public Builder stringParameters(Consumer<StringParameter.Builder> ... var1);

        public Builder integerParameters(Collection<IntegerParameter> var1);

        public Builder integerParameters(IntegerParameter ... var1);

        public Builder integerParameters(Consumer<IntegerParameter.Builder> ... var1);

        public Builder decimalParameters(Collection<DecimalParameter> var1);

        public Builder decimalParameters(DecimalParameter ... var1);

        public Builder decimalParameters(Consumer<DecimalParameter.Builder> ... var1);

        public Builder dateTimeParameters(Collection<DateTimeParameter> var1);

        public Builder dateTimeParameters(DateTimeParameter ... var1);

        public Builder dateTimeParameters(Consumer<DateTimeParameter.Builder> ... var1);
    }
}

