/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.VpcConnectionProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OAuthParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OAuthParameters> {
    private static final SdkField<String> TOKEN_PROVIDER_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TokenProviderUrl").getter(OAuthParameters.getter(OAuthParameters::tokenProviderUrl)).setter(OAuthParameters.setter(Builder::tokenProviderUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenProviderUrl").build()}).build();
    private static final SdkField<String> O_AUTH_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OAuthScope").getter(OAuthParameters.getter(OAuthParameters::oAuthScope)).setter(OAuthParameters.setter(Builder::oAuthScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OAuthScope").build()}).build();
    private static final SdkField<VpcConnectionProperties> IDENTITY_PROVIDER_VPC_CONNECTION_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IdentityProviderVpcConnectionProperties").getter(OAuthParameters.getter(OAuthParameters::identityProviderVpcConnectionProperties)).setter(OAuthParameters.setter(Builder::identityProviderVpcConnectionProperties)).constructor(VpcConnectionProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderVpcConnectionProperties").build()}).build();
    private static final SdkField<String> IDENTITY_PROVIDER_RESOURCE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityProviderResourceUri").getter(OAuthParameters.getter(OAuthParameters::identityProviderResourceUri)).setter(OAuthParameters.setter(Builder::identityProviderResourceUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderResourceUri").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOKEN_PROVIDER_URL_FIELD, O_AUTH_SCOPE_FIELD, IDENTITY_PROVIDER_VPC_CONNECTION_PROPERTIES_FIELD, IDENTITY_PROVIDER_RESOURCE_URI_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OAuthParameters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String tokenProviderUrl;
    private final String oAuthScope;
    private final VpcConnectionProperties identityProviderVpcConnectionProperties;
    private final String identityProviderResourceUri;

    private OAuthParameters(BuilderImpl builder) {
        this.tokenProviderUrl = builder.tokenProviderUrl;
        this.oAuthScope = builder.oAuthScope;
        this.identityProviderVpcConnectionProperties = builder.identityProviderVpcConnectionProperties;
        this.identityProviderResourceUri = builder.identityProviderResourceUri;
    }

    public final String tokenProviderUrl() {
        return this.tokenProviderUrl;
    }

    public final String oAuthScope() {
        return this.oAuthScope;
    }

    public final VpcConnectionProperties identityProviderVpcConnectionProperties() {
        return this.identityProviderVpcConnectionProperties;
    }

    public final String identityProviderResourceUri() {
        return this.identityProviderResourceUri;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenProviderUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.oAuthScope());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProviderVpcConnectionProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProviderResourceUri());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OAuthParameters)) {
            return false;
        }
        OAuthParameters other = (OAuthParameters)obj;
        return Objects.equals(this.tokenProviderUrl(), other.tokenProviderUrl()) && Objects.equals(this.oAuthScope(), other.oAuthScope()) && Objects.equals(this.identityProviderVpcConnectionProperties(), other.identityProviderVpcConnectionProperties()) && Objects.equals(this.identityProviderResourceUri(), other.identityProviderResourceUri());
    }

    public final String toString() {
        return ToString.builder((String)"OAuthParameters").add("TokenProviderUrl", (Object)this.tokenProviderUrl()).add("OAuthScope", (Object)this.oAuthScope()).add("IdentityProviderVpcConnectionProperties", (Object)this.identityProviderVpcConnectionProperties()).add("IdentityProviderResourceUri", (Object)this.identityProviderResourceUri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TokenProviderUrl": {
                return Optional.ofNullable(clazz.cast(this.tokenProviderUrl()));
            }
            case "OAuthScope": {
                return Optional.ofNullable(clazz.cast(this.oAuthScope()));
            }
            case "IdentityProviderVpcConnectionProperties": {
                return Optional.ofNullable(clazz.cast(this.identityProviderVpcConnectionProperties()));
            }
            case "IdentityProviderResourceUri": {
                return Optional.ofNullable(clazz.cast(this.identityProviderResourceUri()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TokenProviderUrl", TOKEN_PROVIDER_URL_FIELD);
        map.put("OAuthScope", O_AUTH_SCOPE_FIELD);
        map.put("IdentityProviderVpcConnectionProperties", IDENTITY_PROVIDER_VPC_CONNECTION_PROPERTIES_FIELD);
        map.put("IdentityProviderResourceUri", IDENTITY_PROVIDER_RESOURCE_URI_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OAuthParameters, T> g) {
        return obj -> g.apply((OAuthParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tokenProviderUrl;
        private String oAuthScope;
        private VpcConnectionProperties identityProviderVpcConnectionProperties;
        private String identityProviderResourceUri;

        private BuilderImpl() {
        }

        private BuilderImpl(OAuthParameters model) {
            this.tokenProviderUrl(model.tokenProviderUrl);
            this.oAuthScope(model.oAuthScope);
            this.identityProviderVpcConnectionProperties(model.identityProviderVpcConnectionProperties);
            this.identityProviderResourceUri(model.identityProviderResourceUri);
        }

        public final String getTokenProviderUrl() {
            return this.tokenProviderUrl;
        }

        public final void setTokenProviderUrl(String tokenProviderUrl) {
            this.tokenProviderUrl = tokenProviderUrl;
        }

        @Override
        public final Builder tokenProviderUrl(String tokenProviderUrl) {
            this.tokenProviderUrl = tokenProviderUrl;
            return this;
        }

        public final String getOAuthScope() {
            return this.oAuthScope;
        }

        public final void setOAuthScope(String oAuthScope) {
            this.oAuthScope = oAuthScope;
        }

        @Override
        public final Builder oAuthScope(String oAuthScope) {
            this.oAuthScope = oAuthScope;
            return this;
        }

        public final VpcConnectionProperties.Builder getIdentityProviderVpcConnectionProperties() {
            return this.identityProviderVpcConnectionProperties != null ? this.identityProviderVpcConnectionProperties.toBuilder() : null;
        }

        public final void setIdentityProviderVpcConnectionProperties(VpcConnectionProperties.BuilderImpl identityProviderVpcConnectionProperties) {
            this.identityProviderVpcConnectionProperties = identityProviderVpcConnectionProperties != null ? identityProviderVpcConnectionProperties.build() : null;
        }

        @Override
        public final Builder identityProviderVpcConnectionProperties(VpcConnectionProperties identityProviderVpcConnectionProperties) {
            this.identityProviderVpcConnectionProperties = identityProviderVpcConnectionProperties;
            return this;
        }

        public final String getIdentityProviderResourceUri() {
            return this.identityProviderResourceUri;
        }

        public final void setIdentityProviderResourceUri(String identityProviderResourceUri) {
            this.identityProviderResourceUri = identityProviderResourceUri;
        }

        @Override
        public final Builder identityProviderResourceUri(String identityProviderResourceUri) {
            this.identityProviderResourceUri = identityProviderResourceUri;
            return this;
        }

        public OAuthParameters build() {
            return new OAuthParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OAuthParameters> {
        public Builder tokenProviderUrl(String var1);

        public Builder oAuthScope(String var1);

        public Builder identityProviderVpcConnectionProperties(VpcConnectionProperties var1);

        default public Builder identityProviderVpcConnectionProperties(Consumer<VpcConnectionProperties.Builder> identityProviderVpcConnectionProperties) {
            return this.identityProviderVpcConnectionProperties((VpcConnectionProperties)((VpcConnectionProperties.Builder)VpcConnectionProperties.builder().applyMutation(identityProviderVpcConnectionProperties)).build());
        }

        public Builder identityProviderResourceUri(String var1);
    }
}

