/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.services.quicksight.model.RegisteredUserEmbeddingExperienceConfiguration;
import software.amazon.awssdk.services.quicksight.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GenerateEmbedUrlForRegisteredUserRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, GenerateEmbedUrlForRegisteredUserRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(GenerateEmbedUrlForRegisteredUserRequest.getter(GenerateEmbedUrlForRegisteredUserRequest::awsAccountId)).setter(GenerateEmbedUrlForRegisteredUserRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<Long> SESSION_LIFETIME_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("SessionLifetimeInMinutes").getter(GenerateEmbedUrlForRegisteredUserRequest.getter(GenerateEmbedUrlForRegisteredUserRequest::sessionLifetimeInMinutes)).setter(GenerateEmbedUrlForRegisteredUserRequest.setter(Builder::sessionLifetimeInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionLifetimeInMinutes").build()}).build();
    private static final SdkField<String> USER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserArn").getter(GenerateEmbedUrlForRegisteredUserRequest.getter(GenerateEmbedUrlForRegisteredUserRequest::userArn)).setter(GenerateEmbedUrlForRegisteredUserRequest.setter(Builder::userArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserArn").build()}).build();
    private static final SdkField<RegisteredUserEmbeddingExperienceConfiguration> EXPERIENCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExperienceConfiguration").getter(GenerateEmbedUrlForRegisteredUserRequest.getter(GenerateEmbedUrlForRegisteredUserRequest::experienceConfiguration)).setter(GenerateEmbedUrlForRegisteredUserRequest.setter(Builder::experienceConfiguration)).constructor(RegisteredUserEmbeddingExperienceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExperienceConfiguration").build()}).build();
    private static final SdkField<List<String>> ALLOWED_DOMAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowedDomains").getter(GenerateEmbedUrlForRegisteredUserRequest.getter(GenerateEmbedUrlForRegisteredUserRequest::allowedDomains)).setter(GenerateEmbedUrlForRegisteredUserRequest.setter(Builder::allowedDomains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedDomains").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, SESSION_LIFETIME_IN_MINUTES_FIELD, USER_ARN_FIELD, EXPERIENCE_CONFIGURATION_FIELD, ALLOWED_DOMAINS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GenerateEmbedUrlForRegisteredUserRequest.memberNameToFieldInitializer();
    private final String awsAccountId;
    private final Long sessionLifetimeInMinutes;
    private final String userArn;
    private final RegisteredUserEmbeddingExperienceConfiguration experienceConfiguration;
    private final List<String> allowedDomains;

    private GenerateEmbedUrlForRegisteredUserRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.sessionLifetimeInMinutes = builder.sessionLifetimeInMinutes;
        this.userArn = builder.userArn;
        this.experienceConfiguration = builder.experienceConfiguration;
        this.allowedDomains = builder.allowedDomains;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final Long sessionLifetimeInMinutes() {
        return this.sessionLifetimeInMinutes;
    }

    public final String userArn() {
        return this.userArn;
    }

    public final RegisteredUserEmbeddingExperienceConfiguration experienceConfiguration() {
        return this.experienceConfiguration;
    }

    public final boolean hasAllowedDomains() {
        return this.allowedDomains != null && !(this.allowedDomains instanceof SdkAutoConstructList);
    }

    public final List<String> allowedDomains() {
        return this.allowedDomains;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionLifetimeInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.userArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.experienceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedDomains() ? this.allowedDomains() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateEmbedUrlForRegisteredUserRequest)) {
            return false;
        }
        GenerateEmbedUrlForRegisteredUserRequest other = (GenerateEmbedUrlForRegisteredUserRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.sessionLifetimeInMinutes(), other.sessionLifetimeInMinutes()) && Objects.equals(this.userArn(), other.userArn()) && Objects.equals(this.experienceConfiguration(), other.experienceConfiguration()) && this.hasAllowedDomains() == other.hasAllowedDomains() && Objects.equals(this.allowedDomains(), other.allowedDomains());
    }

    public final String toString() {
        return ToString.builder((String)"GenerateEmbedUrlForRegisteredUserRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("SessionLifetimeInMinutes", (Object)this.sessionLifetimeInMinutes()).add("UserArn", (Object)this.userArn()).add("ExperienceConfiguration", (Object)this.experienceConfiguration()).add("AllowedDomains", this.hasAllowedDomains() ? this.allowedDomains() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "SessionLifetimeInMinutes": {
                return Optional.ofNullable(clazz.cast(this.sessionLifetimeInMinutes()));
            }
            case "UserArn": {
                return Optional.ofNullable(clazz.cast(this.userArn()));
            }
            case "ExperienceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.experienceConfiguration()));
            }
            case "AllowedDomains": {
                return Optional.ofNullable(clazz.cast(this.allowedDomains()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("SessionLifetimeInMinutes", SESSION_LIFETIME_IN_MINUTES_FIELD);
        map.put("UserArn", USER_ARN_FIELD);
        map.put("ExperienceConfiguration", EXPERIENCE_CONFIGURATION_FIELD);
        map.put("AllowedDomains", ALLOWED_DOMAINS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GenerateEmbedUrlForRegisteredUserRequest, T> g) {
        return obj -> g.apply((GenerateEmbedUrlForRegisteredUserRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private Long sessionLifetimeInMinutes;
        private String userArn;
        private RegisteredUserEmbeddingExperienceConfiguration experienceConfiguration;
        private List<String> allowedDomains = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateEmbedUrlForRegisteredUserRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.sessionLifetimeInMinutes(model.sessionLifetimeInMinutes);
            this.userArn(model.userArn);
            this.experienceConfiguration(model.experienceConfiguration);
            this.allowedDomains(model.allowedDomains);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final Long getSessionLifetimeInMinutes() {
            return this.sessionLifetimeInMinutes;
        }

        public final void setSessionLifetimeInMinutes(Long sessionLifetimeInMinutes) {
            this.sessionLifetimeInMinutes = sessionLifetimeInMinutes;
        }

        @Override
        public final Builder sessionLifetimeInMinutes(Long sessionLifetimeInMinutes) {
            this.sessionLifetimeInMinutes = sessionLifetimeInMinutes;
            return this;
        }

        public final String getUserArn() {
            return this.userArn;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        @Override
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final RegisteredUserEmbeddingExperienceConfiguration.Builder getExperienceConfiguration() {
            return this.experienceConfiguration != null ? this.experienceConfiguration.toBuilder() : null;
        }

        public final void setExperienceConfiguration(RegisteredUserEmbeddingExperienceConfiguration.BuilderImpl experienceConfiguration) {
            this.experienceConfiguration = experienceConfiguration != null ? experienceConfiguration.build() : null;
        }

        @Override
        public final Builder experienceConfiguration(RegisteredUserEmbeddingExperienceConfiguration experienceConfiguration) {
            this.experienceConfiguration = experienceConfiguration;
            return this;
        }

        public final Collection<String> getAllowedDomains() {
            if (this.allowedDomains instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedDomains;
        }

        public final void setAllowedDomains(Collection<String> allowedDomains) {
            this.allowedDomains = StringListCopier.copy(allowedDomains);
        }

        @Override
        public final Builder allowedDomains(Collection<String> allowedDomains) {
            this.allowedDomains = StringListCopier.copy(allowedDomains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedDomains(String ... allowedDomains) {
            this.allowedDomains(Arrays.asList(allowedDomains));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GenerateEmbedUrlForRegisteredUserRequest build() {
            return new GenerateEmbedUrlForRegisteredUserRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GenerateEmbedUrlForRegisteredUserRequest> {
        public Builder awsAccountId(String var1);

        public Builder sessionLifetimeInMinutes(Long var1);

        public Builder userArn(String var1);

        public Builder experienceConfiguration(RegisteredUserEmbeddingExperienceConfiguration var1);

        default public Builder experienceConfiguration(Consumer<RegisteredUserEmbeddingExperienceConfiguration.Builder> experienceConfiguration) {
            return this.experienceConfiguration((RegisteredUserEmbeddingExperienceConfiguration)((RegisteredUserEmbeddingExperienceConfiguration.Builder)RegisteredUserEmbeddingExperienceConfiguration.builder().applyMutation(experienceConfiguration)).build());
        }

        public Builder allowedDomains(Collection<String> var1);

        public Builder allowedDomains(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

