/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.DigitGroupingStyle;
import software.amazon.awssdk.services.quicksight.model.NumericSeparatorSymbol;
import software.amazon.awssdk.services.quicksight.model.Visibility;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ThousandSeparatorOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ThousandSeparatorOptions> {
    private static final SdkField<String> SYMBOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Symbol").getter(ThousandSeparatorOptions.getter(ThousandSeparatorOptions::symbolAsString)).setter(ThousandSeparatorOptions.setter(Builder::symbol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Symbol").build()}).build();
    private static final SdkField<String> VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Visibility").getter(ThousandSeparatorOptions.getter(ThousandSeparatorOptions::visibilityAsString)).setter(ThousandSeparatorOptions.setter(Builder::visibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()}).build();
    private static final SdkField<String> GROUPING_STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupingStyle").getter(ThousandSeparatorOptions.getter(ThousandSeparatorOptions::groupingStyleAsString)).setter(ThousandSeparatorOptions.setter(Builder::groupingStyle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupingStyle").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SYMBOL_FIELD, VISIBILITY_FIELD, GROUPING_STYLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ThousandSeparatorOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String symbol;
    private final String visibility;
    private final String groupingStyle;

    private ThousandSeparatorOptions(BuilderImpl builder) {
        this.symbol = builder.symbol;
        this.visibility = builder.visibility;
        this.groupingStyle = builder.groupingStyle;
    }

    public final NumericSeparatorSymbol symbol() {
        return NumericSeparatorSymbol.fromValue(this.symbol);
    }

    public final String symbolAsString() {
        return this.symbol;
    }

    public final Visibility visibility() {
        return Visibility.fromValue(this.visibility);
    }

    public final String visibilityAsString() {
        return this.visibility;
    }

    public final DigitGroupingStyle groupingStyle() {
        return DigitGroupingStyle.fromValue(this.groupingStyle);
    }

    public final String groupingStyleAsString() {
        return this.groupingStyle;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.symbolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupingStyleAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThousandSeparatorOptions)) {
            return false;
        }
        ThousandSeparatorOptions other = (ThousandSeparatorOptions)obj;
        return Objects.equals(this.symbolAsString(), other.symbolAsString()) && Objects.equals(this.visibilityAsString(), other.visibilityAsString()) && Objects.equals(this.groupingStyleAsString(), other.groupingStyleAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ThousandSeparatorOptions").add("Symbol", (Object)this.symbolAsString()).add("Visibility", (Object)this.visibilityAsString()).add("GroupingStyle", (Object)this.groupingStyleAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Symbol": {
                return Optional.ofNullable(clazz.cast(this.symbolAsString()));
            }
            case "Visibility": {
                return Optional.ofNullable(clazz.cast(this.visibilityAsString()));
            }
            case "GroupingStyle": {
                return Optional.ofNullable(clazz.cast(this.groupingStyleAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Symbol", SYMBOL_FIELD);
        map.put("Visibility", VISIBILITY_FIELD);
        map.put("GroupingStyle", GROUPING_STYLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ThousandSeparatorOptions, T> g) {
        return obj -> g.apply((ThousandSeparatorOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String symbol;
        private String visibility;
        private String groupingStyle;

        private BuilderImpl() {
        }

        private BuilderImpl(ThousandSeparatorOptions model) {
            this.symbol(model.symbol);
            this.visibility(model.visibility);
            this.groupingStyle(model.groupingStyle);
        }

        public final String getSymbol() {
            return this.symbol;
        }

        public final void setSymbol(String symbol) {
            this.symbol = symbol;
        }

        @Override
        public final Builder symbol(String symbol) {
            this.symbol = symbol;
            return this;
        }

        @Override
        public final Builder symbol(NumericSeparatorSymbol symbol) {
            this.symbol(symbol == null ? null : symbol.toString());
            return this;
        }

        public final String getVisibility() {
            return this.visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final String getGroupingStyle() {
            return this.groupingStyle;
        }

        public final void setGroupingStyle(String groupingStyle) {
            this.groupingStyle = groupingStyle;
        }

        @Override
        public final Builder groupingStyle(String groupingStyle) {
            this.groupingStyle = groupingStyle;
            return this;
        }

        @Override
        public final Builder groupingStyle(DigitGroupingStyle groupingStyle) {
            this.groupingStyle(groupingStyle == null ? null : groupingStyle.toString());
            return this;
        }

        public ThousandSeparatorOptions build() {
            return new ThousandSeparatorOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ThousandSeparatorOptions> {
        public Builder symbol(String var1);

        public Builder symbol(NumericSeparatorSymbol var1);

        public Builder visibility(String var1);

        public Builder visibility(Visibility var1);

        public Builder groupingStyle(String var1);

        public Builder groupingStyle(DigitGroupingStyle var1);
    }
}

