/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobSummary;
import software.amazon.awssdk.services.quicksight.model.ListAssetBundleExportJobsRequest;
import software.amazon.awssdk.services.quicksight.model.ListAssetBundleExportJobsResponse;

public class ListAssetBundleExportJobsIterable
implements SdkIterable<ListAssetBundleExportJobsResponse> {
    private final QuickSightClient client;
    private final ListAssetBundleExportJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAssetBundleExportJobsIterable(QuickSightClient client, ListAssetBundleExportJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAssetBundleExportJobsResponseFetcher();
    }

    public Iterator<ListAssetBundleExportJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AssetBundleExportJobSummary> assetBundleExportJobSummaryList() {
        Function<ListAssetBundleExportJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.assetBundleExportJobSummaryList() != null) {
                return response.assetBundleExportJobSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAssetBundleExportJobsResponseFetcher
    implements SyncPageFetcher<ListAssetBundleExportJobsResponse> {
        private ListAssetBundleExportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssetBundleExportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAssetBundleExportJobsResponse nextPage(ListAssetBundleExportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListAssetBundleExportJobsIterable.this.client.listAssetBundleExportJobs(ListAssetBundleExportJobsIterable.this.firstRequest);
            }
            return ListAssetBundleExportJobsIterable.this.client.listAssetBundleExportJobs((ListAssetBundleExportJobsRequest)((Object)ListAssetBundleExportJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

