/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.RowAlternateColorListCopier;
import software.amazon.awssdk.services.quicksight.model.WidgetStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RowAlternateColorOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RowAlternateColorOptions> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(RowAlternateColorOptions.getter(RowAlternateColorOptions::statusAsString)).setter(RowAlternateColorOptions.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<String>> ROW_ALTERNATE_COLORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RowAlternateColors").getter(RowAlternateColorOptions.getter(RowAlternateColorOptions::rowAlternateColors)).setter(RowAlternateColorOptions.setter(Builder::rowAlternateColors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowAlternateColors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> USE_PRIMARY_BACKGROUND_COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UsePrimaryBackgroundColor").getter(RowAlternateColorOptions.getter(RowAlternateColorOptions::usePrimaryBackgroundColorAsString)).setter(RowAlternateColorOptions.setter(Builder::usePrimaryBackgroundColor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsePrimaryBackgroundColor").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, ROW_ALTERNATE_COLORS_FIELD, USE_PRIMARY_BACKGROUND_COLOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RowAlternateColorOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String status;
    private final List<String> rowAlternateColors;
    private final String usePrimaryBackgroundColor;

    private RowAlternateColorOptions(BuilderImpl builder) {
        this.status = builder.status;
        this.rowAlternateColors = builder.rowAlternateColors;
        this.usePrimaryBackgroundColor = builder.usePrimaryBackgroundColor;
    }

    public final WidgetStatus status() {
        return WidgetStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasRowAlternateColors() {
        return this.rowAlternateColors != null && !(this.rowAlternateColors instanceof SdkAutoConstructList);
    }

    public final List<String> rowAlternateColors() {
        return this.rowAlternateColors;
    }

    public final WidgetStatus usePrimaryBackgroundColor() {
        return WidgetStatus.fromValue(this.usePrimaryBackgroundColor);
    }

    public final String usePrimaryBackgroundColorAsString() {
        return this.usePrimaryBackgroundColor;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRowAlternateColors() ? this.rowAlternateColors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.usePrimaryBackgroundColorAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RowAlternateColorOptions)) {
            return false;
        }
        RowAlternateColorOptions other = (RowAlternateColorOptions)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasRowAlternateColors() == other.hasRowAlternateColors() && Objects.equals(this.rowAlternateColors(), other.rowAlternateColors()) && Objects.equals(this.usePrimaryBackgroundColorAsString(), other.usePrimaryBackgroundColorAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RowAlternateColorOptions").add("Status", (Object)this.statusAsString()).add("RowAlternateColors", this.hasRowAlternateColors() ? this.rowAlternateColors() : null).add("UsePrimaryBackgroundColor", (Object)this.usePrimaryBackgroundColorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "RowAlternateColors": {
                return Optional.ofNullable(clazz.cast(this.rowAlternateColors()));
            }
            case "UsePrimaryBackgroundColor": {
                return Optional.ofNullable(clazz.cast(this.usePrimaryBackgroundColorAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Status", STATUS_FIELD);
        map.put("RowAlternateColors", ROW_ALTERNATE_COLORS_FIELD);
        map.put("UsePrimaryBackgroundColor", USE_PRIMARY_BACKGROUND_COLOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RowAlternateColorOptions, T> g) {
        return obj -> g.apply((RowAlternateColorOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private List<String> rowAlternateColors = DefaultSdkAutoConstructList.getInstance();
        private String usePrimaryBackgroundColor;

        private BuilderImpl() {
        }

        private BuilderImpl(RowAlternateColorOptions model) {
            this.status(model.status);
            this.rowAlternateColors(model.rowAlternateColors);
            this.usePrimaryBackgroundColor(model.usePrimaryBackgroundColor);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WidgetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getRowAlternateColors() {
            if (this.rowAlternateColors instanceof SdkAutoConstructList) {
                return null;
            }
            return this.rowAlternateColors;
        }

        public final void setRowAlternateColors(Collection<String> rowAlternateColors) {
            this.rowAlternateColors = RowAlternateColorListCopier.copy(rowAlternateColors);
        }

        @Override
        public final Builder rowAlternateColors(Collection<String> rowAlternateColors) {
            this.rowAlternateColors = RowAlternateColorListCopier.copy(rowAlternateColors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rowAlternateColors(String ... rowAlternateColors) {
            this.rowAlternateColors(Arrays.asList(rowAlternateColors));
            return this;
        }

        public final String getUsePrimaryBackgroundColor() {
            return this.usePrimaryBackgroundColor;
        }

        public final void setUsePrimaryBackgroundColor(String usePrimaryBackgroundColor) {
            this.usePrimaryBackgroundColor = usePrimaryBackgroundColor;
        }

        @Override
        public final Builder usePrimaryBackgroundColor(String usePrimaryBackgroundColor) {
            this.usePrimaryBackgroundColor = usePrimaryBackgroundColor;
            return this;
        }

        @Override
        public final Builder usePrimaryBackgroundColor(WidgetStatus usePrimaryBackgroundColor) {
            this.usePrimaryBackgroundColor(usePrimaryBackgroundColor == null ? null : usePrimaryBackgroundColor.toString());
            return this;
        }

        public RowAlternateColorOptions build() {
            return new RowAlternateColorOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RowAlternateColorOptions> {
        public Builder status(String var1);

        public Builder status(WidgetStatus var1);

        public Builder rowAlternateColors(Collection<String> var1);

        public Builder rowAlternateColors(String ... var1);

        public Builder usePrimaryBackgroundColor(String var1);

        public Builder usePrimaryBackgroundColor(WidgetStatus var1);
    }
}

