/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ThemeErrorType {
    INTERNAL_FAILURE("INTERNAL_FAILURE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ThemeErrorType> VALUE_MAP;
    private final String value;

    private ThemeErrorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ThemeErrorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ThemeErrorType> knownValues() {
        EnumSet<ThemeErrorType> knownValues = EnumSet.allOf(ThemeErrorType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ThemeErrorType.class, ThemeErrorType::toString);
    }
}

