/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.GeospatialLineLayer;
import software.amazon.awssdk.services.quicksight.model.GeospatialPointLayer;
import software.amazon.awssdk.services.quicksight.model.GeospatialPolygonLayer;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GeospatialLayerDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GeospatialLayerDefinition> {
    private static final SdkField<GeospatialPointLayer> POINT_LAYER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PointLayer").getter(GeospatialLayerDefinition.getter(GeospatialLayerDefinition::pointLayer)).setter(GeospatialLayerDefinition.setter(Builder::pointLayer)).constructor(GeospatialPointLayer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PointLayer").build()}).build();
    private static final SdkField<GeospatialLineLayer> LINE_LAYER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LineLayer").getter(GeospatialLayerDefinition.getter(GeospatialLayerDefinition::lineLayer)).setter(GeospatialLayerDefinition.setter(Builder::lineLayer)).constructor(GeospatialLineLayer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineLayer").build()}).build();
    private static final SdkField<GeospatialPolygonLayer> POLYGON_LAYER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PolygonLayer").getter(GeospatialLayerDefinition.getter(GeospatialLayerDefinition::polygonLayer)).setter(GeospatialLayerDefinition.setter(Builder::polygonLayer)).constructor(GeospatialPolygonLayer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolygonLayer").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POINT_LAYER_FIELD, LINE_LAYER_FIELD, POLYGON_LAYER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GeospatialLayerDefinition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final GeospatialPointLayer pointLayer;
    private final GeospatialLineLayer lineLayer;
    private final GeospatialPolygonLayer polygonLayer;

    private GeospatialLayerDefinition(BuilderImpl builder) {
        this.pointLayer = builder.pointLayer;
        this.lineLayer = builder.lineLayer;
        this.polygonLayer = builder.polygonLayer;
    }

    public final GeospatialPointLayer pointLayer() {
        return this.pointLayer;
    }

    public final GeospatialLineLayer lineLayer() {
        return this.lineLayer;
    }

    public final GeospatialPolygonLayer polygonLayer() {
        return this.polygonLayer;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pointLayer());
        hashCode = 31 * hashCode + Objects.hashCode(this.lineLayer());
        hashCode = 31 * hashCode + Objects.hashCode(this.polygonLayer());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeospatialLayerDefinition)) {
            return false;
        }
        GeospatialLayerDefinition other = (GeospatialLayerDefinition)obj;
        return Objects.equals(this.pointLayer(), other.pointLayer()) && Objects.equals(this.lineLayer(), other.lineLayer()) && Objects.equals(this.polygonLayer(), other.polygonLayer());
    }

    public final String toString() {
        return ToString.builder((String)"GeospatialLayerDefinition").add("PointLayer", (Object)this.pointLayer()).add("LineLayer", (Object)this.lineLayer()).add("PolygonLayer", (Object)this.polygonLayer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PointLayer": {
                return Optional.ofNullable(clazz.cast(this.pointLayer()));
            }
            case "LineLayer": {
                return Optional.ofNullable(clazz.cast(this.lineLayer()));
            }
            case "PolygonLayer": {
                return Optional.ofNullable(clazz.cast(this.polygonLayer()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PointLayer", POINT_LAYER_FIELD);
        map.put("LineLayer", LINE_LAYER_FIELD);
        map.put("PolygonLayer", POLYGON_LAYER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeospatialLayerDefinition, T> g) {
        return obj -> g.apply((GeospatialLayerDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private GeospatialPointLayer pointLayer;
        private GeospatialLineLayer lineLayer;
        private GeospatialPolygonLayer polygonLayer;

        private BuilderImpl() {
        }

        private BuilderImpl(GeospatialLayerDefinition model) {
            this.pointLayer(model.pointLayer);
            this.lineLayer(model.lineLayer);
            this.polygonLayer(model.polygonLayer);
        }

        public final GeospatialPointLayer.Builder getPointLayer() {
            return this.pointLayer != null ? this.pointLayer.toBuilder() : null;
        }

        public final void setPointLayer(GeospatialPointLayer.BuilderImpl pointLayer) {
            this.pointLayer = pointLayer != null ? pointLayer.build() : null;
        }

        @Override
        public final Builder pointLayer(GeospatialPointLayer pointLayer) {
            this.pointLayer = pointLayer;
            return this;
        }

        public final GeospatialLineLayer.Builder getLineLayer() {
            return this.lineLayer != null ? this.lineLayer.toBuilder() : null;
        }

        public final void setLineLayer(GeospatialLineLayer.BuilderImpl lineLayer) {
            this.lineLayer = lineLayer != null ? lineLayer.build() : null;
        }

        @Override
        public final Builder lineLayer(GeospatialLineLayer lineLayer) {
            this.lineLayer = lineLayer;
            return this;
        }

        public final GeospatialPolygonLayer.Builder getPolygonLayer() {
            return this.polygonLayer != null ? this.polygonLayer.toBuilder() : null;
        }

        public final void setPolygonLayer(GeospatialPolygonLayer.BuilderImpl polygonLayer) {
            this.polygonLayer = polygonLayer != null ? polygonLayer.build() : null;
        }

        @Override
        public final Builder polygonLayer(GeospatialPolygonLayer polygonLayer) {
            this.polygonLayer = polygonLayer;
            return this;
        }

        public GeospatialLayerDefinition build() {
            return new GeospatialLayerDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GeospatialLayerDefinition> {
        public Builder pointLayer(GeospatialPointLayer var1);

        default public Builder pointLayer(Consumer<GeospatialPointLayer.Builder> pointLayer) {
            return this.pointLayer((GeospatialPointLayer)((GeospatialPointLayer.Builder)GeospatialPointLayer.builder().applyMutation(pointLayer)).build());
        }

        public Builder lineLayer(GeospatialLineLayer var1);

        default public Builder lineLayer(Consumer<GeospatialLineLayer.Builder> lineLayer) {
            return this.lineLayer((GeospatialLineLayer)((GeospatialLineLayer.Builder)GeospatialLineLayer.builder().applyMutation(lineLayer)).build());
        }

        public Builder polygonLayer(GeospatialPolygonLayer var1);

        default public Builder polygonLayer(Consumer<GeospatialPolygonLayer.Builder> polygonLayer) {
            return this.polygonLayer((GeospatialPolygonLayer)((GeospatialPolygonLayer.Builder)GeospatialPolygonLayer.builder().applyMutation(polygonLayer)).build());
        }
    }
}

