/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.InvalidTopicReviewedAnswer;
import software.amazon.awssdk.services.quicksight.model.InvalidTopicReviewedAnswersCopier;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.services.quicksight.model.SucceededTopicReviewedAnswer;
import software.amazon.awssdk.services.quicksight.model.SucceededTopicReviewedAnswersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteTopicReviewedAnswerResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, BatchDeleteTopicReviewedAnswerResponse> {
    private static final SdkField<String> TOPIC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TopicId").getter(BatchDeleteTopicReviewedAnswerResponse.getter(BatchDeleteTopicReviewedAnswerResponse::topicId)).setter(BatchDeleteTopicReviewedAnswerResponse.setter(Builder::topicId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicId").build()}).build();
    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TopicArn").getter(BatchDeleteTopicReviewedAnswerResponse.getter(BatchDeleteTopicReviewedAnswerResponse::topicArn)).setter(BatchDeleteTopicReviewedAnswerResponse.setter(Builder::topicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicArn").build()}).build();
    private static final SdkField<List<SucceededTopicReviewedAnswer>> SUCCEEDED_ANSWERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SucceededAnswers").getter(BatchDeleteTopicReviewedAnswerResponse.getter(BatchDeleteTopicReviewedAnswerResponse::succeededAnswers)).setter(BatchDeleteTopicReviewedAnswerResponse.setter(Builder::succeededAnswers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SucceededAnswers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SucceededTopicReviewedAnswer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<InvalidTopicReviewedAnswer>> INVALID_ANSWERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InvalidAnswers").getter(BatchDeleteTopicReviewedAnswerResponse.getter(BatchDeleteTopicReviewedAnswerResponse::invalidAnswers)).setter(BatchDeleteTopicReviewedAnswerResponse.setter(Builder::invalidAnswers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvalidAnswers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InvalidTopicReviewedAnswer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(BatchDeleteTopicReviewedAnswerResponse.getter(BatchDeleteTopicReviewedAnswerResponse::requestId)).setter(BatchDeleteTopicReviewedAnswerResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(BatchDeleteTopicReviewedAnswerResponse.getter(BatchDeleteTopicReviewedAnswerResponse::status)).setter(BatchDeleteTopicReviewedAnswerResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_ID_FIELD, TOPIC_ARN_FIELD, SUCCEEDED_ANSWERS_FIELD, INVALID_ANSWERS_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchDeleteTopicReviewedAnswerResponse.memberNameToFieldInitializer();
    private final String topicId;
    private final String topicArn;
    private final List<SucceededTopicReviewedAnswer> succeededAnswers;
    private final List<InvalidTopicReviewedAnswer> invalidAnswers;
    private final String requestId;
    private final Integer status;

    private BatchDeleteTopicReviewedAnswerResponse(BuilderImpl builder) {
        super(builder);
        this.topicId = builder.topicId;
        this.topicArn = builder.topicArn;
        this.succeededAnswers = builder.succeededAnswers;
        this.invalidAnswers = builder.invalidAnswers;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    public final String topicId() {
        return this.topicId;
    }

    public final String topicArn() {
        return this.topicArn;
    }

    public final boolean hasSucceededAnswers() {
        return this.succeededAnswers != null && !(this.succeededAnswers instanceof SdkAutoConstructList);
    }

    public final List<SucceededTopicReviewedAnswer> succeededAnswers() {
        return this.succeededAnswers;
    }

    public final boolean hasInvalidAnswers() {
        return this.invalidAnswers != null && !(this.invalidAnswers instanceof SdkAutoConstructList);
    }

    public final List<InvalidTopicReviewedAnswer> invalidAnswers() {
        return this.invalidAnswers;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final Integer status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.topicId());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSucceededAnswers() ? this.succeededAnswers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInvalidAnswers() ? this.invalidAnswers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteTopicReviewedAnswerResponse)) {
            return false;
        }
        BatchDeleteTopicReviewedAnswerResponse other = (BatchDeleteTopicReviewedAnswerResponse)((Object)obj);
        return Objects.equals(this.topicId(), other.topicId()) && Objects.equals(this.topicArn(), other.topicArn()) && this.hasSucceededAnswers() == other.hasSucceededAnswers() && Objects.equals(this.succeededAnswers(), other.succeededAnswers()) && this.hasInvalidAnswers() == other.hasInvalidAnswers() && Objects.equals(this.invalidAnswers(), other.invalidAnswers()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDeleteTopicReviewedAnswerResponse").add("TopicId", (Object)this.topicId()).add("TopicArn", (Object)this.topicArn()).add("SucceededAnswers", this.hasSucceededAnswers() ? this.succeededAnswers() : null).add("InvalidAnswers", this.hasInvalidAnswers() ? this.invalidAnswers() : null).add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TopicId": {
                return Optional.ofNullable(clazz.cast(this.topicId()));
            }
            case "TopicArn": {
                return Optional.ofNullable(clazz.cast(this.topicArn()));
            }
            case "SucceededAnswers": {
                return Optional.ofNullable(clazz.cast(this.succeededAnswers()));
            }
            case "InvalidAnswers": {
                return Optional.ofNullable(clazz.cast(this.invalidAnswers()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TopicId", TOPIC_ID_FIELD);
        map.put("TopicArn", TOPIC_ARN_FIELD);
        map.put("SucceededAnswers", SUCCEEDED_ANSWERS_FIELD);
        map.put("InvalidAnswers", INVALID_ANSWERS_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteTopicReviewedAnswerResponse, T> g) {
        return obj -> g.apply((BatchDeleteTopicReviewedAnswerResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private String topicId;
        private String topicArn;
        private List<SucceededTopicReviewedAnswer> succeededAnswers = DefaultSdkAutoConstructList.getInstance();
        private List<InvalidTopicReviewedAnswer> invalidAnswers = DefaultSdkAutoConstructList.getInstance();
        private String requestId;
        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteTopicReviewedAnswerResponse model) {
            super(model);
            this.topicId(model.topicId);
            this.topicArn(model.topicArn);
            this.succeededAnswers(model.succeededAnswers);
            this.invalidAnswers(model.invalidAnswers);
            this.requestId(model.requestId);
            this.status(model.status);
        }

        public final String getTopicId() {
            return this.topicId;
        }

        public final void setTopicId(String topicId) {
            this.topicId = topicId;
        }

        @Override
        public final Builder topicId(String topicId) {
            this.topicId = topicId;
            return this;
        }

        public final String getTopicArn() {
            return this.topicArn;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final List<SucceededTopicReviewedAnswer.Builder> getSucceededAnswers() {
            List<SucceededTopicReviewedAnswer.Builder> result = SucceededTopicReviewedAnswersCopier.copyToBuilder(this.succeededAnswers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSucceededAnswers(Collection<SucceededTopicReviewedAnswer.BuilderImpl> succeededAnswers) {
            this.succeededAnswers = SucceededTopicReviewedAnswersCopier.copyFromBuilder(succeededAnswers);
        }

        @Override
        public final Builder succeededAnswers(Collection<SucceededTopicReviewedAnswer> succeededAnswers) {
            this.succeededAnswers = SucceededTopicReviewedAnswersCopier.copy(succeededAnswers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder succeededAnswers(SucceededTopicReviewedAnswer ... succeededAnswers) {
            this.succeededAnswers(Arrays.asList(succeededAnswers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder succeededAnswers(Consumer<SucceededTopicReviewedAnswer.Builder> ... succeededAnswers) {
            this.succeededAnswers(Stream.of(succeededAnswers).map(c -> (SucceededTopicReviewedAnswer)((SucceededTopicReviewedAnswer.Builder)SucceededTopicReviewedAnswer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<InvalidTopicReviewedAnswer.Builder> getInvalidAnswers() {
            List<InvalidTopicReviewedAnswer.Builder> result = InvalidTopicReviewedAnswersCopier.copyToBuilder(this.invalidAnswers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInvalidAnswers(Collection<InvalidTopicReviewedAnswer.BuilderImpl> invalidAnswers) {
            this.invalidAnswers = InvalidTopicReviewedAnswersCopier.copyFromBuilder(invalidAnswers);
        }

        @Override
        public final Builder invalidAnswers(Collection<InvalidTopicReviewedAnswer> invalidAnswers) {
            this.invalidAnswers = InvalidTopicReviewedAnswersCopier.copy(invalidAnswers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invalidAnswers(InvalidTopicReviewedAnswer ... invalidAnswers) {
            this.invalidAnswers(Arrays.asList(invalidAnswers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invalidAnswers(Consumer<InvalidTopicReviewedAnswer.Builder> ... invalidAnswers) {
            this.invalidAnswers(Stream.of(invalidAnswers).map(c -> (InvalidTopicReviewedAnswer)((InvalidTopicReviewedAnswer.Builder)InvalidTopicReviewedAnswer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public BatchDeleteTopicReviewedAnswerResponse build() {
            return new BatchDeleteTopicReviewedAnswerResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeleteTopicReviewedAnswerResponse> {
        public Builder topicId(String var1);

        public Builder topicArn(String var1);

        public Builder succeededAnswers(Collection<SucceededTopicReviewedAnswer> var1);

        public Builder succeededAnswers(SucceededTopicReviewedAnswer ... var1);

        public Builder succeededAnswers(Consumer<SucceededTopicReviewedAnswer.Builder> ... var1);

        public Builder invalidAnswers(Collection<InvalidTopicReviewedAnswer> var1);

        public Builder invalidAnswers(InvalidTopicReviewedAnswer ... var1);

        public Builder invalidAnswers(Consumer<InvalidTopicReviewedAnswer.Builder> ... var1);

        public Builder requestId(String var1);

        public Builder status(Integer var1);
    }
}

