/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.RowAlternateColorOptions;
import software.amazon.awssdk.services.quicksight.model.TableCellStyle;
import software.amazon.awssdk.services.quicksight.model.TableOrientation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TableOptions> {
    private static final SdkField<String> ORIENTATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Orientation").getter(TableOptions.getter(TableOptions::orientationAsString)).setter(TableOptions.setter(Builder::orientation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Orientation").build()}).build();
    private static final SdkField<TableCellStyle> HEADER_STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HeaderStyle").getter(TableOptions.getter(TableOptions::headerStyle)).setter(TableOptions.setter(Builder::headerStyle)).constructor(TableCellStyle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeaderStyle").build()}).build();
    private static final SdkField<TableCellStyle> CELL_STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CellStyle").getter(TableOptions.getter(TableOptions::cellStyle)).setter(TableOptions.setter(Builder::cellStyle)).constructor(TableCellStyle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CellStyle").build()}).build();
    private static final SdkField<RowAlternateColorOptions> ROW_ALTERNATE_COLOR_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RowAlternateColorOptions").getter(TableOptions.getter(TableOptions::rowAlternateColorOptions)).setter(TableOptions.setter(Builder::rowAlternateColorOptions)).constructor(RowAlternateColorOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowAlternateColorOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORIENTATION_FIELD, HEADER_STYLE_FIELD, CELL_STYLE_FIELD, ROW_ALTERNATE_COLOR_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TableOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String orientation;
    private final TableCellStyle headerStyle;
    private final TableCellStyle cellStyle;
    private final RowAlternateColorOptions rowAlternateColorOptions;

    private TableOptions(BuilderImpl builder) {
        this.orientation = builder.orientation;
        this.headerStyle = builder.headerStyle;
        this.cellStyle = builder.cellStyle;
        this.rowAlternateColorOptions = builder.rowAlternateColorOptions;
    }

    public final TableOrientation orientation() {
        return TableOrientation.fromValue(this.orientation);
    }

    public final String orientationAsString() {
        return this.orientation;
    }

    public final TableCellStyle headerStyle() {
        return this.headerStyle;
    }

    public final TableCellStyle cellStyle() {
        return this.cellStyle;
    }

    public final RowAlternateColorOptions rowAlternateColorOptions() {
        return this.rowAlternateColorOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.orientationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.headerStyle());
        hashCode = 31 * hashCode + Objects.hashCode(this.cellStyle());
        hashCode = 31 * hashCode + Objects.hashCode(this.rowAlternateColorOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableOptions)) {
            return false;
        }
        TableOptions other = (TableOptions)obj;
        return Objects.equals(this.orientationAsString(), other.orientationAsString()) && Objects.equals(this.headerStyle(), other.headerStyle()) && Objects.equals(this.cellStyle(), other.cellStyle()) && Objects.equals(this.rowAlternateColorOptions(), other.rowAlternateColorOptions());
    }

    public final String toString() {
        return ToString.builder((String)"TableOptions").add("Orientation", (Object)this.orientationAsString()).add("HeaderStyle", (Object)this.headerStyle()).add("CellStyle", (Object)this.cellStyle()).add("RowAlternateColorOptions", (Object)this.rowAlternateColorOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Orientation": {
                return Optional.ofNullable(clazz.cast(this.orientationAsString()));
            }
            case "HeaderStyle": {
                return Optional.ofNullable(clazz.cast(this.headerStyle()));
            }
            case "CellStyle": {
                return Optional.ofNullable(clazz.cast(this.cellStyle()));
            }
            case "RowAlternateColorOptions": {
                return Optional.ofNullable(clazz.cast(this.rowAlternateColorOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Orientation", ORIENTATION_FIELD);
        map.put("HeaderStyle", HEADER_STYLE_FIELD);
        map.put("CellStyle", CELL_STYLE_FIELD);
        map.put("RowAlternateColorOptions", ROW_ALTERNATE_COLOR_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TableOptions, T> g) {
        return obj -> g.apply((TableOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String orientation;
        private TableCellStyle headerStyle;
        private TableCellStyle cellStyle;
        private RowAlternateColorOptions rowAlternateColorOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(TableOptions model) {
            this.orientation(model.orientation);
            this.headerStyle(model.headerStyle);
            this.cellStyle(model.cellStyle);
            this.rowAlternateColorOptions(model.rowAlternateColorOptions);
        }

        public final String getOrientation() {
            return this.orientation;
        }

        public final void setOrientation(String orientation) {
            this.orientation = orientation;
        }

        @Override
        public final Builder orientation(String orientation) {
            this.orientation = orientation;
            return this;
        }

        @Override
        public final Builder orientation(TableOrientation orientation) {
            this.orientation(orientation == null ? null : orientation.toString());
            return this;
        }

        public final TableCellStyle.Builder getHeaderStyle() {
            return this.headerStyle != null ? this.headerStyle.toBuilder() : null;
        }

        public final void setHeaderStyle(TableCellStyle.BuilderImpl headerStyle) {
            this.headerStyle = headerStyle != null ? headerStyle.build() : null;
        }

        @Override
        public final Builder headerStyle(TableCellStyle headerStyle) {
            this.headerStyle = headerStyle;
            return this;
        }

        public final TableCellStyle.Builder getCellStyle() {
            return this.cellStyle != null ? this.cellStyle.toBuilder() : null;
        }

        public final void setCellStyle(TableCellStyle.BuilderImpl cellStyle) {
            this.cellStyle = cellStyle != null ? cellStyle.build() : null;
        }

        @Override
        public final Builder cellStyle(TableCellStyle cellStyle) {
            this.cellStyle = cellStyle;
            return this;
        }

        public final RowAlternateColorOptions.Builder getRowAlternateColorOptions() {
            return this.rowAlternateColorOptions != null ? this.rowAlternateColorOptions.toBuilder() : null;
        }

        public final void setRowAlternateColorOptions(RowAlternateColorOptions.BuilderImpl rowAlternateColorOptions) {
            this.rowAlternateColorOptions = rowAlternateColorOptions != null ? rowAlternateColorOptions.build() : null;
        }

        @Override
        public final Builder rowAlternateColorOptions(RowAlternateColorOptions rowAlternateColorOptions) {
            this.rowAlternateColorOptions = rowAlternateColorOptions;
            return this;
        }

        public TableOptions build() {
            return new TableOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TableOptions> {
        public Builder orientation(String var1);

        public Builder orientation(TableOrientation var1);

        public Builder headerStyle(TableCellStyle var1);

        default public Builder headerStyle(Consumer<TableCellStyle.Builder> headerStyle) {
            return this.headerStyle((TableCellStyle)((TableCellStyle.Builder)TableCellStyle.builder().applyMutation(headerStyle)).build());
        }

        public Builder cellStyle(TableCellStyle var1);

        default public Builder cellStyle(Consumer<TableCellStyle.Builder> cellStyle) {
            return this.cellStyle((TableCellStyle)((TableCellStyle.Builder)TableCellStyle.builder().applyMutation(cellStyle)).build());
        }

        public Builder rowAlternateColorOptions(RowAlternateColorOptions var1);

        default public Builder rowAlternateColorOptions(Consumer<RowAlternateColorOptions.Builder> rowAlternateColorOptions) {
            return this.rowAlternateColorOptions((RowAlternateColorOptions)((RowAlternateColorOptions.Builder)RowAlternateColorOptions.builder().applyMutation(rowAlternateColorOptions)).build());
        }
    }
}

