/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.DayOfTheWeek;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetOptions> {
    private static final SdkField<String> TIMEZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Timezone").getter(AssetOptions.getter(AssetOptions::timezone)).setter(AssetOptions.setter(Builder::timezone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()}).build();
    private static final SdkField<String> WEEK_START_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WeekStart").getter(AssetOptions.getter(AssetOptions::weekStartAsString)).setter(AssetOptions.setter(Builder::weekStart)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeekStart").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMEZONE_FIELD, WEEK_START_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssetOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String timezone;
    private final String weekStart;

    private AssetOptions(BuilderImpl builder) {
        this.timezone = builder.timezone;
        this.weekStart = builder.weekStart;
    }

    public final String timezone() {
        return this.timezone;
    }

    public final DayOfTheWeek weekStart() {
        return DayOfTheWeek.fromValue(this.weekStart);
    }

    public final String weekStartAsString() {
        return this.weekStart;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timezone());
        hashCode = 31 * hashCode + Objects.hashCode(this.weekStartAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetOptions)) {
            return false;
        }
        AssetOptions other = (AssetOptions)obj;
        return Objects.equals(this.timezone(), other.timezone()) && Objects.equals(this.weekStartAsString(), other.weekStartAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AssetOptions").add("Timezone", (Object)this.timezone()).add("WeekStart", (Object)this.weekStartAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Timezone": {
                return Optional.ofNullable(clazz.cast(this.timezone()));
            }
            case "WeekStart": {
                return Optional.ofNullable(clazz.cast(this.weekStartAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Timezone", TIMEZONE_FIELD);
        map.put("WeekStart", WEEK_START_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssetOptions, T> g) {
        return obj -> g.apply((AssetOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String timezone;
        private String weekStart;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetOptions model) {
            this.timezone(model.timezone);
            this.weekStart(model.weekStart);
        }

        public final String getTimezone() {
            return this.timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final String getWeekStart() {
            return this.weekStart;
        }

        public final void setWeekStart(String weekStart) {
            this.weekStart = weekStart;
        }

        @Override
        public final Builder weekStart(String weekStart) {
            this.weekStart = weekStart;
            return this;
        }

        @Override
        public final Builder weekStart(DayOfTheWeek weekStart) {
            this.weekStart(weekStart == null ? null : weekStart.toString());
            return this;
        }

        public AssetOptions build() {
            return new AssetOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetOptions> {
        public Builder timezone(String var1);

        public Builder weekStart(String var1);

        public Builder weekStart(DayOfTheWeek var1);
    }
}

