/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.AnswerIdsCopier;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteTopicReviewedAnswerRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, BatchDeleteTopicReviewedAnswerRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(BatchDeleteTopicReviewedAnswerRequest.getter(BatchDeleteTopicReviewedAnswerRequest::awsAccountId)).setter(BatchDeleteTopicReviewedAnswerRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> TOPIC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TopicId").getter(BatchDeleteTopicReviewedAnswerRequest.getter(BatchDeleteTopicReviewedAnswerRequest::topicId)).setter(BatchDeleteTopicReviewedAnswerRequest.setter(Builder::topicId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("TopicId").build()}).build();
    private static final SdkField<List<String>> ANSWER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AnswerIds").getter(BatchDeleteTopicReviewedAnswerRequest.getter(BatchDeleteTopicReviewedAnswerRequest::answerIds)).setter(BatchDeleteTopicReviewedAnswerRequest.setter(Builder::answerIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnswerIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, TOPIC_ID_FIELD, ANSWER_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchDeleteTopicReviewedAnswerRequest.memberNameToFieldInitializer();
    private final String awsAccountId;
    private final String topicId;
    private final List<String> answerIds;

    private BatchDeleteTopicReviewedAnswerRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.topicId = builder.topicId;
        this.answerIds = builder.answerIds;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String topicId() {
        return this.topicId;
    }

    public final boolean hasAnswerIds() {
        return this.answerIds != null && !(this.answerIds instanceof SdkAutoConstructList);
    }

    public final List<String> answerIds() {
        return this.answerIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnswerIds() ? this.answerIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteTopicReviewedAnswerRequest)) {
            return false;
        }
        BatchDeleteTopicReviewedAnswerRequest other = (BatchDeleteTopicReviewedAnswerRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.topicId(), other.topicId()) && this.hasAnswerIds() == other.hasAnswerIds() && Objects.equals(this.answerIds(), other.answerIds());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDeleteTopicReviewedAnswerRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("TopicId", (Object)this.topicId()).add("AnswerIds", this.hasAnswerIds() ? this.answerIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "TopicId": {
                return Optional.ofNullable(clazz.cast(this.topicId()));
            }
            case "AnswerIds": {
                return Optional.ofNullable(clazz.cast(this.answerIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("TopicId", TOPIC_ID_FIELD);
        map.put("AnswerIds", ANSWER_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteTopicReviewedAnswerRequest, T> g) {
        return obj -> g.apply((BatchDeleteTopicReviewedAnswerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String topicId;
        private List<String> answerIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteTopicReviewedAnswerRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.topicId(model.topicId);
            this.answerIds(model.answerIds);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getTopicId() {
            return this.topicId;
        }

        public final void setTopicId(String topicId) {
            this.topicId = topicId;
        }

        @Override
        public final Builder topicId(String topicId) {
            this.topicId = topicId;
            return this;
        }

        public final Collection<String> getAnswerIds() {
            if (this.answerIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.answerIds;
        }

        public final void setAnswerIds(Collection<String> answerIds) {
            this.answerIds = AnswerIdsCopier.copy(answerIds);
        }

        @Override
        public final Builder answerIds(Collection<String> answerIds) {
            this.answerIds = AnswerIdsCopier.copy(answerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder answerIds(String ... answerIds) {
            this.answerIds(Arrays.asList(answerIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDeleteTopicReviewedAnswerRequest build() {
            return new BatchDeleteTopicReviewedAnswerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeleteTopicReviewedAnswerRequest> {
        public Builder awsAccountId(String var1);

        public Builder topicId(String var1);

        public Builder answerIds(Collection<String> var1);

        public Builder answerIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

